/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedFunction;

public abstract class AbstractAsyncFunctionRunner<T>
extends RichAsyncFunction<RowData, RowData> {
    protected final GeneratedFunction<AsyncFunction<RowData, T>> generatedFetcher;
    protected transient AsyncFunction<RowData, T> fetcher;

    public AbstractAsyncFunctionRunner(GeneratedFunction<AsyncFunction<RowData, T>> generatedFetcher) {
        this.generatedFetcher = generatedFetcher;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.fetcher = (AsyncFunction)this.generatedFetcher.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, (OpenContext)openContext);
    }

    public void close() throws Exception {
        super.close();
        if (this.fetcher != null) {
            FunctionUtils.closeFunction(this.fetcher);
        }
    }
}

