/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaErrorHandler;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.apache.directory.api.ldap.model.schema.registries.SchemaObjectRegistry;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultSchemaObjectRegistry<T extends SchemaObject>
implements SchemaObjectRegistry<T>,
Iterable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaObjectRegistry.class);
    protected Map<String, T> byName = new HashMap<String, T>();
    protected SchemaObjectType schemaObjectType;
    protected OidRegistry<T> oidRegistry;
    private boolean isRelaxed;
    private SchemaErrorHandler errorHandler;

    protected DefaultSchemaObjectRegistry(SchemaObjectType schemaObjectType, OidRegistry<T> oidRegistry) {
        this.schemaObjectType = schemaObjectType;
        this.oidRegistry = oidRegistry;
        this.isRelaxed = false;
    }

    public boolean isRelaxed() {
        return this.isRelaxed;
    }

    public boolean isStrict() {
        return !this.isRelaxed;
    }

    public void setRelaxed() {
        this.isRelaxed = true;
        this.oidRegistry.setRelaxed();
    }

    public void setStrict() {
        this.isRelaxed = false;
        this.oidRegistry.setStrict();
    }

    public SchemaErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SchemaErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.oidRegistry.setErrorHandler(errorHandler);
    }

    @Override
    public boolean contains(String oid) {
        if (!this.byName.containsKey(oid)) {
            return this.byName.containsKey(Strings.toLowerCaseAscii((String)oid));
        }
        return true;
    }

    @Override
    public String getSchemaName(String oid) throws LdapException {
        if (!Oid.isOid((String)oid)) {
            String msg = I18n.err((I18n)I18n.ERR_13733_ARG_NOT_NUMERIC_OID, (Object[])new Object[0]);
            if (LOG.isWarnEnabled()) {
                LOG.warn(msg);
            }
            throw new LdapException(msg);
        }
        SchemaObject schemaObject = (SchemaObject)this.byName.get(oid);
        if (schemaObject != null) {
            return schemaObject.getSchemaName();
        }
        String msg = I18n.err((I18n)I18n.ERR_13734_OID_NOT_FOUND, (Object[])new Object[]{oid});
        if (LOG.isWarnEnabled()) {
            LOG.warn(msg);
        }
        throw new LdapException(msg);
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        for (SchemaObject schemaObject : this) {
            if (!originalSchemaName.equalsIgnoreCase(schemaObject.getSchemaName())) continue;
            schemaObject.setSchemaName(newSchemaName);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(I18n.msg((I18n)I18n.MSG_13722_RENAMED_SCHEMA_NAME_TO, (Object[])new Object[]{schemaObject, newSchemaName}));
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.oidRegistry.iterator();
    }

    @Override
    public Iterator<String> oidsIterator() {
        return this.byName.keySet().iterator();
    }

    @Override
    public T lookup(String oid) throws LdapException {
        if (oid == null) {
            return null;
        }
        SchemaObject schemaObject = (SchemaObject)this.byName.get(oid);
        if (schemaObject == null && (schemaObject = (SchemaObject)this.byName.get(Strings.trim((String)Strings.toLowerCaseAscii((String)oid)))) == null) {
            String msg = I18n.err((I18n)I18n.ERR_13735_ELEMENT_FOR_OID_DOES_NOT_EXIST, (Object[])new Object[]{this.schemaObjectType.name(), oid});
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new LdapException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_13723_FOUND_WITH_OID, (Object[])new Object[]{schemaObject, oid}));
        }
        return (T)schemaObject;
    }

    @Override
    public void register(T schemaObject) throws LdapException {
        String oid = schemaObject.getOid();
        if (this.byName.containsKey(oid)) {
            String msg = I18n.err((I18n)I18n.ERR_13736_ELEMENT_FOR_OID_ALREADY_REGISTERED, (Object[])new Object[]{this.schemaObjectType.name(), oid});
            if (LOG.isWarnEnabled()) {
                LOG.warn(msg);
            }
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OID_ALREADY_REGISTERED, msg);
            ldapSchemaException.setSourceObject((SchemaObject)schemaObject);
            throw ldapSchemaException;
        }
        this.byName.put(oid, schemaObject);
        for (String name : schemaObject.getNames()) {
            String lowerName = Strings.trim((String)Strings.toLowerCaseAscii((String)name));
            if (this.byName.containsKey(lowerName)) {
                String msg = I18n.err((I18n)I18n.ERR_13737_ELEMENT_WITH_NAME_ALREADY_REGISTERED, (Object[])new Object[]{this.schemaObjectType.name(), name});
                if (LOG.isWarnEnabled()) {
                    LOG.warn(msg);
                }
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.NAME_ALREADY_REGISTERED, msg);
                ldapSchemaException.setSourceObject((SchemaObject)schemaObject);
                throw ldapSchemaException;
            }
            this.byName.put(lowerName, schemaObject);
        }
        this.oidRegistry.register(schemaObject);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_13731_REGISTRED_FOR_OID, (Object[])new Object[]{schemaObject.getName(), oid}));
        }
    }

    @Override
    public T unregister(String numericOid) throws LdapException {
        if (!Oid.isOid((String)numericOid)) {
            String msg = I18n.err((I18n)I18n.ERR_13738_OID_NOT_A_NUMERIC_OID, (Object[])new Object[]{numericOid});
            LOG.error(msg);
            throw new LdapException(msg);
        }
        SchemaObject schemaObject = (SchemaObject)this.byName.remove(numericOid);
        for (String name : schemaObject.getNames()) {
            this.byName.remove(name);
        }
        this.oidRegistry.unregister(numericOid);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_13702_REMOVED_FROM_REGISTRY, (Object[])new Object[]{schemaObject, numericOid}));
        }
        return (T)schemaObject;
    }

    @Override
    public T unregister(T schemaObject) throws LdapException {
        String oid = schemaObject.getOid();
        if (!this.byName.containsKey(oid)) {
            String msg = I18n.err((I18n)I18n.ERR_13739_ELEMENT_WITH_OID_NOT_REGISTERED, (Object[])new Object[]{this.schemaObjectType.name(), oid});
            if (LOG.isWarnEnabled()) {
                LOG.warn(msg);
            }
            throw new LdapException(msg);
        }
        SchemaObject removed = (SchemaObject)this.byName.remove(oid);
        for (String name : schemaObject.getNames()) {
            this.byName.remove(Strings.trim((String)Strings.toLowerCaseAscii((String)name)));
        }
        this.oidRegistry.unregister(oid);
        return (T)removed;
    }

    @Override
    public void unregisterSchemaElements(String schemaName) throws LdapException {
        if (schemaName == null) {
            return;
        }
        for (SchemaObject schemaObject : this) {
            if (!schemaName.equalsIgnoreCase(schemaObject.getSchemaName())) continue;
            String oid = schemaObject.getOid();
            String removed = this.unregister((T)oid);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(I18n.msg((I18n)I18n.MSG_13702_REMOVED_FROM_REGISTRY, (Object[])new Object[]{removed, oid}));
        }
    }

    @Override
    public String getOidByName(String name) throws LdapException {
        String lowerCased;
        SchemaObject schemaObject = (SchemaObject)this.byName.get(name);
        if (schemaObject == null && (schemaObject = (SchemaObject)this.byName.get(lowerCased = Strings.toLowerCaseAscii((String)name))) == null) {
            throw new LdapException(I18n.err((I18n)I18n.ERR_13740_CANNOT_FIND_OID_FROM_NAME, (Object[])new Object[]{name}));
        }
        return schemaObject.getOid();
    }

    public SchemaObjectRegistry<T> copy(SchemaObjectRegistry<T> original) {
        for (Map.Entry<String, T> entry : ((DefaultSchemaObjectRegistry)original).byName.entrySet()) {
            String key = entry.getKey();
            SchemaObject value = (SchemaObject)entry.getValue();
            if (value instanceof LoadableSchemaObject) {
                this.byName.put(key, value);
                this.oidRegistry.put(value);
                continue;
            }
            SchemaObject copiedValue = null;
            if (this.oidRegistry.contains(value.getOid())) {
                try {
                    copiedValue = this.oidRegistry.getSchemaObject(value.getOid());
                }
                catch (LdapException ldapException) {}
            } else {
                copiedValue = value.copy();
            }
            this.byName.put(key, copiedValue);
            this.oidRegistry.put(copiedValue);
        }
        return this;
    }

    @Override
    public T get(String oid) {
        try {
            return this.oidRegistry.getSchemaObject(oid);
        }
        catch (LdapException ne) {
            return null;
        }
    }

    @Override
    public SchemaObjectType getType() {
        return this.schemaObjectType;
    }

    @Override
    public int size() {
        return this.oidRegistry.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.schemaObjectType).append(": ");
        boolean isFirst = true;
        for (Map.Entry<String, T> entry : this.byName.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            String name = entry.getKey();
            SchemaObject schemaObject = (SchemaObject)entry.getValue();
            sb.append('<').append(name).append(", ").append(schemaObject.getOid()).append('>');
        }
        return sb.toString();
    }

    @Override
    public void clear() {
        for (SchemaObject schemaObject : this.oidRegistry) {
            if (schemaObject instanceof LoadableSchemaObject) continue;
            schemaObject.clear();
        }
        this.byName.clear();
        this.oidRegistry.clear();
    }
}

