/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.BaseHllSketch;
import org.apache.datasketches.hll.CompositeInterpolationXTable;
import org.apache.datasketches.hll.CubicInterpolation;
import org.apache.datasketches.hll.HarmonicNumbers;

class HllEstimators {
    HllEstimators() {
    }

    static final double hllLowerBound(AbstractHllArray absHllArr, int numStdDev) {
        int lgConfigK = absHllArr.lgConfigK;
        int configK = 1 << lgConfigK;
        double numNonZeros = absHllArr.getCurMin() == 0 ? (double)(configK - absHllArr.getNumAtCurMin()) : (double)configK;
        double estimate = absHllArr.getEstimate();
        boolean oooFlag = absHllArr.isOutOfOrder();
        double relErr = BaseHllSketch.getRelErr(false, oooFlag, lgConfigK, numStdDev);
        return Math.max(estimate / (1.0 + relErr), numNonZeros);
    }

    static final double hllUpperBound(AbstractHllArray absHllArr, int numStdDev) {
        int lgConfigK = absHllArr.lgConfigK;
        double estimate = absHllArr.getEstimate();
        boolean oooFlag = absHllArr.isOutOfOrder();
        double relErr = BaseHllSketch.getRelErr(true, oooFlag, lgConfigK, numStdDev);
        return estimate / (1.0 - relErr);
    }

    static final double hllCompositeEstimate(AbstractHllArray absHllArr) {
        int lgConfigK = absHllArr.getLgConfigK();
        double rawEst = HllEstimators.getHllRawEstimate(lgConfigK, absHllArr.getKxQ0() + absHllArr.getKxQ1());
        double[] xArr = CompositeInterpolationXTable.xArrs[lgConfigK - 4];
        double yStride = CompositeInterpolationXTable.yStrides[lgConfigK - 4];
        int xArrLen = xArr.length;
        if (rawEst < xArr[0]) {
            return 0.0;
        }
        int xArrLenM1 = xArrLen - 1;
        if (rawEst > xArr[xArrLenM1]) {
            double finalY = yStride * (double)xArrLenM1;
            double factor = finalY / xArr[xArrLenM1];
            return rawEst * factor;
        }
        double adjEst = CubicInterpolation.usingXArrAndYStride(xArr, yStride, rawEst);
        if (adjEst > (double)(3 << lgConfigK)) {
            return adjEst;
        }
        double linEst = HllEstimators.getHllBitMapEstimate(lgConfigK, absHllArr.getCurMin(), absHllArr.getNumAtCurMin());
        double avgEst = (adjEst + linEst) / 2.0;
        double crossOver = 0.64;
        if (lgConfigK == 4) {
            crossOver = 0.718;
        } else if (lgConfigK == 5) {
            crossOver = 0.672;
        }
        return avgEst > crossOver * (double)(1 << lgConfigK) ? adjEst : linEst;
    }

    private static final double getHllBitMapEstimate(int lgConfigK, int curMin, int numAtCurMin) {
        int numUnhitBuckets;
        int configK = 1 << lgConfigK;
        int n = numUnhitBuckets = curMin == 0 ? numAtCurMin : 0;
        if (numUnhitBuckets == 0) {
            return (double)configK * Math.log((double)configK / 0.5);
        }
        int numHitBuckets = configK - numUnhitBuckets;
        return HarmonicNumbers.getBitMapEstimate(configK, numHitBuckets);
    }

    private static final double getHllRawEstimate(int lgConfigK, double kxqSum) {
        int configK = 1 << lgConfigK;
        double correctionFactor = lgConfigK == 4 ? 0.673 : (lgConfigK == 5 ? 0.697 : (lgConfigK == 6 ? 0.709 : 0.7213 / (1.0 + 1.079 / (double)configK)));
        double hyperEst = correctionFactor * (double)configK * (double)configK / kxqSum;
        return hyperEst;
    }
}

