/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectFloatsSketchIteratorTest {
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void emptySketch() {
        KllFloatsSketch sketch = KllDirectFloatsSketchIteratorTest.getDFSketch(200, 0);
        QuantilesFloatsSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllFloatsSketch sketch = KllDirectFloatsSketchIteratorTest.getDFSketch(200, 0);
        sketch.update(0.0f);
        QuantilesFloatsSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((float)it.getQuantile(), (float)0.0f);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            KllFloatsSketch sketch = KllDirectFloatsSketchIteratorTest.getDFSketch(200, 0);
            for (int i = 0; i < n; ++i) {
                sketch.update((float)i);
            }
            QuantilesFloatsSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }

    private static KllFloatsSketch getDFSketch(int k, int n) {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((float)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllFloatsSketch dfsk = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return dfsk;
    }
}

