/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.transports.storage.extensions;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.cassandra.spark.transports.storage.StorageAccessConfiguration;
import org.apache.cassandra.spark.transports.storage.StorageCredentialPair;
import org.jetbrains.annotations.Nullable;

public class StorageTransportConfiguration {
    private final String prefix;
    private final Map<String, String> objectTags;
    private final MultiClusterContainer<StorageAccessConfiguration> readAccessConfigurations;
    private StorageAccessConfiguration writeAccessConfiguration;

    public StorageTransportConfiguration(String writeBucket, String writeRegion, String readBucket, String readRegion, String prefix, StorageCredentialPair storageCredentialPair, Map<String, String> objectTags) {
        this(prefix, objectTags, new StorageAccessConfiguration(writeRegion, writeBucket, storageCredentialPair.writeCredentials), new MultiClusterContainer<StorageAccessConfiguration>());
        StorageAccessConfiguration readAccess = new StorageAccessConfiguration(readRegion, readBucket, storageCredentialPair.readCredentials);
        this.readAccessConfigurations.setValue(null, readAccess);
    }

    public StorageTransportConfiguration(String prefix, Map<String, String> objectTags, StorageAccessConfiguration writeAccessConfiguration, Map<String, StorageAccessConfiguration> readAccessConfigByCluster) {
        this(prefix, objectTags, writeAccessConfiguration, new MultiClusterContainer<StorageAccessConfiguration>());
        this.readAccessConfigurations.addAll(readAccessConfigByCluster);
    }

    private StorageTransportConfiguration(String prefix, Map<String, String> objectTags, StorageAccessConfiguration writeAccessConfiguration, MultiClusterContainer<StorageAccessConfiguration> readAccessConfigurations) {
        this.prefix = prefix;
        this.writeAccessConfiguration = writeAccessConfiguration;
        this.readAccessConfigurations = readAccessConfigurations;
        this.objectTags = Collections.unmodifiableMap(objectTags);
    }

    public StorageAccessConfiguration writeAccessConfiguration() {
        return this.writeAccessConfiguration;
    }

    public StorageAccessConfiguration readAccessConfiguration(@Nullable String clusterId) {
        return this.readAccessConfigurations.getValueOrNull(clusterId);
    }

    public StorageCredentialPair getStorageCredentialPair(@Nullable String clusterId) {
        StorageAccessConfiguration readAccess = (StorageAccessConfiguration)this.readAccessConfigurations.getValueOrThrow(clusterId);
        return new StorageCredentialPair(this.writeAccessConfiguration.region(), this.writeAccessConfiguration.storageCredentials(), readAccess.region(), readAccess.storageCredentials());
    }

    public void setStorageCredentialPair(@Nullable String clusterId, StorageCredentialPair newCredentials) {
        this.writeAccessConfiguration = this.writeAccessConfiguration.copyWithNewCredentials(newCredentials.writeCredentials);
        this.readAccessConfigurations.updateValue(clusterId, readAccess -> readAccess.copyWithNewCredentials(newCredentials.readCredentials));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Map<String, String> getObjectTags() {
        return this.objectTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageTransportConfiguration that = (StorageTransportConfiguration)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.objectTags, that.objectTags) && Objects.equals(this.writeAccessConfiguration, that.writeAccessConfiguration) && Objects.equals(this.readAccessConfigurations, that.readAccessConfigurations);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.objectTags, this.writeAccessConfiguration, this.readAccessConfigurations);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<StorageTransportConfiguration> {
        public void write(Kryo kryo, Output out, StorageTransportConfiguration obj) {
            out.writeString(obj.prefix);
            kryo.writeObject(out, obj.objectTags);
            kryo.writeObject(out, (Object)obj.writeAccessConfiguration);
            kryo.writeObject(out, obj.readAccessConfigurations);
        }

        public StorageTransportConfiguration read(Kryo kryo, Input in, Class<StorageTransportConfiguration> type) {
            return new StorageTransportConfiguration(in.readString(), (Map<String, String>)((Map)kryo.readObject(in, HashMap.class)), (StorageAccessConfiguration)kryo.readObject(in, StorageAccessConfiguration.class), (MultiClusterContainer)kryo.readObject(in, MultiClusterContainer.class));
        }
    }
}

