/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.transports.storage;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Objects;

public class StorageCredentials {
    private final String accessKeyId;
    private final String secretKey;
    private final String sessionToken;

    public static StorageCredentials fromSidecarCredentials(o.a.c.sidecar.client.shaded.common.data.StorageCredentials credentials) {
        return new StorageCredentials(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken());
    }

    public StorageCredentials(String accessKeyId, String secretKey) {
        this(accessKeyId, secretKey, null);
    }

    public StorageCredentials(String accessKeyId, String secretKey, String sessionToken) {
        this.accessKeyId = accessKeyId;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public o.a.c.sidecar.client.shaded.common.data.StorageCredentials toSidecarCredentials(String region) {
        return o.a.c.sidecar.client.shaded.common.data.StorageCredentials.builder().accessKeyId(this.accessKeyId).secretAccessKey(this.secretKey).sessionToken(this.sessionToken).region(region).build();
    }

    public String toString() {
        return "StorageCredentials{accessKeyId='" + this.accessKeyId + "', secretKey='" + this.redact(this.secretKey) + "', sessionToken='" + this.redact(this.sessionToken) + "'}";
    }

    private String redact(String value) {
        if (value == null || value.isEmpty()) {
            return "NOT_PROVIDED";
        }
        return "*****";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageCredentials that = (StorageCredentials)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretKey, that.secretKey) && Objects.equals(this.sessionToken, that.sessionToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.secretKey, this.sessionToken);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<StorageCredentials> {
        public void write(Kryo kryo, Output out, StorageCredentials obj) {
            out.writeString(obj.accessKeyId);
            out.writeString(obj.secretKey);
            out.writeString(obj.sessionToken);
        }

        public StorageCredentials read(Kryo kryo, Input input, Class<StorageCredentials> type) {
            return new StorageCredentials(input.readString(), input.readString(), input.readString());
        }
    }
}

