/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DataChunker {
    private static final int MINIMUM_CHUNK_SIZE_IN_BYTES = 0x500000;
    private final int chunkSizeInBytes;

    public DataChunker(int chunkSizeInBytes) {
        this(chunkSizeInBytes, true);
    }

    @VisibleForTesting
    DataChunker(int chunkSizeInBytes, boolean validate) {
        if (validate) {
            Preconditions.checkArgument((chunkSizeInBytes >= 0x500000 ? 1 : 0) != 0, (Object)"Chunk size is too small. Minimum size: 5242880");
        }
        this.chunkSizeInBytes = chunkSizeInBytes;
    }

    public Iterator<ByteBuffer> chunks(final ReadableByteChannel channel) {
        return new Iterator<ByteBuffer>(){
            private boolean eosReached = false;
            private final ByteBuffer buffer;
            {
                this.buffer = ByteBuffer.allocate(DataChunker.this.chunkSizeInBytes);
            }

            @Override
            public boolean hasNext() {
                this.buffer.clear();
                try {
                    this.eosReached = -1 == channel.read(this.buffer);
                    this.buffer.flip();
                }
                catch (IOException e) {
                    this.eosReached = true;
                }
                return !this.eosReached;
            }

            @Override
            public ByteBuffer next() {
                if (this.eosReached) {
                    throw new NoSuchElementException("End of stream has reached");
                }
                return this.buffer;
            }
        };
    }
}

