/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.StreamError;
import org.apache.cassandra.spark.bulkwriter.StreamResult;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CreatedRestoreSlice;

public class CloudStorageStreamResult
extends StreamResult {
    private static final long serialVersionUID = 9096932762489827053L;
    public final Set<CreatedRestoreSlice> createdRestoreSlices;
    public final int objectCount;

    public static CloudStorageStreamResult empty(String sessionID, Range<BigInteger> tokenRange) {
        return new CloudStorageStreamResult(sessionID, tokenRange, new ArrayList<StreamError>(), new ArrayList<RingInstance>(), new HashSet<CreatedRestoreSlice>(), 0, 0L, 0L);
    }

    public CloudStorageStreamResult(String sessionID, Range<BigInteger> tokenRange, List<StreamError> failures, List<RingInstance> passed, Set<CreatedRestoreSlice> createdRestoreSlices, int objectCount, long rowCount, long bytesWritten) {
        super(sessionID, tokenRange, failures, passed, rowCount, bytesWritten);
        this.createdRestoreSlices = Collections.unmodifiableSet(createdRestoreSlices);
        this.objectCount = objectCount;
    }

    public String toString() {
        return "StreamResult{sessionID='" + this.sessionID + "', tokenRange=" + String.valueOf(this.tokenRange) + ", objectCount=" + this.objectCount + ", rowCount=" + this.rowCount + ", bytesWritten=" + this.bytesWritten + ", failures=" + String.valueOf(this.failures) + ", createdRestoreSlices=" + String.valueOf(this.createdRestoreSlices) + ", passed=" + String.valueOf(this.passed) + "}";
    }
}

