/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.replacement;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.ResiliencyTestBase;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.distributed.api.IInstanceConfig;
import org.apache.cassandra.distributed.shared.NetworkTopology;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.IClusterExtension;
import org.apache.cassandra.testing.utils.ClusterUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;

abstract class HostReplacementTestBase
extends ResiliencyTestBase {
    Dataset<Row> df;
    Map<? extends IInstance, Set<String>> expectedInstanceData;
    List<IInstance> newNodes;
    List<String> removedNodeAddresses;

    HostReplacementTestBase() {
    }

    protected void afterClusterProvisioned() {
        Assertions.assertThat((int)this.additionalNodesToStop()).isLessThan(this.cluster.size() - 1);
        IInstance seed = this.cluster.get(1);
        List ring = ClusterUtils.ring((IInstance)seed);
        List<IInstance> nodesToRemove = Collections.singletonList(this.cluster.get(this.cluster.size()));
        this.removedNodeAddresses = nodesToRemove.stream().map(n -> n.config().broadcastAddress().getAddress().getHostAddress()).collect(Collectors.toList());
        List removedNodeTokens = ring.stream().filter(i -> this.removedNodeAddresses.contains(i.getAddress())).map(ClusterUtils.RingInstanceDetails::getToken).collect(Collectors.toList());
        this.stopNodes(seed, nodesToRemove);
        ArrayList<IInstance> additionalRemovalNodes = new ArrayList<IInstance>();
        for (int i2 = 1; i2 <= this.additionalNodesToStop(); ++i2) {
            additionalRemovalNodes.add(this.cluster.get(this.cluster.size() - i2));
        }
        this.newNodes = this.startReplacementNodes(this.nodeStart(), this.cluster, nodesToRemove);
        this.stopNodes(seed, additionalRemovalNodes);
        for (IInstance newInstance : this.newNodes) {
            this.cluster.awaitRingState(newInstance, newInstance, "Joining");
            this.cluster.awaitGossipStatus(newInstance, newInstance, "BOOT_REPLACE");
            String newAddress = newInstance.config().broadcastAddress().getAddress().getHostAddress();
            Optional<ClusterUtils.RingInstanceDetails> replacementInstance = this.getMatchingInstanceFromRing(newInstance, newAddress);
            Assertions.assertThat(replacementInstance).isPresent();
            Assertions.assertThat(removedNodeTokens).contains((Object[])new String[]{replacementInstance.get().getToken()});
        }
    }

    protected void completeTransitionsAndValidateWrites(CountDownLatch transitionalStateEnd, Stream<Arguments> testInputs, boolean expectFailure) {
        long count = transitionalStateEnd.getCount();
        int i = 0;
        while ((long)i < count) {
            transitionalStateEnd.countDown();
            ++i;
        }
        Assertions.assertThat(this.newNodes).isNotNull();
        Assertions.assertThat(this.removedNodeAddresses).isNotNull();
        if (!expectFailure) {
            this.cluster.awaitRingState(this.newNodes.get(0), this.newNodes.get(0), "Normal");
            testInputs.forEach(arguments -> {
                TestConsistencyLevel cl = (TestConsistencyLevel)arguments.get()[0];
                QualifiedName tableName = HostReplacementTestBase.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
                this.validateNodeSpecificData(tableName, this.expectedInstanceData);
                this.validateData(tableName, cl.readCL, 1000);
            });
        } else {
            Optional<ClusterUtils.RingInstanceDetails> replacementNode = this.getMatchingInstanceFromRing(this.newNodes.get(0), this.newNodes.get(0).broadcastAddress().getAddress().getHostAddress());
            replacementNode.ifPresent(ringInstanceDetails -> Assertions.assertThat((String)ringInstanceDetails.getState()).isNotEqualTo((Object)"Normal"));
            Optional<ClusterUtils.RingInstanceDetails> removedNode = this.getMatchingInstanceFromRing(this.cluster.get(1), this.removedNodeAddresses.get(0));
            removedNode.ifPresent(ringInstanceDetails -> Assertions.assertThat((String)ringInstanceDetails.getStatus()).isEqualTo("Down"));
            testInputs.forEach(arguments -> {
                TestConsistencyLevel cl = (TestConsistencyLevel)arguments.get()[0];
                if (cl.readCL != ConsistencyLevel.ALL) {
                    QualifiedName tableName = HostReplacementTestBase.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
                    this.validateData(tableName, cl.readCL, 1000);
                }
            });
        }
    }

    @Override
    protected void beforeTestStart() {
        super.beforeTestStart();
        SparkSession spark = this.getOrCreateSparkSession();
        this.df = DataGenerationUtils.generateCourseData(spark, 1000);
        this.expectedInstanceData = this.getInstanceData(this.newNodes, true, 1000);
    }

    protected int additionalNodesToStop() {
        return 0;
    }

    protected abstract CountDownLatch nodeStart();

    static Stream<Arguments> singleDCTestInputs() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.QUORUM, ConsistencyLevel.QUORUM)}));
    }

    public static <I extends IInstance> I addInstanceLocal(IClusterExtension<I> cluster, String dc, String rack, Consumer<IInstanceConfig> fn, int remPort) {
        Objects.requireNonNull(dc, "dc");
        Objects.requireNonNull(rack, "rack");
        IInstanceConfig config = cluster.newInstanceConfig();
        config.set("storage_port", (Object)remPort);
        config.networkTopology().put(config.broadcastAddress(), NetworkTopology.dcAndRack((String)dc, (String)rack));
        fn.accept(config);
        return (I)cluster.bootstrap(config);
    }

    private List<IInstance> startReplacementNodes(CountDownLatch nodeStart, IClusterExtension<?> cluster, List<IInstance> nodesToRemove) {
        ArrayList<IInstance> newNodes = new ArrayList<IInstance>();
        for (IInstance removed : nodesToRemove) {
            IInstanceConfig removedConfig = removed.config();
            String remAddress = removedConfig.broadcastAddress().getAddress().getHostAddress();
            int remPort = removedConfig.getInt("storage_port");
            Object replacement = HostReplacementTestBase.addInstanceLocal(cluster, removedConfig.localDatacenter(), removedConfig.localRack(), c -> {
                c.set("auto_bootstrap", (Object)true);
                c.set("dtest.api.startup.failure_as_shutdown", (Object)false);
                c.with(new Feature[]{Feature.GOSSIP, Feature.JMX, Feature.NATIVE_PROTOCOL});
            }, remPort);
            new Thread(() -> ClusterUtils.start((IInstance)replacement, properties -> {
                replacement.config().set("storage_port", (Object)remPort);
                properties.with(new String[]{"cassandra.skip_schema_check", "true"});
                properties.with(new String[]{"cassandra.schema_delay_ms", String.valueOf(TimeUnit.SECONDS.toMillis(10L))});
                properties.with(new String[]{"cassandra.broadcast_interval_ms", Long.toString(TimeUnit.SECONDS.toMillis(30L))});
                properties.with(new String[]{"cassandra.ring_delay_ms", Long.toString(TimeUnit.SECONDS.toMillis(10L))});
                properties.with(new String[]{"cassandra.replace_address_first_boot", remAddress + ":" + remPort});
            })).start();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)nodeStart, (long)2L, (TimeUnit)TimeUnit.MINUTES);
            newNodes.add((IInstance)replacement);
        }
        return newNodes;
    }

    private void stopNodes(IInstance seed, List<IInstance> nodesToRemove) {
        for (IInstance node : nodesToRemove) {
            this.cluster.stopUnchecked(node);
            this.cluster.awaitRingStatus(seed, node, "Down");
        }
    }

    protected Optional<ClusterUtils.RingInstanceDetails> getMatchingInstanceFromRing(IInstance seed, String ipAddress) {
        return ClusterUtils.ring((IInstance)seed).stream().filter(i -> i.getAddress().equals(ipAddress)).findFirst();
    }
}

