/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.expansion;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.expansion.JoiningMultipleNodesTest;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;

class JoiningMultipleNodesFailureTest
extends JoiningMultipleNodesTest {
    JoiningMultipleNodesFailureTest() {
    }

    @Override
    protected void beforeClusterShutdown() {
        this.completeTransitionsAndValidateWrites(BBHelperMultipleJoiningNodesFailure.transitioningStateEnd, JoiningMultipleNodesFailureTest.singleDCTestInputs(), true);
    }

    @Override
    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return JoiningMultipleNodesFailureTest.clusterConfig().nodesPerDc(3).newNodesPerDc(2).requestFeature(Feature.NETWORK).instanceInitializer(BBHelperMultipleJoiningNodesFailure::install);
    }

    @Override
    protected CountDownLatch transitioningStateStart() {
        return BBHelperMultipleJoiningNodesFailure.transitioningStateStart;
    }

    public static class BBHelperMultipleJoiningNodesFailure {
        static final CountDownLatch transitioningStateStart = new CountDownLatch(2);
        static final CountDownLatch transitioningStateEnd = new CountDownLatch(2);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber > 3) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.StorageService").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"bootstrap").and((ElementMatcher)ElementMatchers.takesArguments((int)2))).intercept((Implementation)MethodDelegation.to(BBHelperMultipleJoiningNodesFailure.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static boolean bootstrap(Collection<?> tokens, long bootstrapTimeoutMillis, @SuperCall Callable<Boolean> orig) throws Exception {
            boolean result = orig.call();
            transitioningStateStart.countDown();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)transitioningStateEnd, (long)2L, (TimeUnit)TimeUnit.MINUTES);
            throw new UnsupportedOperationException("Simulated failure");
        }
    }
}

