/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.ICoordinator;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.TimestampOption;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TimestampIntegrationTest
extends SharedClusterSparkIntegrationTestBase {
    static final List<String> DATASET = Arrays.asList("a", "b", "c", "d", "e", "f", "g");
    static final QualifiedName SOURCE_TABLE = TestUtils.uniqueTestTableFullName((String)"spark_test", (String)"source_tbl");
    static final QualifiedName TARGET_TABLE = TestUtils.uniqueTestTableFullName((String)"spark_test", (String)"target_tbl");
    static final List<QualifiedName> TABLE_NAMES = Arrays.asList(SOURCE_TABLE, TARGET_TABLE);

    TimestampIntegrationTest() {
    }

    @Test
    void testReadingAndWritingTimestamp() {
        Dataset data = this.bulkReaderDataFrame(SOURCE_TABLE).option("lastModifiedColumnName", "lm").load();
        Assertions.assertThat((long)data.count()).isEqualTo((long)DATASET.size());
        List<Row> rowList = data.collectAsList().stream().sorted(Comparator.comparing(row -> row.getInt(0))).collect(Collectors.toList());
        this.bulkWriterDataFrameWriter((Dataset<Row>)data, TARGET_TABLE).option(WriterOptions.TIMESTAMP.name(), TimestampOption.perRow((String)"lm")).save();
        this.validateWrites(TARGET_TABLE, rowList);
    }

    protected void initializeSchemaForTest() {
        long desiredTimestamp = 1432815430948567L;
        TABLE_NAMES.forEach(name -> {
            this.createTestKeyspace((QualifiedName)name, TestUtils.DC1_RF1);
            this.createTestTable((QualifiedName)name, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
        this.populateTable(SOURCE_TABLE, DATASET, desiredTimestamp);
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(3);
    }

    void validateWrites(QualifiedName tableName, List<Row> sourceData) {
        String query = String.format("SELECT id, course, marks, WRITETIME(course) FROM %s;", tableName);
        Set actualEntries = Arrays.stream(this.cluster.coordinator(1).execute(String.format(query, tableName), ConsistencyLevel.ALL, new Object[0])).map(columns -> String.format("%s:%s:%s:%s", columns[0], columns[1], columns[2], columns[3])).collect(Collectors.toSet());
        Assertions.assertThat((int)actualEntries.size()).isEqualTo(sourceData.size());
        sourceData.forEach(row -> {
            Instant instant = row.getTimestamp(3).toInstant();
            long timeInMicros = TimeUnit.SECONDS.toMicros(instant.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(instant.getNano());
            String key = String.format("%d:%s:%d:%s", row.getInt(0), row.getString(1), row.getInt(2), timeInMicros);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualEntries.remove(key)).as(key + " is expected to exist in the actual entries", new Object[0])).isTrue();
        });
        ((AbstractCollectionAssert)Assertions.assertThat(actualEntries).as("All entries are expected to be read from database", new Object[0])).isEmpty();
    }

    void populateTable(QualifiedName tableName, List<String> values, long desiredTimestamp) {
        ICoordinator coordinator = this.cluster.getFirstRunningInstance().coordinator();
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            String query = String.format("INSERT INTO %s (id, course, marks) VALUES (%d,'%s',%d) USING TIMESTAMP %d", tableName, i, "course_" + value, 80 + i, desiredTimestamp);
            coordinator.execute(query, ConsistencyLevel.ALL, new Object[0]);
        }
    }
}

