/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.cassandra.analytics.reader.common.RawInputStream;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.reader.common.BigLongArray;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompressionInputStreamTests {
    @Test
    public void testRawInputStream() throws IOException {
        String filename = UUID.randomUUID().toString();
        Path path = Files.createTempFile(filename, "tmp", new FileAttribute[0]);
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path.toFile())));){
            int write;
            dos.writeUTF(filename);
            int numWrites = 1000;
            dos.writeInt(numWrites);
            for (write = 0; write < numWrites; ++write) {
                dos.writeInt(write);
            }
            for (write = 0; write < numWrites; ++write) {
                dos.writeLong(write);
            }
            dos.writeBoolean(false);
            dos.writeBoolean(true);
        }
        byte[] buffer = new byte[1024];
        try (DataInputStream dis = new DataInputStream((InputStream)new RawInputStream(new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]))), buffer, (Stats)Stats.DoNothingStats.INSTANCE));){
            int read;
            Assertions.assertThat((String)dis.readUTF()).isEqualTo(filename);
            int numReads = dis.readInt();
            for (read = 0; read < numReads; ++read) {
                Assertions.assertThat((int)dis.readInt()).isEqualTo(read);
            }
            for (read = 0; read < numReads; ++read) {
                Assertions.assertThat((long)dis.readLong()).isEqualTo((long)read);
            }
            Assertions.assertThat((boolean)dis.readBoolean()).isFalse();
            Assertions.assertThat((boolean)dis.readBoolean()).isTrue();
        }
    }

    @Test
    public void testBigLongArrayIllegalSize() {
        Assertions.assertThatThrownBy(() -> new BigLongArray(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void testBigLongArrayEmpty() {
        Assertions.assertThatThrownBy(() -> {
            BigLongArray array = new BigLongArray(0);
            array.set(0, 0L);
        }).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void testBigLongArrayOutOfRange() {
        Assertions.assertThatThrownBy(() -> {
            BigLongArray array = new BigLongArray(500);
            array.set(501, 999L);
        }).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void testBigLongArrayUnary() {
        BigLongArray array = new BigLongArray(1);
        array.set(0, 999L);
        Assertions.assertThat((long)array.get(0)).isEqualTo(999L);
    }

    @Test
    public void testBigLongArray() {
        int index;
        int size = 151552;
        BigLongArray array = new BigLongArray(size);
        for (index = 0; index < size; ++index) {
            array.set(index, (long)index * 5L);
        }
        for (index = 0; index < size; ++index) {
            Assertions.assertThat((long)array.get(index)).isEqualTo((long)index * 5L);
        }
    }
}

