/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import o.a.c.sidecar.client.shaded.common.response.TokenRangeReplicasResponse;
import o.a.c.sidecar.client.shaded.common.response.data.RingEntry;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.model.NodeStatus;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.RangeUtils;

public final class TokenRangeMappingUtils {
    private TokenRangeMappingUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static TokenRangeMapping<RingInstance> buildTokenRangeMapping(int initialToken, ImmutableMap<String, Integer> rfByDC, int instancesPerDC) {
        return TokenRangeMappingUtils.buildTokenRangeMapping(initialToken, rfByDC, instancesPerDC, false, -1);
    }

    public static TokenRangeMapping<RingInstance> buildTokenRangeMappingWithFailures(int initialToken, ImmutableMap<String, Integer> rfByDC, int instancesPerDC) {
        List<RingInstance> instances = TokenRangeMappingUtils.getInstances(initialToken, rfByDC, instancesPerDC);
        RingInstance instance = instances.remove(0);
        RingEntry entry = instance.ringEntry();
        RingEntry newEntry = new RingEntry.Builder().datacenter(entry.datacenter()).port(entry.port()).address(entry.address()).status(NodeStatus.DOWN.name()).state(entry.state()).token(entry.token()).fqdn(entry.fqdn()).rack(entry.rack()).owns(entry.owns()).load(entry.load()).hostId(entry.hostId()).build();
        RingInstance newInstance = new RingInstance(newEntry);
        instances.add(0, newInstance);
        ReplicationFactor replicationFactor = TokenRangeMappingUtils.getReplicationFactor(rfByDC);
        Multimap<RingInstance, Range<BigInteger>> tokenRanges = TokenRangeMappingUtils.setupTokenRangeMap(Partitioner.Murmur3Partitioner, replicationFactor, instances);
        return new TokenRangeMapping(Partitioner.Murmur3Partitioner, tokenRanges, new HashSet<RingInstance>(instances));
    }

    public static TokenRangeMapping<RingInstance> buildTokenRangeMapping(int initialToken, ImmutableMap<String, Integer> rfByDC, int instancesPerDC, boolean shouldUpdateToken, int moveTargetToken) {
        List<RingInstance> instances = TokenRangeMappingUtils.getInstances(initialToken, rfByDC, instancesPerDC);
        if (shouldUpdateToken) {
            RingInstance instance = instances.remove(0);
            RingEntry entry = instance.ringEntry();
            RingEntry newEntry = new RingEntry.Builder().datacenter(entry.datacenter()).port(entry.port()).address(entry.address()).status(entry.status()).state(entry.state()).token(String.valueOf(moveTargetToken)).fqdn(entry.fqdn()).rack(entry.rack()).owns(entry.owns()).load(entry.load()).hostId(entry.hostId()).build();
            RingInstance newInstance = new RingInstance(newEntry);
            instances.add(0, newInstance);
        }
        ReplicationFactor replicationFactor = TokenRangeMappingUtils.getReplicationFactor(rfByDC);
        Multimap<RingInstance, Range<BigInteger>> tokenRanges = TokenRangeMappingUtils.setupTokenRangeMap(Partitioner.Murmur3Partitioner, replicationFactor, instances);
        return new TokenRangeMapping(Partitioner.Murmur3Partitioner, tokenRanges, new HashSet<RingInstance>(instances));
    }

    public static Multimap<RingInstance, Range<BigInteger>> setupTokenRangeMap(Partitioner partitioner, ReplicationFactor replicationFactor, List<RingInstance> instances) {
        ArrayListMultimap tokenRangeMap = ArrayListMultimap.create();
        if (replicationFactor.getReplicationStrategy() == ReplicationFactor.ReplicationStrategy.SimpleStrategy) {
            tokenRangeMap.putAll(RangeUtils.calculateTokenRanges(instances, (int)replicationFactor.getTotalReplicationFactor(), (Partitioner)partitioner));
        } else if (replicationFactor.getReplicationStrategy() == ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy) {
            for (String dataCenter : replicationFactor.getOptions().keySet()) {
                int rf = (Integer)replicationFactor.getOptions().get(dataCenter);
                if (rf == 0) continue;
                List dcInstances = instances.stream().filter(instance -> instance.datacenter().matches(dataCenter)).collect(Collectors.toList());
                tokenRangeMap.putAll(RangeUtils.calculateTokenRanges(dcInstances, (int)((Integer)replicationFactor.getOptions().get(dataCenter)), (Partitioner)partitioner));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported replication strategy");
        }
        return tokenRangeMap;
    }

    @NotNull
    private static ReplicationFactor getReplicationFactor(Map<String, Integer> rfByDC) {
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder().put((Object)"class", (Object)"org.apache.cassandra.locator.NetworkTopologyStrategy");
        rfByDC.forEach((key, value) -> optionsBuilder.put(key, (Object)value.toString()));
        return new ReplicationFactor((Map)optionsBuilder.build());
    }

    @NotNull
    public static List<RingInstance> getInstances(int initialToken, Map<String, Integer> rfByDC, int instancesPerDc) {
        ArrayList<RingInstance> instances = new ArrayList<RingInstance>();
        int dcOffset = 0;
        for (Map.Entry<String, Integer> rfForDC : rfByDC.entrySet()) {
            String datacenter = rfForDC.getKey();
            for (int i = 0; i < instancesPerDc; ++i) {
                int instanceId = i + 1;
                RingEntry.Builder ringEntry = new RingEntry.Builder().address("127.0." + dcOffset + "." + instanceId).datacenter(datacenter).load("0").token(Integer.toString(initialToken + dcOffset + 100000 * i)).fqdn(datacenter + "-i" + instanceId).rack("Rack").hostId("").status("UP").state("NORMAL").owns("");
                instances.add(new RingInstance(ringEntry.build()));
            }
            ++dcOffset;
        }
        return instances;
    }

    public static TokenRangeReplicasResponse mockSimpleTokenRangeReplicasResponse(int instancesCount, int replicationFactor) {
        return TokenRangeMappingUtils.mockSimpleTokenRangeReplicasResponse(0L, instancesCount, replicationFactor);
    }

    public static TokenRangeReplicasResponse mockSimpleTokenRangeReplicasResponse(long startToken, int instancesCount, int replicationFactor) {
        long rangeLength = 100L;
        ArrayList<TokenRangeReplicasResponse.ReplicaInfo> replicaInfoList = new ArrayList<TokenRangeReplicasResponse.ReplicaInfo>(instancesCount);
        HashMap<CallSite, TokenRangeReplicasResponse.ReplicaMetadata> replicaMetadata = new HashMap<CallSite, TokenRangeReplicasResponse.ReplicaMetadata>(instancesCount);
        for (int i = 0; i < instancesCount; ++i) {
            long endToken = startToken + rangeLength;
            ArrayList<CallSite> replicas = new ArrayList<CallSite>(replicationFactor);
            for (int r = 0; r < replicationFactor; ++r) {
                replicas.add((CallSite)((Object)("localhost" + (i + r) % instancesCount + ":9042")));
            }
            HashMap<String, ArrayList<CallSite>> replicasPerDc = new HashMap<String, ArrayList<CallSite>>();
            replicasPerDc.put("dc1", replicas);
            TokenRangeReplicasResponse.ReplicaInfo ri = new TokenRangeReplicasResponse.ReplicaInfo(String.valueOf(startToken), String.valueOf(endToken), replicasPerDc);
            replicaInfoList.add(ri);
            String address = "localhost" + i;
            int port = 9042;
            String addressWithPort = address + ":" + port;
            TokenRangeReplicasResponse.ReplicaMetadata rm = new TokenRangeReplicasResponse.ReplicaMetadata("NORMAL", "UP", address, address, 9042, "dc1");
            replicaMetadata.put((CallSite)((Object)addressWithPort), rm);
            startToken = endToken;
        }
        return new TokenRangeReplicasResponse(replicaInfoList, replicaInfoList, replicaMetadata);
    }
}

