/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.numbersystrem;

import org.psjava.ds.numbersystrem.IntegerDivisableNumberSystem;
import org.psjava.ds.numbersystrem.OverflowException;

public class IntegerNumberSystem
implements IntegerDivisableNumberSystem<Integer> {
    private static final IntegerNumberSystem INSTANCE = new IntegerNumberSystem();

    public static IntegerNumberSystem getInstance() {
        return INSTANCE;
    }

    private IntegerNumberSystem() {
    }

    @Override
    public Integer getZero() {
        return 0;
    }

    @Override
    public Integer getByInt(int v) {
        return v;
    }

    @Override
    public boolean isPositive(Integer v) {
        return v > 0;
    }

    @Override
    public boolean isZero(Integer v) {
        return v == 0;
    }

    @Override
    public boolean isNegative(Integer v) {
        return v < 0;
    }

    @Override
    public int getSign(Integer v) {
        return Integer.signum(v);
    }

    @Override
    public boolean areEqual(Integer o1, Integer o2) {
        return o1.equals(o2);
    }

    @Override
    public Integer getOne() {
        return 1;
    }

    @Override
    public boolean isOne(Integer v) {
        return v == 1;
    }

    @Override
    public Integer add(Integer v1, Integer v2) {
        return this.safeCastFromLong((long)v1.intValue() + (long)v2.intValue());
    }

    @Override
    public Integer subtract(Integer minuend, Integer subtrahend) {
        return this.safeCastFromLong((long)minuend.intValue() - (long)subtrahend.intValue());
    }

    @Override
    public Integer multiply(Integer v1, Integer v2) {
        return this.safeCastFromLong((long)v1.intValue() * (long)v2.intValue());
    }

    @Override
    public Integer integerDivide(Integer dividend, Integer divisor) {
        return dividend / divisor;
    }

    @Override
    public Integer integerRemainder(Integer dividend, Integer divisor) {
        return dividend % divisor;
    }

    private Integer safeCastFromLong(long v) {
        if (v != (long)((int)v)) {
            throw OverflowException.create();
        }
        return (int)v;
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }
}

