/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;

class NativeAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    long total;
    long matched;

    NativeAggregatorFactory() {
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new NativeAggregatorFactory();
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        ++this.total;
        if (threadInfo.stackTrace().isEmpty() || threadInfo.stackTrace().frameAt(0).isNative()) {
            ++this.matched;
        }
    }

    @Override
    public Object info() {
        if (this.total > 0L) {
            return (double)this.matched / (double)this.total;
        }
        return Double.NaN;
    }
}

