/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcmon;

import java.lang.management.MemoryUsage;

public class MemoryUsageBean {
    private final long init;
    private final long used;
    private final long committed;
    private final long max;

    public MemoryUsageBean(long init, long used, long committed, long max) {
        this.init = init;
        this.used = used;
        this.committed = committed;
        this.max = max;
    }

    public MemoryUsageBean(MemoryUsage mu) {
        this.init = mu.getInit();
        this.used = mu.getUsed();
        this.committed = mu.getCommitted();
        this.max = mu.getMax();
    }

    public long init() {
        return this.init;
    }

    public long used() {
        return this.used;
    }

    public long committed() {
        return this.committed;
    }

    public long max() {
        return this.max;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.committed ^ this.committed >>> 32);
        result = 31 * result + (int)(this.init ^ this.init >>> 32);
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.used ^ this.used >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryUsageBean other = (MemoryUsageBean)obj;
        if (this.committed != other.committed) {
            return false;
        }
        if (this.init != other.init) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        return this.used == other.used;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[init=");
        builder.append(this.init);
        builder.append(", used=");
        builder.append(this.used);
        builder.append(", committed=");
        builder.append(this.committed);
        builder.append(", max=");
        builder.append(this.max);
        builder.append("]");
        return builder.toString();
    }
}

