/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.streaming.StreamRequest;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamSummary;
import org.apache.cassandra.streaming.messages.StreamMessage;

public class PrepareSynMessage
extends StreamMessage {
    public static StreamMessage.Serializer<PrepareSynMessage> serializer = new StreamMessage.Serializer<PrepareSynMessage>(){

        @Override
        public PrepareSynMessage deserialize(DataInputPlus input, int version) throws IOException {
            PrepareSynMessage message = new PrepareSynMessage();
            int numRequests = input.readInt();
            for (int i = 0; i < numRequests; ++i) {
                message.requests.add((StreamRequest)StreamRequest.serializer.deserialize(input, version));
            }
            int numSummaries = input.readInt();
            for (int i = 0; i < numSummaries; ++i) {
                message.summaries.add((StreamSummary)StreamSummary.serializer.deserialize(input, version));
            }
            return message;
        }

        @Override
        public long serializedSize(PrepareSynMessage message, int version) {
            long size = 8L;
            for (StreamRequest request : message.requests) {
                size += StreamRequest.serializer.serializedSize(request, version);
            }
            for (StreamSummary summary : message.summaries) {
                size += StreamSummary.serializer.serializedSize(summary, version);
            }
            return size;
        }

        @Override
        public void serialize(PrepareSynMessage message, DataOutputStreamPlus out, int version, StreamSession session) throws IOException {
            out.writeInt(message.requests.size());
            for (StreamRequest request : message.requests) {
                StreamRequest.serializer.serialize(request, out, version);
            }
            out.writeInt(message.summaries.size());
            for (StreamSummary summary : message.summaries) {
                StreamSummary.serializer.serialize(summary, out, version);
            }
        }
    };
    public final Collection<StreamRequest> requests = new ArrayList<StreamRequest>();
    public final Collection<StreamSummary> summaries = new ArrayList<StreamSummary>();

    public PrepareSynMessage() {
        super(StreamMessage.Type.PREPARE_SYN);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Prepare SYN (");
        sb.append(this.requests.size()).append(" requests, ");
        int totalFile = 0;
        for (StreamSummary summary : this.summaries) {
            totalFile += summary.files;
        }
        sb.append(" ").append(totalFile).append(" files");
        sb.append('}');
        return sb.toString();
    }
}

