/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import com.codahale.metrics.Meter;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.reads.DataResolver;
import org.apache.cassandra.service.reads.DigestResolver;
import org.apache.cassandra.service.reads.ReadCallback;
import org.apache.cassandra.service.reads.repair.ReadRepair;
import org.apache.cassandra.service.reads.repair.ReadRepairDiagnostics;
import org.apache.cassandra.tracing.Tracing;

public abstract class AbstractReadRepair<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>>
implements ReadRepair<E, P> {
    protected final ReadCommand command;
    protected final long queryStartNanoTime;
    protected final ReplicaPlan.Shared<E, P> replicaPlan;
    protected final ColumnFamilyStore cfs;
    private volatile DigestRepair<E, P> digestRepair = null;

    public AbstractReadRepair(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, long queryStartNanoTime) {
        this.command = command;
        this.queryStartNanoTime = queryStartNanoTime;
        this.replicaPlan = replicaPlan;
        this.cfs = Keyspace.openAndGetStore(command.metadata());
    }

    protected P replicaPlan() {
        return (P)((ReplicaPlan.ForRead)this.replicaPlan.get());
    }

    void sendReadCommand(Replica to, ReadCallback<E, P> readCallback, boolean speculative, boolean trackRepairedStatus) {
        ReadCommand command = this.command;
        if (to.isSelf()) {
            Stage.READ.maybeExecuteImmediately(new StorageProxy.LocalReadRunnable(command, readCallback, trackRepairedStatus));
            return;
        }
        if (to.isTransient()) {
            command = command.copyAsTransientQuery(to);
        }
        if (Tracing.isTracing()) {
            String type = speculative ? (to.isFull() ? "speculative full" : "speculative transient") : (to.isFull() ? "full" : "transient");
            Tracing.trace("Enqueuing {} data read to {}", (Object)type, (Object)to);
        }
        Message<ReadCommand> message = command.createMessage(trackRepairedStatus && to.isFull());
        MessagingService.instance().sendWithCallback(message, to.endpoint(), readCallback);
    }

    abstract Meter getRepairMeter();

    @Override
    public void startRepair(DigestResolver<E, P> digestResolver, Consumer<PartitionIterator> resultConsumer) {
        this.getRepairMeter().mark();
        boolean trackRepairedStatus = DatabaseDescriptor.getRepairedDataTrackingForPartitionReadsEnabled();
        DataResolver<E, P> resolver = new DataResolver<E, P>(this.command, this.replicaPlan, this, this.queryStartNanoTime, trackRepairedStatus);
        ReadCallback<E, P> readCallback = new ReadCallback<E, P>(resolver, this.command, this.replicaPlan, this.queryStartNanoTime);
        this.digestRepair = new DigestRepair<E, P>(resolver, readCallback, resultConsumer);
        for (Replica replica : ((ReplicaPlan)this.replicaPlan()).contacts()) {
            this.sendReadCommand(replica, readCallback, false, trackRepairedStatus);
        }
        ReadRepairDiagnostics.startRepair(this, this.replicaPlan(), digestResolver);
    }

    @Override
    public void awaitReads() throws ReadTimeoutException {
        DigestRepair<E, P> repair = this.digestRepair;
        if (repair == null) {
            return;
        }
        ((DigestRepair)repair).readCallback.awaitResults();
        ((DigestRepair)repair).resultConsumer.accept(((DigestRepair)this.digestRepair).dataResolver.resolve());
    }

    private boolean shouldSpeculate() {
        ConsistencyLevel consistency = ((ReplicaPlan)this.replicaPlan()).consistencyLevel();
        ConsistencyLevel speculativeCL = consistency.isDatacenterLocal() ? ConsistencyLevel.LOCAL_QUORUM : ConsistencyLevel.QUORUM;
        return consistency != ConsistencyLevel.EACH_QUORUM && consistency.satisfies(speculativeCL, ((ReplicaPlan.ForRead)this.replicaPlan.get()).replicationStrategy()) && this.cfs.sampleReadLatencyNanos <= this.command.getTimeout(TimeUnit.NANOSECONDS);
    }

    @Override
    public void maybeSendAdditionalReads() {
        Preconditions.checkState(this.command instanceof SinglePartitionReadCommand, "maybeSendAdditionalReads can only be called for SinglePartitionReadCommand");
        DigestRepair<E, P> repair = this.digestRepair;
        if (repair == null) {
            return;
        }
        if (this.shouldSpeculate() && !((DigestRepair)repair).readCallback.await(this.cfs.sampleReadLatencyNanos, TimeUnit.NANOSECONDS)) {
            Replica uncontacted = ((ReplicaPlan.ForRead)this.replicaPlan()).firstUncontactedCandidate(replica -> true);
            if (uncontacted == null) {
                return;
            }
            this.replicaPlan.addToContacts(uncontacted);
            this.sendReadCommand(uncontacted, ((DigestRepair)repair).readCallback, true, false);
            ReadRepairMetrics.speculatedRead.mark();
            ReadRepairDiagnostics.speculatedRead(this, uncontacted.endpoint(), this.replicaPlan());
        }
    }

    private static class DigestRepair<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>> {
        private final DataResolver<E, P> dataResolver;
        private final ReadCallback<E, P> readCallback;
        private final Consumer<PartitionIterator> resultConsumer;

        public DigestRepair(DataResolver<E, P> dataResolver, ReadCallback<E, P> readCallback, Consumer<PartitionIterator> resultConsumer) {
            this.dataResolver = dataResolver;
            this.readCallback = readCallback;
            this.resultConsumer = resultConsumer;
        }
    }
}

