/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent.admin;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;

public class PendingStat {
    private static final String[] COMPOSITE_NAMES = new String[]{"dataSize", "numSSTables", "sessions"};
    private static final OpenType<?>[] COMPOSITE_TYPES;
    public static final CompositeType COMPOSITE_TYPE;
    public final long dataSize;
    public final int numSSTables;
    public final Set<UUID> sessions;

    public PendingStat(long dataSize, int numSSTables, Set<UUID> sessions) {
        this.dataSize = dataSize;
        this.numSSTables = numSSTables;
        this.sessions = Collections.unmodifiableSet(sessions);
    }

    public String sizeString() {
        return String.format("%s (%s sstables / %s sessions)", FileUtils.stringifyFileSize(this.dataSize), this.numSSTables, this.sessions.size());
    }

    public CompositeData toComposite() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(COMPOSITE_NAMES[0], this.dataSize);
        values.put(COMPOSITE_NAMES[1], this.numSSTables);
        String[] sessionIds = new String[this.sessions.size()];
        int idx = 0;
        for (UUID session : this.sessions) {
            sessionIds[idx++] = session.toString();
        }
        values.put(COMPOSITE_NAMES[2], sessionIds);
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, values);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate(e);
        }
    }

    public static PendingStat fromComposite(CompositeData cd2) {
        Preconditions.checkArgument(cd2.getCompositeType().equals(COMPOSITE_TYPE));
        Object[] values = cd2.getAll(COMPOSITE_NAMES);
        HashSet<UUID> sessions = new HashSet<UUID>();
        for (String session : (String[])values[2]) {
            sessions.add(UUID.fromString(session));
        }
        return new PendingStat((Long)values[0], (Integer)values[1], sessions);
    }

    static {
        try {
            COMPOSITE_TYPES = new OpenType[]{SimpleType.LONG, SimpleType.INTEGER, ArrayType.getArrayType(SimpleType.STRING)};
            COMPOSITE_TYPE = new CompositeType(PendingStat.class.getName(), PendingStat.class.getSimpleName(), COMPOSITE_NAMES, COMPOSITE_NAMES, COMPOSITE_TYPES);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate(e);
        }
    }

    public static class Builder {
        public long dataSize = 0L;
        public int numSSTables = 0;
        public Set<UUID> sessions = new HashSet<UUID>();

        public Builder addSSTable(SSTableReader sstable) {
            UUID sessionID = sstable.getPendingRepair();
            if (sessionID == null) {
                return this;
            }
            this.dataSize += sstable.onDiskLength();
            this.sessions.add(sessionID);
            ++this.numSSTables;
            return this;
        }

        public Builder addStat(PendingStat stat) {
            this.dataSize += stat.dataSize;
            this.numSSTables += stat.numSSTables;
            this.sessions.addAll(stat.sessions);
            return this;
        }

        public PendingStat build() {
            return new PendingStat(this.dataSize, this.numSSTables, this.sessions);
        }
    }
}

