/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.auth.AllowAllInternodeAuthenticator;
import org.apache.cassandra.auth.AuthConfig;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.auth.INetworkAuthorizer;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.commitlog.AbstractCommitLogSegmentManager;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManagerCDC;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManagerStandard;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.fql.FullQueryLoggerOptions;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.DiskOptimizationStrategy;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SpinningDiskOptimizationStrategy;
import org.apache.cassandra.io.util.SsdDiskOptimizationStrategy;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.EndpointSnitchInfo;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.SeedProvider;
import org.apache.cassandra.security.EncryptionContext;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDescriptor {
    private static final Logger logger;
    private static final int MAX_NUM_TOKENS = 1536;
    private static Config conf;
    static final long LOWEST_ACCEPTED_TIMEOUT = 10L;
    private static IEndpointSnitch snitch;
    private static InetAddress listenAddress;
    private static InetAddress broadcastAddress;
    private static InetAddress rpcAddress;
    private static InetAddress broadcastRpcAddress;
    private static SeedProvider seedProvider;
    private static IInternodeAuthenticator internodeAuthenticator;
    private static IPartitioner partitioner;
    private static String paritionerName;
    private static Config.DiskAccessMode indexAccessMode;
    private static IAuthenticator authenticator;
    private static IAuthorizer authorizer;
    private static INetworkAuthorizer networkAuthorizer;
    private static IRoleManager roleManager;
    private static long preparedStatementsCacheSizeInMB;
    private static long keyCacheSizeInMB;
    private static long counterCacheSizeInMB;
    private static long indexSummaryCapacityInMB;
    private static String localDC;
    private static Comparator<Replica> localComparator;
    private static EncryptionContext encryptionContext;
    private static boolean hasLoggedConfig;
    private static DiskOptimizationStrategy diskOptimizationStrategy;
    private static boolean clientInitialized;
    private static boolean toolInitialized;
    private static boolean daemonInitialized;
    private static final int searchConcurrencyFactor;
    private static volatile boolean disableSTCSInL0;
    private static final boolean unsafeSystem;
    private static final boolean strictRuntimeChecks;
    public static volatile boolean allowUnlimitedConcurrentValidations;
    private static Function<CommitLog, AbstractCommitLogSegmentManager> commitLogSegmentMgrProvider;

    public static void daemonInitialization() throws ConfigurationException {
        DatabaseDescriptor.daemonInitialization(DatabaseDescriptor::loadConfig);
    }

    public static void daemonInitialization(Supplier<Config> config) throws ConfigurationException {
        if (toolInitialized) {
            throw new AssertionError((Object)"toolInitialization() already called");
        }
        if (clientInitialized) {
            throw new AssertionError((Object)"clientInitialization() already called");
        }
        if (daemonInitialized) {
            return;
        }
        daemonInitialized = true;
        DatabaseDescriptor.setConfig(config.get());
        DatabaseDescriptor.applyAll();
        AuthConfig.applyAuth();
    }

    public static void toolInitialization() {
        DatabaseDescriptor.toolInitialization(true);
    }

    public static void toolInitialization(boolean failIfDaemonOrClient) {
        if (!failIfDaemonOrClient && (daemonInitialized || clientInitialized)) {
            return;
        }
        if (daemonInitialized) {
            throw new AssertionError((Object)"daemonInitialization() already called");
        }
        if (clientInitialized) {
            throw new AssertionError((Object)"clientInitialization() already called");
        }
        if (toolInitialized) {
            return;
        }
        toolInitialized = true;
        DatabaseDescriptor.setConfig(DatabaseDescriptor.loadConfig());
        DatabaseDescriptor.applySimpleConfig();
        DatabaseDescriptor.applyPartitioner();
        DatabaseDescriptor.applySnitch();
        DatabaseDescriptor.applyEncryptionContext();
    }

    public static void clientInitialization() {
        DatabaseDescriptor.clientInitialization(true);
    }

    public static void clientInitialization(boolean failIfDaemonOrTool) {
        if (!failIfDaemonOrTool && (daemonInitialized || toolInitialized)) {
            return;
        }
        if (daemonInitialized) {
            throw new AssertionError((Object)"daemonInitialization() already called");
        }
        if (toolInitialized) {
            throw new AssertionError((Object)"toolInitialization() already called");
        }
        if (clientInitialized) {
            return;
        }
        clientInitialized = true;
        Config.setClientMode(true);
        conf = new Config();
        diskOptimizationStrategy = new SpinningDiskOptimizationStrategy();
    }

    public static boolean isClientInitialized() {
        return clientInitialized;
    }

    public static boolean isToolInitialized() {
        return toolInitialized;
    }

    public static boolean isClientOrToolInitialized() {
        return clientInitialized || toolInitialized;
    }

    public static boolean isDaemonInitialized() {
        return daemonInitialized;
    }

    public static Config getRawConfig() {
        return conf;
    }

    @VisibleForTesting
    public static Config loadConfig() throws ConfigurationException {
        if (Config.getOverrideLoadConfig() != null) {
            return Config.getOverrideLoadConfig().get();
        }
        String loaderClass = System.getProperty("cassandra.config.loader");
        ConfigurationLoader loader = loaderClass == null ? new YamlConfigurationLoader() : (ConfigurationLoader)FBUtilities.construct(loaderClass, "configuration loading");
        Config config = loader.loadConfig();
        if (!hasLoggedConfig) {
            hasLoggedConfig = true;
            Config.log(config);
        }
        return config;
    }

    private static InetAddress getNetworkInterfaceAddress(String intf, String configName, boolean preferIPv6) throws ConfigurationException {
        try {
            NetworkInterface ni = NetworkInterface.getByName(intf);
            if (ni == null) {
                throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" could not be found", false);
            }
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            if (!addrs.hasMoreElements()) {
                throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" was found, but had no addresses", false);
            }
            InetAddress retval = null;
            while (addrs.hasMoreElements()) {
                InetAddress temp = addrs.nextElement();
                if (preferIPv6 && temp instanceof Inet6Address) {
                    return temp;
                }
                if (!preferIPv6 && temp instanceof Inet4Address) {
                    return temp;
                }
                if (retval != null) continue;
                retval = temp;
            }
            return retval;
        }
        catch (SocketException e) {
            throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" caused an exception", e);
        }
    }

    private static void setConfig(Config config) {
        conf = config;
    }

    private static void applyAll() throws ConfigurationException {
        DatabaseDescriptor.applySimpleConfig();
        DatabaseDescriptor.applyPartitioner();
        DatabaseDescriptor.applyAddressConfig();
        DatabaseDescriptor.applySnitch();
        DatabaseDescriptor.applyTokensConfig();
        DatabaseDescriptor.applySeedProvider();
        DatabaseDescriptor.applyEncryptionContext();
        DatabaseDescriptor.applySslContext();
    }

    private static void applySimpleConfig() {
        Integer maxMessageSize;
        long totalSpaceInBytes;
        int preferredSizeInMB;
        InetAddressAndPort.initializeDefaultPort(DatabaseDescriptor.getStoragePort());
        if (DatabaseDescriptor.conf.commitlog_sync == null) {
            throw new ConfigurationException("Missing required directive CommitLogSync", false);
        }
        if (DatabaseDescriptor.conf.commitlog_sync == Config.CommitLogSync.batch) {
            if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms != 0) {
                throw new ConfigurationException("Batch sync specified, but commitlog_sync_period_in_ms found. Only specify commitlog_sync_batch_window_in_ms when using batch sync", false);
            }
            logger.debug("Syncing log with batch mode");
        } else if (DatabaseDescriptor.conf.commitlog_sync == Config.CommitLogSync.group) {
            if (Double.isNaN(DatabaseDescriptor.conf.commitlog_sync_group_window_in_ms) || DatabaseDescriptor.conf.commitlog_sync_group_window_in_ms <= 0.0) {
                throw new ConfigurationException("Missing value for commitlog_sync_group_window_in_ms: positive double value expected.", false);
            }
            if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms != 0) {
                throw new ConfigurationException("Group sync specified, but commitlog_sync_period_in_ms found. Only specify commitlog_sync_group_window_in_ms when using group sync", false);
            }
            logger.debug("Syncing log with a group window of {}", (Object)DatabaseDescriptor.conf.commitlog_sync_period_in_ms);
        } else {
            if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms <= 0) {
                throw new ConfigurationException("Missing value for commitlog_sync_period_in_ms: positive integer expected", false);
            }
            if (!Double.isNaN(DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms)) {
                throw new ConfigurationException("commitlog_sync_period_in_ms specified, but commitlog_sync_batch_window_in_ms found.  Only specify commitlog_sync_period_in_ms when using periodic sync.", false);
            }
            logger.debug("Syncing log with a period of {}", (Object)DatabaseDescriptor.conf.commitlog_sync_period_in_ms);
        }
        if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.auto) {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode = DatabaseDescriptor.hasLargeAddressSpace() ? Config.DiskAccessMode.mmap : Config.DiskAccessMode.standard;
            logger.info("DiskAccessMode 'auto' determined to be {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.mmap_index_only) {
            DatabaseDescriptor.conf.disk_access_mode = Config.DiskAccessMode.standard;
            indexAccessMode = Config.DiskAccessMode.mmap;
            logger.info("DiskAccessMode is {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode;
            logger.info("DiskAccessMode is {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        }
        if (DatabaseDescriptor.conf.gc_warn_threshold_in_ms < 0) {
            throw new ConfigurationException("gc_warn_threshold_in_ms must be a positive integer");
        }
        if (DatabaseDescriptor.conf.phi_convict_threshold < 5.0 || DatabaseDescriptor.conf.phi_convict_threshold > 16.0) {
            throw new ConfigurationException("phi_convict_threshold must be between 5 and 16, but was " + DatabaseDescriptor.conf.phi_convict_threshold, false);
        }
        if (DatabaseDescriptor.conf.concurrent_reads < 2) {
            throw new ConfigurationException("concurrent_reads must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_reads, false);
        }
        if (DatabaseDescriptor.conf.concurrent_writes < 2 && System.getProperty("cassandra.test.fail_mv_locks_count", "").isEmpty()) {
            throw new ConfigurationException("concurrent_writes must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_writes, false);
        }
        if (DatabaseDescriptor.conf.concurrent_counter_writes < 2) {
            throw new ConfigurationException("concurrent_counter_writes must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_counter_writes, false);
        }
        if (DatabaseDescriptor.conf.concurrent_replicates != null) {
            logger.warn("concurrent_replicates has been deprecated and should be removed from cassandra.yaml");
        }
        if (DatabaseDescriptor.conf.networking_cache_size_in_mb == null) {
            DatabaseDescriptor.conf.networking_cache_size_in_mb = Math.min(128, (int)(Runtime.getRuntime().maxMemory() / 0x1000000L));
        }
        if (DatabaseDescriptor.conf.file_cache_size_in_mb == null) {
            DatabaseDescriptor.conf.file_cache_size_in_mb = Math.min(512, (int)(Runtime.getRuntime().maxMemory() / 0x400000L));
        }
        if (DatabaseDescriptor.conf.file_cache_round_up == null) {
            DatabaseDescriptor.conf.file_cache_round_up = DatabaseDescriptor.conf.disk_optimization_strategy == Config.DiskOptimizationStrategy.spinning;
        }
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb == null) {
            DatabaseDescriptor.conf.memtable_offheap_space_in_mb = (int)(Runtime.getRuntime().maxMemory() / 0x400000L);
        }
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb < 0) {
            throw new ConfigurationException("memtable_offheap_space_in_mb must be positive, but was " + DatabaseDescriptor.conf.memtable_offheap_space_in_mb, false);
        }
        if (DatabaseDescriptor.conf.memtable_heap_space_in_mb == null) {
            DatabaseDescriptor.conf.memtable_heap_space_in_mb = (int)(Runtime.getRuntime().maxMemory() / 0x400000L);
        }
        if (DatabaseDescriptor.conf.memtable_heap_space_in_mb <= 0) {
            throw new ConfigurationException("memtable_heap_space_in_mb must be positive, but was " + DatabaseDescriptor.conf.memtable_heap_space_in_mb, false);
        }
        logger.info("Global memtable on-heap threshold is enabled at {}MB", (Object)DatabaseDescriptor.conf.memtable_heap_space_in_mb);
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb == 0) {
            logger.info("Global memtable off-heap threshold is disabled, HeapAllocator will be used instead");
        } else {
            logger.info("Global memtable off-heap threshold is enabled at {}MB", (Object)DatabaseDescriptor.conf.memtable_offheap_space_in_mb);
        }
        if (DatabaseDescriptor.conf.repair_session_max_tree_depth != null) {
            logger.warn("repair_session_max_tree_depth has been deprecated and should be removed from cassandra.yaml. Use repair_session_space_in_mb instead");
            if (DatabaseDescriptor.conf.repair_session_max_tree_depth < 10) {
                throw new ConfigurationException("repair_session_max_tree_depth should not be < 10, but was " + DatabaseDescriptor.conf.repair_session_max_tree_depth);
            }
            if (DatabaseDescriptor.conf.repair_session_max_tree_depth > 20) {
                logger.warn("repair_session_max_tree_depth of " + DatabaseDescriptor.conf.repair_session_max_tree_depth + " > 20 could lead to excessive memory usage");
            }
        } else {
            DatabaseDescriptor.conf.repair_session_max_tree_depth = 20;
        }
        if (DatabaseDescriptor.conf.repair_session_space_in_mb == null) {
            DatabaseDescriptor.conf.repair_session_space_in_mb = Math.max(1, (int)(Runtime.getRuntime().maxMemory() / 0x1000000L));
        }
        if (DatabaseDescriptor.conf.repair_session_space_in_mb < 1) {
            throw new ConfigurationException("repair_session_space_in_mb must be > 0, but was " + DatabaseDescriptor.conf.repair_session_space_in_mb);
        }
        if (DatabaseDescriptor.conf.repair_session_space_in_mb > (int)(Runtime.getRuntime().maxMemory() / 0x400000L)) {
            logger.warn("A repair_session_space_in_mb of " + DatabaseDescriptor.conf.repair_session_space_in_mb + " megabytes is likely to cause heap pressure");
        }
        DatabaseDescriptor.checkForLowestAcceptedTimeouts(conf);
        DatabaseDescriptor.checkValidForByteConversion(DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb, "native_transport_max_frame_size_in_mb", ByteUnit.MEBI_BYTES);
        DatabaseDescriptor.checkValidForByteConversion(DatabaseDescriptor.conf.column_index_size_in_kb, "column_index_size_in_kb", ByteUnit.KIBI_BYTES);
        DatabaseDescriptor.checkValidForByteConversion(DatabaseDescriptor.conf.column_index_cache_size_in_kb, "column_index_cache_size_in_kb", ByteUnit.KIBI_BYTES);
        DatabaseDescriptor.checkValidForByteConversion(DatabaseDescriptor.conf.batch_size_warn_threshold_in_kb, "batch_size_warn_threshold_in_kb", ByteUnit.KIBI_BYTES);
        if (DatabaseDescriptor.conf.native_transport_max_negotiable_protocol_version != null) {
            logger.warn("The configuration option native_transport_max_negotiable_protocol_version has been deprecated and should be removed from cassandra.yaml as it has no longer has any effect.");
        }
        if (DatabaseDescriptor.conf.commitlog_directory == null) {
            DatabaseDescriptor.conf.commitlog_directory = DatabaseDescriptor.storagedirFor("commitlog");
        }
        if (DatabaseDescriptor.conf.hints_directory == null) {
            DatabaseDescriptor.conf.hints_directory = DatabaseDescriptor.storagedirFor("hints");
        }
        if (DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes <= 0L) {
            DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes = Runtime.getRuntime().maxMemory() / 10L;
        }
        if (DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes_per_ip <= 0L) {
            DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes_per_ip = Runtime.getRuntime().maxMemory() / 40L;
        }
        if (DatabaseDescriptor.conf.commitlog_total_space_in_mb == null) {
            preferredSizeInMB = 8192;
            try {
                totalSpaceInBytes = DatabaseDescriptor.guessFileStore(DatabaseDescriptor.conf.commitlog_directory).getTotalSpace();
                DatabaseDescriptor.conf.commitlog_total_space_in_mb = DatabaseDescriptor.calculateDefaultSpaceInMB("commitlog", DatabaseDescriptor.conf.commitlog_directory, "commitlog_total_space_in_mb", 8192, totalSpaceInBytes, 1L, 4L);
            }
            catch (IOException e) {
                logger.debug("Error checking disk space", (Throwable)e);
                throw new ConfigurationException(String.format("Unable to check disk space available to '%s'. Perhaps the Cassandra user does not have the necessary permissions", DatabaseDescriptor.conf.commitlog_directory), e);
            }
        }
        if (DatabaseDescriptor.conf.cdc_enabled) {
            if (FBUtilities.isWindows && DatabaseDescriptor.conf.commitlog_compression == null) {
                throw new ConfigurationException("Cannot enable cdc on Windows with uncompressed commitlog.");
            }
            if (DatabaseDescriptor.conf.cdc_raw_directory == null) {
                DatabaseDescriptor.conf.cdc_raw_directory = DatabaseDescriptor.storagedirFor("cdc_raw");
            }
            if (DatabaseDescriptor.conf.cdc_total_space_in_mb == 0) {
                preferredSizeInMB = 4096;
                try {
                    totalSpaceInBytes = DatabaseDescriptor.guessFileStore(DatabaseDescriptor.conf.cdc_raw_directory).getTotalSpace();
                    DatabaseDescriptor.conf.cdc_total_space_in_mb = DatabaseDescriptor.calculateDefaultSpaceInMB("cdc", DatabaseDescriptor.conf.cdc_raw_directory, "cdc_total_space_in_mb", 4096, totalSpaceInBytes, 1L, 8L);
                }
                catch (IOException e) {
                    logger.debug("Error checking disk space", (Throwable)e);
                    throw new ConfigurationException(String.format("Unable to check disk space available to '%s'. Perhaps the Cassandra user does not have the necessary permissions", DatabaseDescriptor.conf.cdc_raw_directory), e);
                }
            }
            logger.info("cdc_enabled is true. Starting casssandra node with Change-Data-Capture enabled.");
        }
        if (DatabaseDescriptor.conf.saved_caches_directory == null) {
            DatabaseDescriptor.conf.saved_caches_directory = DatabaseDescriptor.storagedirFor("saved_caches");
        }
        if (DatabaseDescriptor.conf.data_file_directories == null || DatabaseDescriptor.conf.data_file_directories.length == 0) {
            DatabaseDescriptor.conf.data_file_directories = new String[]{DatabaseDescriptor.storagedir("data_file_directories") + File.separator + "data"};
        }
        long dataFreeBytes = 0L;
        for (String datadir : DatabaseDescriptor.conf.data_file_directories) {
            if (datadir == null) {
                throw new ConfigurationException("data_file_directories must not contain empty entry", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.local_system_data_file_directory)) {
                throw new ConfigurationException("local_system_data_file_directory must not be the same as any data_file_directories", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.commitlog_directory)) {
                throw new ConfigurationException("commitlog_directory must not be the same as any data_file_directories", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.hints_directory)) {
                throw new ConfigurationException("hints_directory must not be the same as any data_file_directories", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
                throw new ConfigurationException("saved_caches_directory must not be the same as any data_file_directories", false);
            }
            dataFreeBytes = DatabaseDescriptor.saturatedSum(dataFreeBytes, DatabaseDescriptor.getUnallocatedSpace(datadir));
        }
        if (dataFreeBytes < 0x1000000000L) {
            logger.warn("Only {} free across all data volumes. Consider adding more capacity to your cluster or removing obsolete snapshots", (Object)FBUtilities.prettyPrintMemory(dataFreeBytes));
        }
        if (DatabaseDescriptor.conf.local_system_data_file_directory != null) {
            if (DatabaseDescriptor.conf.local_system_data_file_directory.equals(DatabaseDescriptor.conf.commitlog_directory)) {
                throw new ConfigurationException("local_system_data_file_directory must not be the same as the commitlog_directory", false);
            }
            if (DatabaseDescriptor.conf.local_system_data_file_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
                throw new ConfigurationException("local_system_data_file_directory must not be the same as the saved_caches_directory", false);
            }
            if (DatabaseDescriptor.conf.local_system_data_file_directory.equals(DatabaseDescriptor.conf.hints_directory)) {
                throw new ConfigurationException("local_system_data_file_directory must not be the same as the hints_directory", false);
            }
            long freeBytes = DatabaseDescriptor.getUnallocatedSpace(DatabaseDescriptor.conf.local_system_data_file_directory);
            if (freeBytes < 0x40000000L) {
                logger.warn("Only {} free in the system data volume. Consider adding more capacity or removing obsolete snapshots", (Object)FBUtilities.prettyPrintMemory(freeBytes));
            }
        }
        if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
            throw new ConfigurationException("saved_caches_directory must not be the same as the commitlog_directory", false);
        }
        if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.hints_directory)) {
            throw new ConfigurationException("hints_directory must not be the same as the commitlog_directory", false);
        }
        if (DatabaseDescriptor.conf.hints_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
            throw new ConfigurationException("saved_caches_directory must not be the same as the hints_directory", false);
        }
        if (DatabaseDescriptor.conf.memtable_flush_writers == 0) {
            int n = DatabaseDescriptor.conf.memtable_flush_writers = DatabaseDescriptor.conf.data_file_directories.length == 1 ? 2 : 1;
        }
        if (DatabaseDescriptor.conf.memtable_flush_writers < 1) {
            throw new ConfigurationException("memtable_flush_writers must be at least 1, but was " + DatabaseDescriptor.conf.memtable_flush_writers, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold == null) {
            DatabaseDescriptor.conf.memtable_cleanup_threshold = Float.valueOf((float)(1.0 / (double)(1 + DatabaseDescriptor.conf.memtable_flush_writers)));
        } else {
            logger.warn("memtable_cleanup_threshold has been deprecated and should be removed from cassandra.yaml");
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() < 0.01f) {
            throw new ConfigurationException("memtable_cleanup_threshold must be >= 0.01, but was " + DatabaseDescriptor.conf.memtable_cleanup_threshold, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() > 0.99f) {
            throw new ConfigurationException("memtable_cleanup_threshold must be <= 0.99, but was " + DatabaseDescriptor.conf.memtable_cleanup_threshold, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() < 0.1f) {
            logger.warn("memtable_cleanup_threshold is set very low [{}], which may cause performance degradation", (Object)DatabaseDescriptor.conf.memtable_cleanup_threshold);
        }
        if (DatabaseDescriptor.conf.concurrent_compactors == null) {
            DatabaseDescriptor.conf.concurrent_compactors = Math.min(8, Math.max(2, Math.min(FBUtilities.getAvailableProcessors(), DatabaseDescriptor.conf.data_file_directories.length)));
        }
        if (DatabaseDescriptor.conf.concurrent_compactors <= 0) {
            throw new ConfigurationException("concurrent_compactors should be strictly greater than 0, but was " + DatabaseDescriptor.conf.concurrent_compactors, false);
        }
        DatabaseDescriptor.applyConcurrentValidations(conf);
        DatabaseDescriptor.applyRepairCommandPoolSize(conf);
        if (DatabaseDescriptor.conf.concurrent_materialized_view_builders <= 0) {
            throw new ConfigurationException("concurrent_materialized_view_builders should be strictly greater than 0, but was " + DatabaseDescriptor.conf.concurrent_materialized_view_builders, false);
        }
        if (DatabaseDescriptor.conf.num_tokens != null && DatabaseDescriptor.conf.num_tokens > 1536) {
            throw new ConfigurationException(String.format("A maximum number of %d tokens per node is supported", 1536), false);
        }
        try {
            long l = preparedStatementsCacheSizeInMB = DatabaseDescriptor.conf.prepared_statements_cache_size_mb == null ? (long)Math.max(10, (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L / 256L)) : DatabaseDescriptor.conf.prepared_statements_cache_size_mb;
            if (preparedStatementsCacheSizeInMB <= 0L) {
                throw new NumberFormatException();
            }
            DatabaseDescriptor.conf.prepared_statements_cache_size_mb = preparedStatementsCacheSizeInMB;
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("prepared_statements_cache_size_mb option was set incorrectly to '" + DatabaseDescriptor.conf.prepared_statements_cache_size_mb + "', supported values are <integer> >= 0.", false);
        }
        try {
            long l = keyCacheSizeInMB = DatabaseDescriptor.conf.key_cache_size_in_mb == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0)), 100) : DatabaseDescriptor.conf.key_cache_size_in_mb;
            if (keyCacheSizeInMB < 0L) {
                throw new NumberFormatException();
            }
            DatabaseDescriptor.conf.key_cache_size_in_mb = keyCacheSizeInMB;
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("key_cache_size_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.key_cache_size_in_mb + "', supported values are <integer> >= 0.", false);
        }
        try {
            long l = counterCacheSizeInMB = DatabaseDescriptor.conf.counter_cache_size_in_mb == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.025 / 1024.0 / 1024.0)), 50) : DatabaseDescriptor.conf.counter_cache_size_in_mb;
            if (counterCacheSizeInMB < 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("counter_cache_size_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.counter_cache_size_in_mb + "', supported values are <integer> >= 0.", false);
        }
        DatabaseDescriptor.conf.counter_cache_size_in_mb = counterCacheSizeInMB;
        long l = indexSummaryCapacityInMB = DatabaseDescriptor.conf.index_summary_capacity_in_mb == null ? (long)Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0)) : DatabaseDescriptor.conf.index_summary_capacity_in_mb;
        if (indexSummaryCapacityInMB < 0L) {
            throw new ConfigurationException("index_summary_capacity_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.index_summary_capacity_in_mb + "', it should be a non-negative integer.", false);
        }
        DatabaseDescriptor.conf.index_summary_capacity_in_mb = indexSummaryCapacityInMB;
        if (DatabaseDescriptor.conf.user_defined_function_fail_timeout < 0L) {
            throw new ConfigurationException("user_defined_function_fail_timeout must not be negative", false);
        }
        if (DatabaseDescriptor.conf.user_defined_function_warn_timeout < 0L) {
            throw new ConfigurationException("user_defined_function_warn_timeout must not be negative", false);
        }
        if (DatabaseDescriptor.conf.user_defined_function_fail_timeout < DatabaseDescriptor.conf.user_defined_function_warn_timeout) {
            throw new ConfigurationException("user_defined_function_warn_timeout must less than user_defined_function_fail_timeout", false);
        }
        if (!DatabaseDescriptor.conf.allow_insecure_udfs && !DatabaseDescriptor.conf.enable_user_defined_functions_threads) {
            throw new ConfigurationException("To be able to set enable_user_defined_functions_threads: false you need to set allow_insecure_udfs: true - this is an unsafe configuration and is not recommended.");
        }
        if (DatabaseDescriptor.conf.allow_extra_insecure_udfs) {
            logger.warn("Allowing java.lang.System.* access in UDFs is dangerous and not recommended. Set allow_extra_insecure_udfs: false to disable.");
        }
        if (DatabaseDescriptor.conf.enable_scripted_user_defined_functions) {
            logger.warn("JavaScript user-defined functions have been deprecated. You can still use them but the plan is to remove them in the next major version. For more information - CASSANDRA-17280");
        }
        if (DatabaseDescriptor.conf.commitlog_segment_size_in_mb <= 0) {
            throw new ConfigurationException("commitlog_segment_size_in_mb must be positive, but was " + DatabaseDescriptor.conf.commitlog_segment_size_in_mb, false);
        }
        if (DatabaseDescriptor.conf.commitlog_segment_size_in_mb >= 2048) {
            throw new ConfigurationException("commitlog_segment_size_in_mb must be smaller than 2048, but was " + DatabaseDescriptor.conf.commitlog_segment_size_in_mb, false);
        }
        if (DatabaseDescriptor.conf.max_mutation_size_in_kb == null) {
            DatabaseDescriptor.conf.max_mutation_size_in_kb = DatabaseDescriptor.conf.commitlog_segment_size_in_mb * 1024 / 2;
        } else if (DatabaseDescriptor.conf.commitlog_segment_size_in_mb * 1024 < 2 * DatabaseDescriptor.conf.max_mutation_size_in_kb) {
            throw new ConfigurationException("commitlog_segment_size_in_mb must be at least twice the size of max_mutation_size_in_kb / 1024", false);
        }
        if (DatabaseDescriptor.conf.client_encryption_options != null) {
            DatabaseDescriptor.conf.client_encryption_options.applyConfig();
            if (DatabaseDescriptor.conf.native_transport_port_ssl != null && DatabaseDescriptor.conf.native_transport_port_ssl != DatabaseDescriptor.conf.native_transport_port && DatabaseDescriptor.conf.client_encryption_options.tlsEncryptionPolicy() == EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED) {
                throw new ConfigurationException("Encryption must be enabled in client_encryption_options for native_transport_port_ssl", false);
            }
        }
        if (DatabaseDescriptor.conf.snapshot_links_per_second < 0L) {
            throw new ConfigurationException("snapshot_links_per_second must be >= 0");
        }
        if (DatabaseDescriptor.conf.max_value_size_in_mb <= 0) {
            throw new ConfigurationException("max_value_size_in_mb must be positive", false);
        }
        if (DatabaseDescriptor.conf.max_value_size_in_mb >= 2048) {
            throw new ConfigurationException("max_value_size_in_mb must be smaller than 2048, but was " + DatabaseDescriptor.conf.max_value_size_in_mb, false);
        }
        switch (DatabaseDescriptor.conf.disk_optimization_strategy) {
            case ssd: {
                diskOptimizationStrategy = new SsdDiskOptimizationStrategy(DatabaseDescriptor.conf.disk_optimization_page_cross_chance);
                break;
            }
            case spinning: {
                diskOptimizationStrategy = new SpinningDiskOptimizationStrategy();
            }
        }
        if (DatabaseDescriptor.conf.server_encryption_options != null) {
            DatabaseDescriptor.conf.server_encryption_options.applyConfig();
            if (DatabaseDescriptor.conf.server_encryption_options.enable_legacy_ssl_storage_port && DatabaseDescriptor.conf.server_encryption_options.tlsEncryptionPolicy() == EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED) {
                throw new ConfigurationException("enable_legacy_ssl_storage_port is true (enabled) with internode encryption disabled (none). Enable encryption or disable the legacy ssl storage port.");
            }
        }
        if ((maxMessageSize = DatabaseDescriptor.conf.internode_max_message_size_in_bytes) != null) {
            if (maxMessageSize > DatabaseDescriptor.conf.internode_application_receive_queue_reserve_endpoint_capacity_in_bytes) {
                throw new ConfigurationException("internode_max_message_size_in_mb must no exceed internode_application_receive_queue_reserve_endpoint_capacity_in_bytes", false);
            }
            if (maxMessageSize > DatabaseDescriptor.conf.internode_application_receive_queue_reserve_global_capacity_in_bytes) {
                throw new ConfigurationException("internode_max_message_size_in_mb must no exceed internode_application_receive_queue_reserve_global_capacity_in_bytes", false);
            }
            if (maxMessageSize > DatabaseDescriptor.conf.internode_application_send_queue_reserve_endpoint_capacity_in_bytes) {
                throw new ConfigurationException("internode_max_message_size_in_mb must no exceed internode_application_send_queue_reserve_endpoint_capacity_in_bytes", false);
            }
            if (maxMessageSize > DatabaseDescriptor.conf.internode_application_send_queue_reserve_global_capacity_in_bytes) {
                throw new ConfigurationException("internode_max_message_size_in_mb must no exceed internode_application_send_queue_reserve_global_capacity_in_bytes", false);
            }
        } else {
            DatabaseDescriptor.conf.internode_max_message_size_in_bytes = Math.min(DatabaseDescriptor.conf.internode_application_receive_queue_reserve_endpoint_capacity_in_bytes, DatabaseDescriptor.conf.internode_application_send_queue_reserve_endpoint_capacity_in_bytes);
        }
        DatabaseDescriptor.validateMaxConcurrentAutoUpgradeTasksConf(DatabaseDescriptor.conf.max_concurrent_automatic_sstable_upgrades);
    }

    @VisibleForTesting
    static void applyConcurrentValidations(Config config) {
        if (config.concurrent_validations < 1) {
            config.concurrent_validations = config.concurrent_compactors;
        } else if (config.concurrent_validations > config.concurrent_compactors && !allowUnlimitedConcurrentValidations) {
            throw new ConfigurationException("To set concurrent_validations > concurrent_compactors, set the system property cassandra.allow_unlimited_concurrent_validations=true");
        }
    }

    @VisibleForTesting
    static void applyRepairCommandPoolSize(Config config) {
        if (config.repair_command_pool_size < 1) {
            config.repair_command_pool_size = config.concurrent_validations;
        }
    }

    private static String storagedirFor(String type) {
        return DatabaseDescriptor.storagedir(type + "_directory") + File.separator + type;
    }

    private static String storagedir(String errMsgType) {
        String storagedir = System.getProperty("cassandra.storagedir", null);
        if (storagedir == null) {
            throw new ConfigurationException(errMsgType + " is missing and -Dcassandra.storagedir is not set", false);
        }
        return storagedir;
    }

    static int calculateDefaultSpaceInMB(String type, String path, String setting, int preferredSizeInMB, long totalSpaceInBytes, long totalSpaceNumerator, long totalSpaceDenominator) {
        long totalSizeInMB = totalSpaceInBytes / 0x100000L;
        int minSizeInMB = Ints.saturatedCast(totalSpaceNumerator * totalSizeInMB / totalSpaceDenominator);
        if (minSizeInMB < preferredSizeInMB) {
            logger.warn("Small {} volume detected at '{}'; setting {} to {}.  You can override this in cassandra.yaml", new Object[]{type, path, setting, minSizeInMB});
            return minSizeInMB;
        }
        return preferredSizeInMB;
    }

    public static void applyAddressConfig() throws ConfigurationException {
        DatabaseDescriptor.applyAddressConfig(conf);
    }

    public static void applyAddressConfig(Config config) throws ConfigurationException {
        listenAddress = null;
        rpcAddress = null;
        broadcastAddress = null;
        broadcastRpcAddress = null;
        if (config.listen_address != null && config.listen_interface != null) {
            throw new ConfigurationException("Set listen_address OR listen_interface, not both", false);
        }
        if (config.listen_address != null) {
            try {
                listenAddress = InetAddress.getByName(config.listen_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown listen_address '" + config.listen_address + '\'', false);
            }
            if (listenAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("listen_address cannot be a wildcard address (" + config.listen_address + ")!", false);
            }
        } else if (config.listen_interface != null) {
            listenAddress = DatabaseDescriptor.getNetworkInterfaceAddress(config.listen_interface, "listen_interface", config.listen_interface_prefer_ipv6);
        }
        if (config.broadcast_address != null) {
            try {
                broadcastAddress = InetAddress.getByName(config.broadcast_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown broadcast_address '" + config.broadcast_address + '\'', false);
            }
            if (broadcastAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("broadcast_address cannot be a wildcard address (" + config.broadcast_address + ")!", false);
            }
        }
        if (config.rpc_address != null && config.rpc_interface != null) {
            throw new ConfigurationException("Set rpc_address OR rpc_interface, not both", false);
        }
        if (config.rpc_address != null) {
            try {
                rpcAddress = InetAddress.getByName(config.rpc_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown host in rpc_address " + config.rpc_address, false);
            }
        } else {
            rpcAddress = config.rpc_interface != null ? DatabaseDescriptor.getNetworkInterfaceAddress(config.rpc_interface, "rpc_interface", config.rpc_interface_prefer_ipv6) : FBUtilities.getJustLocalAddress();
        }
        if (config.broadcast_rpc_address != null) {
            try {
                broadcastRpcAddress = InetAddress.getByName(config.broadcast_rpc_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown broadcast_rpc_address '" + config.broadcast_rpc_address + '\'', false);
            }
            if (broadcastRpcAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("broadcast_rpc_address cannot be a wildcard address (" + config.broadcast_rpc_address + ")!", false);
            }
        } else if (rpcAddress.isAnyLocalAddress()) {
            throw new ConfigurationException("If rpc_address is set to a wildcard address (" + config.rpc_address + "), then you must set broadcast_rpc_address to a value other than " + config.rpc_address, false);
        }
    }

    public static void applyEncryptionContext() {
        encryptionContext = new EncryptionContext(DatabaseDescriptor.conf.transparent_data_encryption_options);
    }

    public static void applySslContext() {
        try {
            SSLFactory.validateSslContext("Internode messaging", DatabaseDescriptor.conf.server_encryption_options, true, true);
            SSLFactory.validateSslContext("Native transport", DatabaseDescriptor.conf.client_encryption_options, DatabaseDescriptor.conf.client_encryption_options.require_client_auth, true);
            SSLFactory.initHotReloading(DatabaseDescriptor.conf.server_encryption_options, DatabaseDescriptor.conf.client_encryption_options, false);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to initialize SSL", e);
        }
    }

    public static void applySeedProvider() {
        if (DatabaseDescriptor.conf.seed_provider == null) {
            throw new ConfigurationException("seeds configuration is missing; a minimum of one seed is required.", false);
        }
        try {
            Class<?> seedProviderClass = Class.forName(DatabaseDescriptor.conf.seed_provider.class_name);
            seedProvider = (SeedProvider)seedProviderClass.getConstructor(Map.class).newInstance(DatabaseDescriptor.conf.seed_provider.parameters);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.", true);
        }
        if (seedProvider.getSeeds().size() == 0) {
            throw new ConfigurationException("The seed provider lists no seeds.", false);
        }
    }

    @VisibleForTesting
    static void checkForLowestAcceptedTimeouts(Config conf) {
        if (conf.read_request_timeout_in_ms < 10L) {
            DatabaseDescriptor.logInfo("read_request_timeout_in_ms", conf.read_request_timeout_in_ms, 10L);
            conf.read_request_timeout_in_ms = 10L;
        }
        if (conf.range_request_timeout_in_ms < 10L) {
            DatabaseDescriptor.logInfo("range_request_timeout_in_ms", conf.range_request_timeout_in_ms, 10L);
            conf.range_request_timeout_in_ms = 10L;
        }
        if (conf.request_timeout_in_ms < 10L) {
            DatabaseDescriptor.logInfo("request_timeout_in_ms", conf.request_timeout_in_ms, 10L);
            conf.request_timeout_in_ms = 10L;
        }
        if (conf.write_request_timeout_in_ms < 10L) {
            DatabaseDescriptor.logInfo("write_request_timeout_in_ms", conf.write_request_timeout_in_ms, 10L);
            conf.write_request_timeout_in_ms = 10L;
        }
        if (conf.cas_contention_timeout_in_ms < 10L) {
            DatabaseDescriptor.logInfo("cas_contention_timeout_in_ms", conf.cas_contention_timeout_in_ms, 10L);
            conf.cas_contention_timeout_in_ms = 10L;
        }
        if (conf.counter_write_request_timeout_in_ms < 10L) {
            DatabaseDescriptor.logInfo("counter_write_request_timeout_in_ms", conf.counter_write_request_timeout_in_ms, 10L);
            conf.counter_write_request_timeout_in_ms = 10L;
        }
        if (conf.truncate_request_timeout_in_ms < 10L) {
            DatabaseDescriptor.logInfo("truncate_request_timeout_in_ms", conf.truncate_request_timeout_in_ms, 10L);
            conf.truncate_request_timeout_in_ms = 10L;
        }
    }

    private static void logInfo(String property, long actualValue, long lowestAcceptedValue) {
        logger.info("found {}::{} less than lowest acceptable value {}, continuing with {}", new Object[]{property, actualValue, lowestAcceptedValue, lowestAcceptedValue});
    }

    public static void applyTokensConfig() {
        DatabaseDescriptor.applyTokensConfig(conf);
    }

    static void applyTokensConfig(Config conf) {
        if (conf.initial_token != null) {
            Collection<String> tokens = DatabaseDescriptor.tokensFromString(conf.initial_token);
            if (conf.num_tokens == null) {
                if (tokens.size() == 1) {
                    conf.num_tokens = 1;
                } else {
                    throw new ConfigurationException("initial_token was set but num_tokens is not!", false);
                }
            }
            if (tokens.size() != conf.num_tokens.intValue()) {
                throw new ConfigurationException(String.format("The number of initial tokens (by initial_token) specified (%s) is different from num_tokens value (%s)", tokens.size(), conf.num_tokens), false);
            }
            for (String token : tokens) {
                partitioner.getTokenFactory().validate(token);
            }
        } else if (conf.num_tokens == null) {
            conf.num_tokens = 1;
        }
    }

    public static void applySnitch() {
        if (DatabaseDescriptor.conf.endpoint_snitch == null) {
            throw new ConfigurationException("Missing endpoint_snitch directive", false);
        }
        snitch = DatabaseDescriptor.createEndpointSnitch(DatabaseDescriptor.conf.dynamic_snitch, DatabaseDescriptor.conf.endpoint_snitch);
        EndpointSnitchInfo.create();
        localDC = snitch.getLocalDatacenter();
        localComparator = (replica1, replica2) -> {
            boolean local1 = localDC.equals(snitch.getDatacenter((Replica)replica1));
            boolean local2 = localDC.equals(snitch.getDatacenter((Replica)replica2));
            if (local1 && !local2) {
                return -1;
            }
            if (local2 && !local1) {
                return 1;
            }
            return 0;
        };
    }

    public static void applyPartitioner() {
        DatabaseDescriptor.applyPartitioner(conf);
    }

    public static void applyPartitioner(Config conf) {
        if (conf.partitioner == null) {
            throw new ConfigurationException("Missing directive: partitioner", false);
        }
        String name = conf.partitioner;
        try {
            name = System.getProperty("cassandra.partitioner", conf.partitioner);
            partitioner = FBUtilities.newPartitioner(name);
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid partitioner class " + name, e);
        }
        paritionerName = partitioner.getClass().getCanonicalName();
    }

    private static long saturatedSum(long left, long right) {
        assert (left >= 0L && right >= 0L);
        long sum = left + right;
        return sum < 0L ? Long.MAX_VALUE : sum;
    }

    private static FileStore guessFileStore(String dir) throws IOException {
        Path path = Paths.get(dir, new String[0]);
        while (true) {
            try {
                return FileUtils.getFileStore(path);
            }
            catch (IOException e) {
                if (e instanceof NoSuchFileException) {
                    if ((path = path.getParent()) != null) continue;
                    throw new ConfigurationException("Unable to find filesystem for '" + dir + "'.");
                }
                throw e;
            }
            break;
        }
    }

    private static long getUnallocatedSpace(String directory) {
        try {
            return DatabaseDescriptor.guessFileStore(directory).getUnallocatedSpace();
        }
        catch (IOException e) {
            logger.debug("Error checking disk space", (Throwable)e);
            throw new ConfigurationException(String.format("Unable to check disk space available to %s. Perhaps the Cassandra user does not have the necessary permissions", directory), e);
        }
    }

    public static IEndpointSnitch createEndpointSnitch(boolean dynamic, String snitchClassName) throws ConfigurationException {
        if (!snitchClassName.contains(".")) {
            snitchClassName = "org.apache.cassandra.locator." + snitchClassName;
        }
        IEndpointSnitch snitch = (IEndpointSnitch)FBUtilities.construct(snitchClassName, "snitch");
        return dynamic ? new DynamicEndpointSnitch(snitch) : snitch;
    }

    public static IAuthenticator getAuthenticator() {
        return authenticator;
    }

    public static void setAuthenticator(IAuthenticator authenticator) {
        DatabaseDescriptor.authenticator = authenticator;
    }

    public static IAuthorizer getAuthorizer() {
        return authorizer;
    }

    public static void setAuthorizer(IAuthorizer authorizer) {
        DatabaseDescriptor.authorizer = authorizer;
    }

    public static INetworkAuthorizer getNetworkAuthorizer() {
        return networkAuthorizer;
    }

    public static void setNetworkAuthorizer(INetworkAuthorizer networkAuthorizer) {
        DatabaseDescriptor.networkAuthorizer = networkAuthorizer;
    }

    public static IRoleManager getRoleManager() {
        return roleManager;
    }

    public static void setRoleManager(IRoleManager roleManager) {
        DatabaseDescriptor.roleManager = roleManager;
    }

    public static int getPermissionsValidity() {
        return DatabaseDescriptor.conf.permissions_validity_in_ms;
    }

    public static void setPermissionsValidity(int timeout) {
        DatabaseDescriptor.conf.permissions_validity_in_ms = timeout;
    }

    public static int getPermissionsUpdateInterval() {
        return DatabaseDescriptor.conf.permissions_update_interval_in_ms == -1 ? DatabaseDescriptor.conf.permissions_validity_in_ms : DatabaseDescriptor.conf.permissions_update_interval_in_ms;
    }

    public static void setPermissionsUpdateInterval(int updateInterval) {
        DatabaseDescriptor.conf.permissions_update_interval_in_ms = updateInterval;
    }

    public static int getPermissionsCacheMaxEntries() {
        return DatabaseDescriptor.conf.permissions_cache_max_entries;
    }

    public static int setPermissionsCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.permissions_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.permissions_cache_max_entries;
    }

    public static int getRolesValidity() {
        return DatabaseDescriptor.conf.roles_validity_in_ms;
    }

    public static void setRolesValidity(int validity) {
        DatabaseDescriptor.conf.roles_validity_in_ms = validity;
    }

    public static int getRolesUpdateInterval() {
        return DatabaseDescriptor.conf.roles_update_interval_in_ms == -1 ? DatabaseDescriptor.conf.roles_validity_in_ms : DatabaseDescriptor.conf.roles_update_interval_in_ms;
    }

    public static void setRolesUpdateInterval(int interval) {
        DatabaseDescriptor.conf.roles_update_interval_in_ms = interval;
    }

    public static int getRolesCacheMaxEntries() {
        return DatabaseDescriptor.conf.roles_cache_max_entries;
    }

    public static int setRolesCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.roles_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.roles_cache_max_entries;
    }

    public static int getCredentialsValidity() {
        return DatabaseDescriptor.conf.credentials_validity_in_ms;
    }

    public static void setCredentialsValidity(int timeout) {
        DatabaseDescriptor.conf.credentials_validity_in_ms = timeout;
    }

    public static int getCredentialsUpdateInterval() {
        return DatabaseDescriptor.conf.credentials_update_interval_in_ms == -1 ? DatabaseDescriptor.conf.credentials_validity_in_ms : DatabaseDescriptor.conf.credentials_update_interval_in_ms;
    }

    public static void setCredentialsUpdateInterval(int updateInterval) {
        DatabaseDescriptor.conf.credentials_update_interval_in_ms = updateInterval;
    }

    public static int getCredentialsCacheMaxEntries() {
        return DatabaseDescriptor.conf.credentials_cache_max_entries;
    }

    public static int setCredentialsCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.credentials_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.credentials_cache_max_entries;
    }

    public static int getMaxValueSize() {
        return DatabaseDescriptor.conf.max_value_size_in_mb * 1024 * 1024;
    }

    public static void setMaxValueSize(int maxValueSizeInBytes) {
        DatabaseDescriptor.conf.max_value_size_in_mb = maxValueSizeInBytes / 1024 / 1024;
    }

    public static void createAllDirectories() {
        try {
            if (DatabaseDescriptor.conf.data_file_directories.length == 0) {
                throw new ConfigurationException("At least one DataFileDirectory must be specified", false);
            }
            for (String dataFileDirectory : DatabaseDescriptor.conf.data_file_directories) {
                FileUtils.createDirectory(dataFileDirectory);
            }
            if (DatabaseDescriptor.conf.local_system_data_file_directory != null) {
                FileUtils.createDirectory(DatabaseDescriptor.conf.local_system_data_file_directory);
            }
            if (DatabaseDescriptor.conf.commitlog_directory == null) {
                throw new ConfigurationException("commitlog_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.commitlog_directory);
            if (DatabaseDescriptor.conf.hints_directory == null) {
                throw new ConfigurationException("hints_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.hints_directory);
            if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                throw new ConfigurationException("saved_caches_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.saved_caches_directory);
            if (DatabaseDescriptor.conf.cdc_enabled) {
                if (DatabaseDescriptor.conf.cdc_raw_directory == null) {
                    throw new ConfigurationException("cdc_raw_directory must be specified", false);
                }
                FileUtils.createDirectory(DatabaseDescriptor.conf.cdc_raw_directory);
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Bad configuration; unable to start server: " + e.getMessage());
        }
        catch (FSWriteError e) {
            throw new IllegalStateException(e.getCause().getMessage() + "; unable to start server");
        }
    }

    public static IPartitioner getPartitioner() {
        return partitioner;
    }

    public static String getPartitionerName() {
        return paritionerName;
    }

    public static IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner old = partitioner;
        partitioner = newPartitioner;
        return old;
    }

    public static IEndpointSnitch getEndpointSnitch() {
        return snitch;
    }

    public static void setEndpointSnitch(IEndpointSnitch eps) {
        snitch = eps;
    }

    public static int getColumnIndexSize() {
        return (int)ByteUnit.KIBI_BYTES.toBytes(DatabaseDescriptor.conf.column_index_size_in_kb);
    }

    public static int getColumnIndexSizeInKB() {
        return DatabaseDescriptor.conf.column_index_size_in_kb;
    }

    @VisibleForTesting
    public static void setColumnIndexSize(int val) {
        DatabaseDescriptor.checkValidForByteConversion(val, "column_index_size_in_kb", ByteUnit.KIBI_BYTES);
        DatabaseDescriptor.conf.column_index_size_in_kb = val;
    }

    public static int getColumnIndexCacheSize() {
        return (int)ByteUnit.KIBI_BYTES.toBytes(DatabaseDescriptor.conf.column_index_cache_size_in_kb);
    }

    public static int getColumnIndexCacheSizeInKB() {
        return DatabaseDescriptor.conf.column_index_cache_size_in_kb;
    }

    public static void setColumnIndexCacheSize(int val) {
        DatabaseDescriptor.checkValidForByteConversion(val, "column_index_cache_size_in_kb", ByteUnit.KIBI_BYTES);
        DatabaseDescriptor.conf.column_index_cache_size_in_kb = val;
    }

    public static int getBatchSizeWarnThreshold() {
        return (int)ByteUnit.KIBI_BYTES.toBytes(DatabaseDescriptor.conf.batch_size_warn_threshold_in_kb);
    }

    public static int getBatchSizeWarnThresholdInKB() {
        return DatabaseDescriptor.conf.batch_size_warn_threshold_in_kb;
    }

    public static long getBatchSizeFailThreshold() {
        return ByteUnit.KIBI_BYTES.toBytes(DatabaseDescriptor.conf.batch_size_fail_threshold_in_kb);
    }

    public static int getBatchSizeFailThresholdInKB() {
        return DatabaseDescriptor.conf.batch_size_fail_threshold_in_kb;
    }

    public static int getUnloggedBatchAcrossPartitionsWarnThreshold() {
        return DatabaseDescriptor.conf.unlogged_batch_across_partitions_warn_threshold;
    }

    public static void setBatchSizeWarnThresholdInKB(int threshold) {
        DatabaseDescriptor.checkValidForByteConversion(threshold, "batch_size_warn_threshold_in_kb", ByteUnit.KIBI_BYTES);
        DatabaseDescriptor.conf.batch_size_warn_threshold_in_kb = threshold;
    }

    public static void setBatchSizeFailThresholdInKB(int threshold) {
        DatabaseDescriptor.conf.batch_size_fail_threshold_in_kb = threshold;
    }

    public static Collection<String> getInitialTokens() {
        return DatabaseDescriptor.tokensFromString(System.getProperty("cassandra.initial_token", DatabaseDescriptor.conf.initial_token));
    }

    public static String getAllocateTokensForKeyspace() {
        return System.getProperty("cassandra.allocate_tokens_for_keyspace", DatabaseDescriptor.conf.allocate_tokens_for_keyspace);
    }

    public static Integer getAllocateTokensForLocalRf() {
        return DatabaseDescriptor.conf.allocate_tokens_for_local_replication_factor;
    }

    public static Collection<String> tokensFromString(String tokenString) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (tokenString != null) {
            for (String token : StringUtils.split((String)tokenString, (char)',')) {
                tokens.add(token.trim());
            }
        }
        return tokens;
    }

    public static int getNumTokens() {
        return DatabaseDescriptor.conf.num_tokens;
    }

    public static InetAddressAndPort getReplaceAddress() {
        try {
            if (System.getProperty("cassandra.replace_address", null) != null) {
                return InetAddressAndPort.getByName(System.getProperty("cassandra.replace_address", null));
            }
            if (System.getProperty("cassandra.replace_address_first_boot", null) != null) {
                return InetAddressAndPort.getByName(System.getProperty("cassandra.replace_address_first_boot", null));
            }
            return null;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Replacement host name could not be resolved or scope_id was specified for a global IPv6 address", e);
        }
    }

    public static Collection<String> getReplaceTokens() {
        return DatabaseDescriptor.tokensFromString(System.getProperty("cassandra.replace_token", null));
    }

    public static UUID getReplaceNode() {
        try {
            return UUID.fromString(System.getProperty("cassandra.replace_node", null));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static String getClusterName() {
        return DatabaseDescriptor.conf.cluster_name;
    }

    public static int getStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.storage_port", Integer.toString(DatabaseDescriptor.conf.storage_port)));
    }

    public static int getSSLStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.ssl_storage_port", Integer.toString(DatabaseDescriptor.conf.ssl_storage_port)));
    }

    public static long nativeTransportIdleTimeout() {
        return DatabaseDescriptor.conf.native_transport_idle_timeout_in_ms;
    }

    public static void setNativeTransportIdleTimeout(long nativeTransportTimeout) {
        DatabaseDescriptor.conf.native_transport_idle_timeout_in_ms = nativeTransportTimeout;
    }

    public static long getRpcTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.conf.request_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static void setRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.request_timeout_in_ms = timeOutInMillis;
    }

    public static long getReadRpcTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.conf.read_request_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static void setReadRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.read_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getRangeRpcTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.conf.range_request_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static void setRangeRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.range_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getWriteRpcTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.conf.write_request_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static void setWriteRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.write_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getCounterWriteRpcTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.conf.counter_write_request_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static void setCounterWriteRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.counter_write_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getCasContentionTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.conf.cas_contention_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static void setCasContentionTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.cas_contention_timeout_in_ms = timeOutInMillis;
    }

    public static long getTruncateRpcTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.conf.truncate_request_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static void setTruncateRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.truncate_request_timeout_in_ms = timeOutInMillis;
    }

    public static boolean hasCrossNodeTimeout() {
        return DatabaseDescriptor.conf.cross_node_timeout;
    }

    public static void setCrossNodeTimeout(boolean crossNodeTimeout) {
        DatabaseDescriptor.conf.cross_node_timeout = crossNodeTimeout;
    }

    public static long getSlowQueryTimeout(TimeUnit units) {
        return units.convert(DatabaseDescriptor.conf.slow_query_log_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static long getMinRpcTimeout(TimeUnit unit) {
        return Longs.min(DatabaseDescriptor.getRpcTimeout(unit), DatabaseDescriptor.getReadRpcTimeout(unit), DatabaseDescriptor.getRangeRpcTimeout(unit), DatabaseDescriptor.getWriteRpcTimeout(unit), DatabaseDescriptor.getCounterWriteRpcTimeout(unit), DatabaseDescriptor.getTruncateRpcTimeout(unit));
    }

    public static long getPingTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.getBlockForPeersTimeoutInSeconds(), TimeUnit.SECONDS);
    }

    public static long getRepairRpcTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.conf.repair_request_timeout_in_ms, TimeUnit.MILLISECONDS);
    }

    public static void setRepairRpcTimeout(long time, TimeUnit unit) {
        DatabaseDescriptor.conf.repair_request_timeout_in_ms = TimeUnit.MILLISECONDS.convert(time, unit);
    }

    public static double getPhiConvictThreshold() {
        return DatabaseDescriptor.conf.phi_convict_threshold;
    }

    public static void setPhiConvictThreshold(double phiConvictThreshold) {
        DatabaseDescriptor.conf.phi_convict_threshold = phiConvictThreshold;
    }

    public static int getConcurrentReaders() {
        return DatabaseDescriptor.conf.concurrent_reads;
    }

    public static void setConcurrentReaders(int concurrent_reads) {
        if (concurrent_reads < 0) {
            throw new IllegalArgumentException("Concurrent reads must be non-negative");
        }
        DatabaseDescriptor.conf.concurrent_reads = concurrent_reads;
    }

    public static int getConcurrentWriters() {
        return DatabaseDescriptor.conf.concurrent_writes;
    }

    public static void setConcurrentWriters(int concurrent_writers) {
        if (concurrent_writers < 0) {
            throw new IllegalArgumentException("Concurrent reads must be non-negative");
        }
        DatabaseDescriptor.conf.concurrent_writes = concurrent_writers;
    }

    public static int getConcurrentCounterWriters() {
        return DatabaseDescriptor.conf.concurrent_counter_writes;
    }

    public static void setConcurrentCounterWriters(int concurrent_counter_writes) {
        if (concurrent_counter_writes < 0) {
            throw new IllegalArgumentException("Concurrent reads must be non-negative");
        }
        DatabaseDescriptor.conf.concurrent_counter_writes = concurrent_counter_writes;
    }

    public static int getConcurrentViewWriters() {
        return DatabaseDescriptor.conf.concurrent_materialized_view_writes;
    }

    public static void setConcurrentViewWriters(int concurrent_materialized_view_writes) {
        if (concurrent_materialized_view_writes < 0) {
            throw new IllegalArgumentException("Concurrent reads must be non-negative");
        }
        DatabaseDescriptor.conf.concurrent_materialized_view_writes = concurrent_materialized_view_writes;
    }

    public static int getFlushWriters() {
        return DatabaseDescriptor.conf.memtable_flush_writers;
    }

    public static int getConcurrentCompactors() {
        return DatabaseDescriptor.conf.concurrent_compactors;
    }

    public static void setConcurrentCompactors(int value) {
        DatabaseDescriptor.conf.concurrent_compactors = value;
    }

    public static int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.conf.compaction_throughput_mb_per_sec;
    }

    public static void setCompactionThroughputMbPerSec(int value) {
        DatabaseDescriptor.conf.compaction_throughput_mb_per_sec = value;
    }

    public static long getCompactionLargePartitionWarningThreshold() {
        return ByteUnit.MEBI_BYTES.toBytes(DatabaseDescriptor.conf.compaction_large_partition_warning_threshold_mb);
    }

    public static int getConcurrentValidations() {
        return DatabaseDescriptor.conf.concurrent_validations;
    }

    public static void setConcurrentValidations(int value) {
        DatabaseDescriptor.conf.concurrent_validations = value = value > 0 ? value : Integer.MAX_VALUE;
    }

    public static int getConcurrentViewBuilders() {
        return DatabaseDescriptor.conf.concurrent_materialized_view_builders;
    }

    public static void setConcurrentViewBuilders(int value) {
        DatabaseDescriptor.conf.concurrent_materialized_view_builders = value;
    }

    public static long getMinFreeSpacePerDriveInBytes() {
        return ByteUnit.MEBI_BYTES.toBytes(DatabaseDescriptor.conf.min_free_space_per_drive_in_mb);
    }

    public static boolean getDisableSTCSInL0() {
        return disableSTCSInL0;
    }

    public static void setDisableSTCSInL0(boolean disabled) {
        disableSTCSInL0 = disabled;
    }

    public static int getStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec;
    }

    public static void setStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec = value;
    }

    public static int getInterDCStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound_megabits_per_sec;
    }

    public static void setInterDCStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound_megabits_per_sec = value;
    }

    public static boolean useSpecificLocationForLocalSystemData() {
        return DatabaseDescriptor.conf.local_system_data_file_directory != null;
    }

    public static String[] getLocalSystemKeyspacesDataFileLocations() {
        String[] stringArray;
        if (DatabaseDescriptor.useSpecificLocationForLocalSystemData()) {
            return new String[]{DatabaseDescriptor.conf.local_system_data_file_directory};
        }
        if (DatabaseDescriptor.conf.data_file_directories.length == 0) {
            stringArray = DatabaseDescriptor.conf.data_file_directories;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = DatabaseDescriptor.conf.data_file_directories[0];
        }
        return stringArray;
    }

    public static String[] getNonLocalSystemKeyspacesDataFileLocations() {
        return DatabaseDescriptor.conf.data_file_directories;
    }

    public static String[] getAllDataFileLocations() {
        if (DatabaseDescriptor.conf.local_system_data_file_directory == null) {
            return DatabaseDescriptor.conf.data_file_directories;
        }
        return (String[])ArrayUtils.addFirst((Object[])DatabaseDescriptor.conf.data_file_directories, (Object)DatabaseDescriptor.conf.local_system_data_file_directory);
    }

    public static String getCommitLogLocation() {
        return DatabaseDescriptor.conf.commitlog_directory;
    }

    @VisibleForTesting
    public static void setCommitLogLocation(String value) {
        DatabaseDescriptor.conf.commitlog_directory = value;
    }

    public static ParameterizedClass getCommitLogCompression() {
        return DatabaseDescriptor.conf.commitlog_compression;
    }

    public static void setCommitLogCompression(ParameterizedClass compressor) {
        DatabaseDescriptor.conf.commitlog_compression = compressor;
    }

    public static Config.FlushCompression getFlushCompression() {
        return DatabaseDescriptor.conf.flush_compression;
    }

    public static void setFlushCompression(Config.FlushCompression compression) {
        DatabaseDescriptor.conf.flush_compression = compression;
    }

    public static int getCommitLogMaxCompressionBuffersInPool() {
        return DatabaseDescriptor.conf.commitlog_max_compression_buffers_in_pool;
    }

    public static void setCommitLogMaxCompressionBuffersPerPool(int buffers) {
        DatabaseDescriptor.conf.commitlog_max_compression_buffers_in_pool = buffers;
    }

    public static int getMaxMutationSize() {
        return (int)ByteUnit.KIBI_BYTES.toBytes(DatabaseDescriptor.conf.max_mutation_size_in_kb);
    }

    public static int getTombstoneWarnThreshold() {
        return DatabaseDescriptor.conf.tombstone_warn_threshold;
    }

    public static void setTombstoneWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.tombstone_warn_threshold = threshold;
    }

    public static int getTombstoneFailureThreshold() {
        return DatabaseDescriptor.conf.tombstone_failure_threshold;
    }

    public static void setTombstoneFailureThreshold(int threshold) {
        DatabaseDescriptor.conf.tombstone_failure_threshold = threshold;
    }

    public static int getCachedReplicaRowsWarnThreshold() {
        return DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_warn_threshold;
    }

    public static void setCachedReplicaRowsWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_warn_threshold = threshold;
    }

    public static int getCachedReplicaRowsFailThreshold() {
        return DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_fail_threshold;
    }

    public static void setCachedReplicaRowsFailThreshold(int threshold) {
        DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_fail_threshold = threshold;
    }

    public static int getCommitLogSegmentSize() {
        return (int)ByteUnit.MEBI_BYTES.toBytes(DatabaseDescriptor.conf.commitlog_segment_size_in_mb);
    }

    public static void setCommitLogSegmentSize(int sizeMegabytes) {
        DatabaseDescriptor.conf.commitlog_segment_size_in_mb = sizeMegabytes;
    }

    public static String getSavedCachesLocation() {
        return DatabaseDescriptor.conf.saved_caches_directory;
    }

    public static Set<InetAddressAndPort> getSeeds() {
        return ((ImmutableSet.Builder)ImmutableSet.builder().addAll(seedProvider.getSeeds())).build();
    }

    public static SeedProvider getSeedProvider() {
        return seedProvider;
    }

    public static void setSeedProvider(SeedProvider newSeedProvider) {
        seedProvider = newSeedProvider;
    }

    public static InetAddress getListenAddress() {
        return listenAddress;
    }

    public static void setListenAddress(InetAddress newlistenAddress) {
        listenAddress = newlistenAddress;
    }

    public static InetAddress getBroadcastAddress() {
        return broadcastAddress;
    }

    public static boolean shouldListenOnBroadcastAddress() {
        return DatabaseDescriptor.conf.listen_on_broadcast_address;
    }

    public static void setShouldListenOnBroadcastAddress(boolean shouldListenOnBroadcastAddress) {
        DatabaseDescriptor.conf.listen_on_broadcast_address = shouldListenOnBroadcastAddress;
    }

    public static void setListenOnBroadcastAddress(boolean listen_on_broadcast_address) {
        DatabaseDescriptor.conf.listen_on_broadcast_address = listen_on_broadcast_address;
    }

    public static IInternodeAuthenticator getInternodeAuthenticator() {
        return internodeAuthenticator;
    }

    public static void setInternodeAuthenticator(IInternodeAuthenticator internodeAuthenticator) {
        Preconditions.checkNotNull(internodeAuthenticator);
        DatabaseDescriptor.internodeAuthenticator = internodeAuthenticator;
    }

    public static void setBroadcastAddress(InetAddress broadcastAdd) {
        broadcastAddress = broadcastAdd;
    }

    public static InetAddress getRpcAddress() {
        return rpcAddress;
    }

    public static void setBroadcastRpcAddress(InetAddress broadcastRPCAddr) {
        broadcastRpcAddress = broadcastRPCAddr;
    }

    public static InetAddress getBroadcastRpcAddress() {
        return broadcastRpcAddress;
    }

    public static boolean getRpcKeepAlive() {
        return DatabaseDescriptor.conf.rpc_keepalive;
    }

    public static int getInternodeSocketSendBufferSizeInBytes() {
        return DatabaseDescriptor.conf.internode_socket_send_buffer_size_in_bytes;
    }

    public static int getInternodeSocketReceiveBufferSizeInBytes() {
        return DatabaseDescriptor.conf.internode_socket_receive_buffer_size_in_bytes;
    }

    public static int getInternodeApplicationSendQueueCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_send_queue_capacity_in_bytes;
    }

    public static int getInternodeApplicationSendQueueReserveEndpointCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_send_queue_reserve_endpoint_capacity_in_bytes;
    }

    public static int getInternodeApplicationSendQueueReserveGlobalCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_send_queue_reserve_global_capacity_in_bytes;
    }

    public static int getInternodeApplicationReceiveQueueCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_receive_queue_capacity_in_bytes;
    }

    public static int getInternodeApplicationReceiveQueueReserveEndpointCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_receive_queue_reserve_endpoint_capacity_in_bytes;
    }

    public static int getInternodeApplicationReceiveQueueReserveGlobalCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_receive_queue_reserve_global_capacity_in_bytes;
    }

    public static int getInternodeTcpConnectTimeoutInMS() {
        return DatabaseDescriptor.conf.internode_tcp_connect_timeout_in_ms;
    }

    public static void setInternodeTcpConnectTimeoutInMS(int value) {
        DatabaseDescriptor.conf.internode_tcp_connect_timeout_in_ms = value;
    }

    public static int getInternodeTcpUserTimeoutInMS() {
        return DatabaseDescriptor.conf.internode_tcp_user_timeout_in_ms;
    }

    public static void setInternodeTcpUserTimeoutInMS(int value) {
        DatabaseDescriptor.conf.internode_tcp_user_timeout_in_ms = value;
    }

    public static int getInternodeStreamingTcpUserTimeoutInMS() {
        return DatabaseDescriptor.conf.internode_streaming_tcp_user_timeout_in_ms;
    }

    public static void setInternodeStreamingTcpUserTimeoutInMS(int value) {
        DatabaseDescriptor.conf.internode_streaming_tcp_user_timeout_in_ms = value;
    }

    public static int getInternodeMaxMessageSizeInBytes() {
        return DatabaseDescriptor.conf.internode_max_message_size_in_bytes;
    }

    @VisibleForTesting
    public static void setInternodeMaxMessageSizeInBytes(int value) {
        DatabaseDescriptor.conf.internode_max_message_size_in_bytes = value;
    }

    public static boolean startNativeTransport() {
        return DatabaseDescriptor.conf.start_native_transport;
    }

    public static int getNativeTransportPort() {
        return Integer.parseInt(System.getProperty("cassandra.native_transport_port", Integer.toString(DatabaseDescriptor.conf.native_transport_port)));
    }

    @VisibleForTesting
    public static void setNativeTransportPort(int port) {
        DatabaseDescriptor.conf.native_transport_port = port;
    }

    public static int getNativeTransportPortSSL() {
        return DatabaseDescriptor.conf.native_transport_port_ssl == null ? DatabaseDescriptor.getNativeTransportPort() : DatabaseDescriptor.conf.native_transport_port_ssl;
    }

    @VisibleForTesting
    public static void setNativeTransportPortSSL(Integer port) {
        DatabaseDescriptor.conf.native_transport_port_ssl = port;
    }

    public static int getNativeTransportMaxThreads() {
        return DatabaseDescriptor.conf.native_transport_max_threads;
    }

    public static void setNativeTransportMaxThreads(int max_threads) {
        DatabaseDescriptor.conf.native_transport_max_threads = max_threads;
    }

    public static Integer getNativeTransportMaxAuthThreads() {
        return DatabaseDescriptor.conf.native_transport_max_auth_threads;
    }

    public static void setNativeTransportMaxAuthThreads(int threads) {
        DatabaseDescriptor.conf.native_transport_max_auth_threads = threads;
    }

    public static int getNativeTransportMaxFrameSize() {
        return (int)ByteUnit.MEBI_BYTES.toBytes(DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb);
    }

    public static long getNativeTransportMaxConcurrentConnections() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_connections;
    }

    public static void setNativeTransportMaxConcurrentConnections(long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_connections = nativeTransportMaxConcurrentConnections;
    }

    public static long getNativeTransportMaxConcurrentConnectionsPerIp() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_connections_per_ip;
    }

    public static void setNativeTransportMaxConcurrentConnectionsPerIp(long native_transport_max_concurrent_connections_per_ip) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_connections_per_ip = native_transport_max_concurrent_connections_per_ip;
    }

    public static boolean useNativeTransportLegacyFlusher() {
        return DatabaseDescriptor.conf.native_transport_flush_in_batches_legacy;
    }

    public static boolean getNativeTransportAllowOlderProtocols() {
        return DatabaseDescriptor.conf.native_transport_allow_older_protocols;
    }

    public static void setNativeTransportAllowOlderProtocols(boolean isEnabled) {
        DatabaseDescriptor.conf.native_transport_allow_older_protocols = isEnabled;
    }

    public static double getCommitLogSyncGroupWindow() {
        return DatabaseDescriptor.conf.commitlog_sync_group_window_in_ms;
    }

    public static void setCommitLogSyncGroupWindow(double windowMillis) {
        DatabaseDescriptor.conf.commitlog_sync_group_window_in_ms = windowMillis;
    }

    public static int getNativeTransportReceiveQueueCapacityInBytes() {
        return DatabaseDescriptor.conf.native_transport_receive_queue_capacity_in_bytes;
    }

    public static void setNativeTransportReceiveQueueCapacityInBytes(int queueSize) {
        DatabaseDescriptor.conf.native_transport_receive_queue_capacity_in_bytes = queueSize;
    }

    public static long getNativeTransportMaxConcurrentRequestsInBytesPerIp() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes_per_ip;
    }

    public static void setNativeTransportMaxConcurrentRequestsInBytesPerIp(long maxConcurrentRequestsInBytes) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes_per_ip = maxConcurrentRequestsInBytes;
    }

    public static long getNativeTransportMaxConcurrentRequestsInBytes() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes;
    }

    public static void setNativeTransportMaxConcurrentRequestsInBytes(long maxConcurrentRequestsInBytes) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes = maxConcurrentRequestsInBytes;
    }

    public static int getCommitLogSyncPeriod() {
        return DatabaseDescriptor.conf.commitlog_sync_period_in_ms;
    }

    public static long getPeriodicCommitLogSyncBlock() {
        Integer blockMillis = DatabaseDescriptor.conf.periodic_commitlog_sync_lag_block_in_ms;
        return blockMillis == null ? (long)((double)DatabaseDescriptor.getCommitLogSyncPeriod() * 1.5) : (long)blockMillis.intValue();
    }

    public static void setCommitLogSyncPeriod(int periodMillis) {
        DatabaseDescriptor.conf.commitlog_sync_period_in_ms = periodMillis;
    }

    public static Config.CommitLogSync getCommitLogSync() {
        return DatabaseDescriptor.conf.commitlog_sync;
    }

    public static void setCommitLogSync(Config.CommitLogSync sync) {
        DatabaseDescriptor.conf.commitlog_sync = sync;
    }

    public static Config.DiskAccessMode getDiskAccessMode() {
        return DatabaseDescriptor.conf.disk_access_mode;
    }

    @VisibleForTesting
    public static void setDiskAccessMode(Config.DiskAccessMode mode) {
        DatabaseDescriptor.conf.disk_access_mode = mode;
    }

    public static Config.DiskAccessMode getIndexAccessMode() {
        return indexAccessMode;
    }

    @VisibleForTesting
    public static void setIndexAccessMode(Config.DiskAccessMode mode) {
        indexAccessMode = mode;
    }

    public static void setDiskFailurePolicy(Config.DiskFailurePolicy policy) {
        DatabaseDescriptor.conf.disk_failure_policy = policy;
    }

    public static Config.DiskFailurePolicy getDiskFailurePolicy() {
        return DatabaseDescriptor.conf.disk_failure_policy;
    }

    public static void setCommitFailurePolicy(Config.CommitFailurePolicy policy) {
        DatabaseDescriptor.conf.commit_failure_policy = policy;
    }

    public static Config.CommitFailurePolicy getCommitFailurePolicy() {
        return DatabaseDescriptor.conf.commit_failure_policy;
    }

    public static boolean isSnapshotBeforeCompaction() {
        return DatabaseDescriptor.conf.snapshot_before_compaction;
    }

    public static boolean isAutoSnapshot() {
        return DatabaseDescriptor.conf.auto_snapshot;
    }

    @VisibleForTesting
    public static void setAutoSnapshot(boolean autoSnapshot) {
        DatabaseDescriptor.conf.auto_snapshot = autoSnapshot;
    }

    @VisibleForTesting
    public static boolean getAutoSnapshot() {
        return DatabaseDescriptor.conf.auto_snapshot;
    }

    public static long getSnapshotLinksPerSecond() {
        return DatabaseDescriptor.conf.snapshot_links_per_second == 0L ? Long.MAX_VALUE : DatabaseDescriptor.conf.snapshot_links_per_second;
    }

    public static void setSnapshotLinksPerSecond(long throttle) {
        if (throttle < 0L) {
            throw new IllegalArgumentException("Invalid throttle for snapshot_links_per_second: must be positive");
        }
        DatabaseDescriptor.conf.snapshot_links_per_second = throttle;
    }

    public static RateLimiter getSnapshotRateLimiter() {
        return RateLimiter.create(DatabaseDescriptor.getSnapshotLinksPerSecond());
    }

    public static boolean isAutoBootstrap() {
        return Boolean.parseBoolean(System.getProperty("cassandra.auto_bootstrap", Boolean.toString(DatabaseDescriptor.conf.auto_bootstrap)));
    }

    public static void setHintedHandoffEnabled(boolean hintedHandoffEnabled) {
        DatabaseDescriptor.conf.hinted_handoff_enabled = hintedHandoffEnabled;
    }

    public static boolean hintedHandoffEnabled() {
        return DatabaseDescriptor.conf.hinted_handoff_enabled;
    }

    public static Set<String> hintedHandoffDisabledDCs() {
        return DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters;
    }

    public static void enableHintsForDC(String dc) {
        DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters.remove(dc);
    }

    public static void disableHintsForDC(String dc) {
        DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters.add(dc);
    }

    public static void setMaxHintWindow(int ms) {
        DatabaseDescriptor.conf.max_hint_window_in_ms = ms;
    }

    public static int getMaxHintWindow() {
        return DatabaseDescriptor.conf.max_hint_window_in_ms;
    }

    public static File getHintsDirectory() {
        return new File(DatabaseDescriptor.conf.hints_directory);
    }

    public static File getSerializedCachePath(CacheService.CacheType cacheType, String version, String extension) {
        String name = cacheType.toString() + (version == null ? "" : '-' + version + '.' + extension);
        return new File(DatabaseDescriptor.conf.saved_caches_directory, name);
    }

    public static int getDynamicUpdateInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms;
    }

    public static void setDynamicUpdateInterval(int dynamicUpdateInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms = dynamicUpdateInterval;
    }

    public static int getDynamicResetInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms;
    }

    public static void setDynamicResetInterval(int dynamicResetInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms = dynamicResetInterval;
    }

    public static double getDynamicBadnessThreshold() {
        return DatabaseDescriptor.conf.dynamic_snitch_badness_threshold;
    }

    public static void setDynamicBadnessThreshold(double dynamicBadnessThreshold) {
        DatabaseDescriptor.conf.dynamic_snitch_badness_threshold = dynamicBadnessThreshold;
    }

    public static EncryptionOptions.ServerEncryptionOptions getInternodeMessagingEncyptionOptions() {
        return DatabaseDescriptor.conf.server_encryption_options;
    }

    public static void setInternodeMessagingEncyptionOptions(EncryptionOptions.ServerEncryptionOptions encryptionOptions) {
        DatabaseDescriptor.conf.server_encryption_options = encryptionOptions;
    }

    public static EncryptionOptions getNativeProtocolEncryptionOptions() {
        return DatabaseDescriptor.conf.client_encryption_options;
    }

    @VisibleForTesting
    public static void updateNativeProtocolEncryptionOptions(Function<EncryptionOptions, EncryptionOptions> update) {
        DatabaseDescriptor.conf.client_encryption_options = update.apply(DatabaseDescriptor.conf.client_encryption_options);
    }

    public static int getHintedHandoffThrottleInKB() {
        return DatabaseDescriptor.conf.hinted_handoff_throttle_in_kb;
    }

    public static void setHintedHandoffThrottleInKB(int throttleInKB) {
        DatabaseDescriptor.conf.hinted_handoff_throttle_in_kb = throttleInKB;
    }

    public static int getBatchlogReplayThrottleInKB() {
        return DatabaseDescriptor.conf.batchlog_replay_throttle_in_kb;
    }

    public static void setBatchlogReplayThrottleInKB(int throttleInKB) {
        DatabaseDescriptor.conf.batchlog_replay_throttle_in_kb = throttleInKB;
    }

    public static boolean isDynamicEndpointSnitch() {
        return snitch instanceof DynamicEndpointSnitch;
    }

    public static Config.BatchlogEndpointStrategy getBatchlogEndpointStrategy() {
        return DatabaseDescriptor.conf.batchlog_endpoint_strategy;
    }

    public static void setBatchlogEndpointStrategy(Config.BatchlogEndpointStrategy batchlogEndpointStrategy) {
        DatabaseDescriptor.conf.batchlog_endpoint_strategy = batchlogEndpointStrategy;
    }

    public static int getMaxHintsDeliveryThreads() {
        return DatabaseDescriptor.conf.max_hints_delivery_threads;
    }

    public static int getHintsFlushPeriodInMS() {
        return DatabaseDescriptor.conf.hints_flush_period_in_ms;
    }

    public static long getMaxHintsFileSize() {
        return ByteUnit.MEBI_BYTES.toBytes(DatabaseDescriptor.conf.max_hints_file_size_in_mb);
    }

    public static ParameterizedClass getHintsCompression() {
        return DatabaseDescriptor.conf.hints_compression;
    }

    public static void setHintsCompression(ParameterizedClass parameterizedClass) {
        DatabaseDescriptor.conf.hints_compression = parameterizedClass;
    }

    public static boolean getTransferHintsOnDecommission() {
        return DatabaseDescriptor.conf.transfer_hints_on_decommission;
    }

    public static void setTransferHintsOnDecommission(boolean enabled) {
        DatabaseDescriptor.conf.transfer_hints_on_decommission = enabled;
    }

    public static boolean isUseCreationTimeForHintTtl() {
        return DatabaseDescriptor.conf.use_creation_time_for_hint_ttl;
    }

    public static void setUseCreationTimeForHintTtl(boolean enabled) {
        DatabaseDescriptor.conf.use_creation_time_for_hint_ttl = enabled;
    }

    public static boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.conf.incremental_backups;
    }

    public static void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.conf.incremental_backups = value;
    }

    public static boolean getFileCacheEnabled() {
        return DatabaseDescriptor.conf.file_cache_enabled;
    }

    public static int getFileCacheSizeInMB() {
        if (DatabaseDescriptor.conf.file_cache_size_in_mb == null) {
            assert (DatabaseDescriptor.isClientInitialized());
            return 0;
        }
        return DatabaseDescriptor.conf.file_cache_size_in_mb;
    }

    public static int getNetworkingCacheSizeInMB() {
        if (DatabaseDescriptor.conf.networking_cache_size_in_mb == null) {
            assert (DatabaseDescriptor.isClientInitialized());
            return 0;
        }
        return DatabaseDescriptor.conf.networking_cache_size_in_mb;
    }

    public static boolean getFileCacheRoundUp() {
        if (DatabaseDescriptor.conf.file_cache_round_up == null) {
            assert (DatabaseDescriptor.isClientInitialized());
            return false;
        }
        return DatabaseDescriptor.conf.file_cache_round_up;
    }

    public static DiskOptimizationStrategy getDiskOptimizationStrategy() {
        return diskOptimizationStrategy;
    }

    public static double getDiskOptimizationEstimatePercentile() {
        return DatabaseDescriptor.conf.disk_optimization_estimate_percentile;
    }

    public static long getTotalCommitlogSpaceInMB() {
        return DatabaseDescriptor.conf.commitlog_total_space_in_mb.intValue();
    }

    public static boolean shouldMigrateKeycacheOnCompaction() {
        return DatabaseDescriptor.conf.key_cache_migrate_during_compaction;
    }

    public static void setMigrateKeycacheOnCompaction(boolean migrateCacheEntry) {
        DatabaseDescriptor.conf.key_cache_migrate_during_compaction = migrateCacheEntry;
    }

    public static int getSSTablePreemptiveOpenIntervalInMB() {
        return FBUtilities.isWindows ? -1 : DatabaseDescriptor.conf.sstable_preemptive_open_interval_in_mb;
    }

    public static void setSSTablePreemptiveOpenIntervalInMB(int mb) {
        DatabaseDescriptor.conf.sstable_preemptive_open_interval_in_mb = mb;
    }

    public static boolean getTrickleFsync() {
        return DatabaseDescriptor.conf.trickle_fsync;
    }

    public static int getTrickleFsyncIntervalInKb() {
        return DatabaseDescriptor.conf.trickle_fsync_interval_in_kb;
    }

    public static long getKeyCacheSizeInMB() {
        return keyCacheSizeInMB;
    }

    public static long getIndexSummaryCapacityInMB() {
        return indexSummaryCapacityInMB;
    }

    public static int getKeyCacheSavePeriod() {
        return DatabaseDescriptor.conf.key_cache_save_period;
    }

    public static void setKeyCacheSavePeriod(int keyCacheSavePeriod) {
        DatabaseDescriptor.conf.key_cache_save_period = keyCacheSavePeriod;
    }

    public static int getKeyCacheKeysToSave() {
        return DatabaseDescriptor.conf.key_cache_keys_to_save;
    }

    public static void setKeyCacheKeysToSave(int keyCacheKeysToSave) {
        DatabaseDescriptor.conf.key_cache_keys_to_save = keyCacheKeysToSave;
    }

    public static String getRowCacheClassName() {
        return DatabaseDescriptor.conf.row_cache_class_name;
    }

    public static long getRowCacheSizeInMB() {
        return DatabaseDescriptor.conf.row_cache_size_in_mb;
    }

    @VisibleForTesting
    public static void setRowCacheSizeInMB(long val) {
        DatabaseDescriptor.conf.row_cache_size_in_mb = val;
    }

    public static int getRowCacheSavePeriod() {
        return DatabaseDescriptor.conf.row_cache_save_period;
    }

    public static void setRowCacheSavePeriod(int rowCacheSavePeriod) {
        DatabaseDescriptor.conf.row_cache_save_period = rowCacheSavePeriod;
    }

    public static int getRowCacheKeysToSave() {
        return DatabaseDescriptor.conf.row_cache_keys_to_save;
    }

    public static long getCounterCacheSizeInMB() {
        return counterCacheSizeInMB;
    }

    public static void setRowCacheKeysToSave(int rowCacheKeysToSave) {
        DatabaseDescriptor.conf.row_cache_keys_to_save = rowCacheKeysToSave;
    }

    public static int getCounterCacheSavePeriod() {
        return DatabaseDescriptor.conf.counter_cache_save_period;
    }

    public static void setCounterCacheSavePeriod(int counterCacheSavePeriod) {
        DatabaseDescriptor.conf.counter_cache_save_period = counterCacheSavePeriod;
    }

    public static int getCacheLoadTimeout() {
        return DatabaseDescriptor.conf.cache_load_timeout_seconds;
    }

    @VisibleForTesting
    public static void setCacheLoadTimeout(int seconds) {
        DatabaseDescriptor.conf.cache_load_timeout_seconds = seconds;
    }

    public static int getCounterCacheKeysToSave() {
        return DatabaseDescriptor.conf.counter_cache_keys_to_save;
    }

    public static void setCounterCacheKeysToSave(int counterCacheKeysToSave) {
        DatabaseDescriptor.conf.counter_cache_keys_to_save = counterCacheKeysToSave;
    }

    public static int getStreamingKeepAlivePeriod() {
        return DatabaseDescriptor.conf.streaming_keep_alive_period_in_secs;
    }

    public static int getStreamingConnectionsPerHost() {
        return DatabaseDescriptor.conf.streaming_connections_per_host;
    }

    public static boolean streamEntireSSTables() {
        return DatabaseDescriptor.conf.stream_entire_sstables;
    }

    public static String getLocalDataCenter() {
        return localDC;
    }

    public static Comparator<Replica> getLocalComparator() {
        return localComparator;
    }

    public static Config.InternodeCompression internodeCompression() {
        return DatabaseDescriptor.conf.internode_compression;
    }

    public static void setInternodeCompression(Config.InternodeCompression compression) {
        DatabaseDescriptor.conf.internode_compression = compression;
    }

    public static boolean getInterDCTcpNoDelay() {
        return DatabaseDescriptor.conf.inter_dc_tcp_nodelay;
    }

    public static long getMemtableHeapSpaceInMb() {
        return DatabaseDescriptor.conf.memtable_heap_space_in_mb.intValue();
    }

    public static long getMemtableOffheapSpaceInMb() {
        return DatabaseDescriptor.conf.memtable_offheap_space_in_mb.intValue();
    }

    public static Config.MemtableAllocationType getMemtableAllocationType() {
        return DatabaseDescriptor.conf.memtable_allocation_type;
    }

    public static int getRepairSessionMaxTreeDepth() {
        return DatabaseDescriptor.conf.repair_session_max_tree_depth;
    }

    public static void setRepairSessionMaxTreeDepth(int depth) {
        if (depth < 10) {
            throw new ConfigurationException("Cannot set repair_session_max_tree_depth to " + depth + " which is < 10, doing nothing");
        }
        if (depth > 20) {
            logger.warn("repair_session_max_tree_depth of " + depth + " > 20 could lead to excessive memory usage");
        }
        DatabaseDescriptor.conf.repair_session_max_tree_depth = depth;
    }

    public static int getRepairSessionSpaceInMegabytes() {
        return DatabaseDescriptor.conf.repair_session_space_in_mb;
    }

    public static void setRepairSessionSpaceInMegabytes(int sizeInMegabytes) {
        if (sizeInMegabytes < 1) {
            throw new ConfigurationException("Cannot set repair_session_space_in_mb to " + sizeInMegabytes + " < 1 megabyte");
        }
        if (sizeInMegabytes > (int)(Runtime.getRuntime().maxMemory() / 0x400000L)) {
            logger.warn("A repair_session_space_in_mb of " + DatabaseDescriptor.conf.repair_session_space_in_mb + " megabytes is likely to cause heap pressure.");
        }
        DatabaseDescriptor.conf.repair_session_space_in_mb = sizeInMegabytes;
    }

    public static int getConcurrentMerkleTreeRequests() {
        return DatabaseDescriptor.conf.concurrent_merkle_tree_requests;
    }

    public static void setConcurrentMerkleTreeRequests(int value) {
        DatabaseDescriptor.conf.concurrent_merkle_tree_requests = value;
    }

    public static Float getMemtableCleanupThreshold() {
        return DatabaseDescriptor.conf.memtable_cleanup_threshold;
    }

    public static int getIndexSummaryResizeIntervalInMinutes() {
        return DatabaseDescriptor.conf.index_summary_resize_interval_in_minutes;
    }

    public static void setIndexSummaryResizeIntervalInMinutes(int value) {
        DatabaseDescriptor.conf.index_summary_resize_interval_in_minutes = value;
    }

    public static boolean hasLargeAddressSpace() {
        String arch;
        String datamodel = CassandraRelevantProperties.SUN_ARCH_DATA_MODEL.getString();
        if (datamodel != null) {
            switch (datamodel) {
                case "64": {
                    return true;
                }
                case "32": {
                    return false;
                }
            }
        }
        return (arch = CassandraRelevantProperties.OS_ARCH.getString()).contains("64") || arch.contains("sparcv9");
    }

    public static int getTracetypeRepairTTL() {
        return DatabaseDescriptor.conf.tracetype_repair_ttl;
    }

    public static int getTracetypeQueryTTL() {
        return DatabaseDescriptor.conf.tracetype_query_ttl;
    }

    public static int getWindowsTimerInterval() {
        return DatabaseDescriptor.conf.windows_timer_interval;
    }

    public static long getPreparedStatementsCacheSizeMB() {
        return preparedStatementsCacheSizeInMB;
    }

    public static boolean enableUserDefinedFunctions() {
        return DatabaseDescriptor.conf.enable_user_defined_functions;
    }

    public static boolean enableScriptedUserDefinedFunctions() {
        return DatabaseDescriptor.conf.enable_scripted_user_defined_functions;
    }

    public static void enableScriptedUserDefinedFunctions(boolean enableScriptedUserDefinedFunctions) {
        DatabaseDescriptor.conf.enable_scripted_user_defined_functions = enableScriptedUserDefinedFunctions;
    }

    public static boolean enableUserDefinedFunctionsThreads() {
        return DatabaseDescriptor.conf.enable_user_defined_functions_threads;
    }

    public static long getUserDefinedFunctionWarnTimeout() {
        return DatabaseDescriptor.conf.user_defined_function_warn_timeout;
    }

    public static void setUserDefinedFunctionWarnTimeout(long userDefinedFunctionWarnTimeout) {
        DatabaseDescriptor.conf.user_defined_function_warn_timeout = userDefinedFunctionWarnTimeout;
    }

    public static boolean allowInsecureUDFs() {
        return DatabaseDescriptor.conf.allow_insecure_udfs;
    }

    public static boolean allowExtraInsecureUDFs() {
        return DatabaseDescriptor.conf.allow_extra_insecure_udfs;
    }

    public static boolean getEnableMaterializedViews() {
        return DatabaseDescriptor.conf.enable_materialized_views;
    }

    public static void setEnableMaterializedViews(boolean enableMaterializedViews) {
        DatabaseDescriptor.conf.enable_materialized_views = enableMaterializedViews;
    }

    public static boolean getEnableSASIIndexes() {
        return DatabaseDescriptor.conf.enable_sasi_indexes;
    }

    public static void setEnableSASIIndexes(boolean enableSASIIndexes) {
        DatabaseDescriptor.conf.enable_sasi_indexes = enableSASIIndexes;
    }

    public static boolean isTransientReplicationEnabled() {
        return DatabaseDescriptor.conf.enable_transient_replication;
    }

    public static void setTransientReplicationEnabledUnsafe(boolean enabled) {
        DatabaseDescriptor.conf.enable_transient_replication = enabled;
    }

    public static boolean enableDropCompactStorage() {
        return DatabaseDescriptor.conf.enable_drop_compact_storage;
    }

    @VisibleForTesting
    public static void setEnableDropCompactStorage(boolean enableDropCompactStorage) {
        DatabaseDescriptor.conf.enable_drop_compact_storage = enableDropCompactStorage;
    }

    public static long getUserDefinedFunctionFailTimeout() {
        return DatabaseDescriptor.conf.user_defined_function_fail_timeout;
    }

    public static void setUserDefinedFunctionFailTimeout(long userDefinedFunctionFailTimeout) {
        DatabaseDescriptor.conf.user_defined_function_fail_timeout = userDefinedFunctionFailTimeout;
    }

    public static Config.UserFunctionTimeoutPolicy getUserFunctionTimeoutPolicy() {
        return DatabaseDescriptor.conf.user_function_timeout_policy;
    }

    public static void setUserFunctionTimeoutPolicy(Config.UserFunctionTimeoutPolicy userFunctionTimeoutPolicy) {
        DatabaseDescriptor.conf.user_function_timeout_policy = userFunctionTimeoutPolicy;
    }

    public static long getGCLogThreshold() {
        return DatabaseDescriptor.conf.gc_log_threshold_in_ms;
    }

    public static void setGCLogThreshold(int gcLogThreshold) {
        DatabaseDescriptor.conf.gc_log_threshold_in_ms = gcLogThreshold;
    }

    public static EncryptionContext getEncryptionContext() {
        return encryptionContext;
    }

    public static long getGCWarnThreshold() {
        return DatabaseDescriptor.conf.gc_warn_threshold_in_ms;
    }

    public static void setGCWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.gc_warn_threshold_in_ms = threshold;
    }

    public static boolean isCDCEnabled() {
        return DatabaseDescriptor.conf.cdc_enabled;
    }

    @VisibleForTesting
    public static void setCDCEnabled(boolean cdc_enabled) {
        DatabaseDescriptor.conf.cdc_enabled = cdc_enabled;
    }

    public static String getCDCLogLocation() {
        return DatabaseDescriptor.conf.cdc_raw_directory;
    }

    public static int getCDCSpaceInMB() {
        return DatabaseDescriptor.conf.cdc_total_space_in_mb;
    }

    @VisibleForTesting
    public static void setCDCSpaceInMB(int input) {
        DatabaseDescriptor.conf.cdc_total_space_in_mb = input;
    }

    public static int getCDCDiskCheckInterval() {
        return DatabaseDescriptor.conf.cdc_free_space_check_interval_ms;
    }

    @VisibleForTesting
    public static void setEncryptionContext(EncryptionContext ec) {
        encryptionContext = ec;
    }

    public static int searchConcurrencyFactor() {
        return searchConcurrencyFactor;
    }

    public static boolean isUnsafeSystem() {
        return unsafeSystem;
    }

    public static boolean diagnosticEventsEnabled() {
        return DatabaseDescriptor.conf.diagnostic_events_enabled;
    }

    public static void setDiagnosticEventsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.diagnostic_events_enabled = enabled;
    }

    public static ConsistencyLevel getIdealConsistencyLevel() {
        return DatabaseDescriptor.conf.ideal_consistency_level;
    }

    public static void setIdealConsistencyLevel(ConsistencyLevel cl) {
        DatabaseDescriptor.conf.ideal_consistency_level = cl;
    }

    public static int getRepairCommandPoolSize() {
        return DatabaseDescriptor.conf.repair_command_pool_size;
    }

    public static Config.RepairCommandPoolFullStrategy getRepairCommandPoolFullStrategy() {
        return DatabaseDescriptor.conf.repair_command_pool_full_strategy;
    }

    public static FullQueryLoggerOptions getFullQueryLogOptions() {
        return DatabaseDescriptor.conf.full_query_logging_options;
    }

    public static void setFullQueryLogOptions(FullQueryLoggerOptions options) {
        DatabaseDescriptor.conf.full_query_logging_options = options;
    }

    public static boolean getBlockForPeersInRemoteDatacenters() {
        return DatabaseDescriptor.conf.block_for_peers_in_remote_dcs;
    }

    public static int getBlockForPeersTimeoutInSeconds() {
        return DatabaseDescriptor.conf.block_for_peers_timeout_in_secs;
    }

    public static boolean automaticSSTableUpgrade() {
        return DatabaseDescriptor.conf.automatic_sstable_upgrade;
    }

    public static void setAutomaticSSTableUpgradeEnabled(boolean enabled) {
        if (DatabaseDescriptor.conf.automatic_sstable_upgrade != enabled) {
            logger.debug("Changing automatic_sstable_upgrade to {}", (Object)enabled);
        }
        DatabaseDescriptor.conf.automatic_sstable_upgrade = enabled;
    }

    public static int maxConcurrentAutoUpgradeTasks() {
        return DatabaseDescriptor.conf.max_concurrent_automatic_sstable_upgrades;
    }

    public static void setMaxConcurrentAutoUpgradeTasks(int value) {
        if (DatabaseDescriptor.conf.max_concurrent_automatic_sstable_upgrades != value) {
            logger.debug("Changing max_concurrent_automatic_sstable_upgrades to {}", (Object)value);
        }
        DatabaseDescriptor.validateMaxConcurrentAutoUpgradeTasksConf(value);
        DatabaseDescriptor.conf.max_concurrent_automatic_sstable_upgrades = value;
    }

    private static void validateMaxConcurrentAutoUpgradeTasksConf(int value) {
        if (value < 0) {
            throw new ConfigurationException("max_concurrent_automatic_sstable_upgrades can't be negative");
        }
        if (value > DatabaseDescriptor.getConcurrentCompactors()) {
            logger.warn("max_concurrent_automatic_sstable_upgrades ({}) is larger than concurrent_compactors ({})", (Object)value, (Object)DatabaseDescriptor.getConcurrentCompactors());
        }
    }

    public static AuditLogOptions getAuditLoggingOptions() {
        return DatabaseDescriptor.conf.audit_logging_options;
    }

    public static void setAuditLoggingOptions(AuditLogOptions auditLoggingOptions) {
        DatabaseDescriptor.conf.audit_logging_options = auditLoggingOptions;
    }

    public static Config.CorruptedTombstoneStrategy getCorruptedTombstoneStrategy() {
        return DatabaseDescriptor.conf.corrupted_tombstone_strategy;
    }

    public static void setCorruptedTombstoneStrategy(Config.CorruptedTombstoneStrategy strategy) {
        DatabaseDescriptor.conf.corrupted_tombstone_strategy = strategy;
    }

    public static boolean getRepairedDataTrackingForRangeReadsEnabled() {
        return DatabaseDescriptor.conf.repaired_data_tracking_for_range_reads_enabled;
    }

    public static void setRepairedDataTrackingForRangeReadsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.repaired_data_tracking_for_range_reads_enabled = enabled;
    }

    public static boolean getRepairedDataTrackingForPartitionReadsEnabled() {
        return DatabaseDescriptor.conf.repaired_data_tracking_for_partition_reads_enabled;
    }

    public static void setRepairedDataTrackingForPartitionReadsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.repaired_data_tracking_for_partition_reads_enabled = enabled;
    }

    public static boolean snapshotOnRepairedDataMismatch() {
        return DatabaseDescriptor.conf.snapshot_on_repaired_data_mismatch;
    }

    public static void setSnapshotOnRepairedDataMismatch(boolean enabled) {
        DatabaseDescriptor.conf.snapshot_on_repaired_data_mismatch = enabled;
    }

    public static boolean snapshotOnDuplicateRowDetection() {
        return DatabaseDescriptor.conf.snapshot_on_duplicate_row_detection;
    }

    public static void setSnapshotOnDuplicateRowDetection(boolean enabled) {
        DatabaseDescriptor.conf.snapshot_on_duplicate_row_detection = enabled;
    }

    public static boolean reportUnconfirmedRepairedDataMismatches() {
        return DatabaseDescriptor.conf.report_unconfirmed_repaired_data_mismatches;
    }

    public static void reportUnconfirmedRepairedDataMismatches(boolean enabled) {
        DatabaseDescriptor.conf.report_unconfirmed_repaired_data_mismatches = enabled;
    }

    public static boolean strictRuntimeChecks() {
        return strictRuntimeChecks;
    }

    public static boolean useOffheapMerkleTrees() {
        return DatabaseDescriptor.conf.use_offheap_merkle_trees;
    }

    public static void useOffheapMerkleTrees(boolean value) {
        logger.info("Setting use_offheap_merkle_trees to {}", (Object)value);
        DatabaseDescriptor.conf.use_offheap_merkle_trees = value;
    }

    public static Function<CommitLog, AbstractCommitLogSegmentManager> getCommitLogSegmentMgrProvider() {
        return commitLogSegmentMgrProvider;
    }

    public static void setCommitLogSegmentMgrProvider(Function<CommitLog, AbstractCommitLogSegmentManager> provider) {
        commitLogSegmentMgrProvider = provider;
    }

    private static void checkValidForByteConversion(int val, String name, ByteUnit unit) {
        if (val < 0 || unit.willOverflowInBytes(val)) {
            throw new ConfigurationException(String.format("%s must be positive value < %d, but was %d", name, unit.overflowThreshold(), val), false);
        }
    }

    public static int getValidationPreviewPurgeHeadStartInSec() {
        int seconds = DatabaseDescriptor.conf.validation_preview_purge_head_start_in_sec;
        return Math.max(seconds, 0);
    }

    public static boolean checkForDuplicateRowsDuringReads() {
        return DatabaseDescriptor.conf.check_for_duplicate_rows_during_reads;
    }

    public static void setCheckForDuplicateRowsDuringReads(boolean enabled) {
        DatabaseDescriptor.conf.check_for_duplicate_rows_during_reads = enabled;
    }

    public static boolean checkForDuplicateRowsDuringCompaction() {
        return DatabaseDescriptor.conf.check_for_duplicate_rows_during_compaction;
    }

    public static void setCheckForDuplicateRowsDuringCompaction(boolean enabled) {
        DatabaseDescriptor.conf.check_for_duplicate_rows_during_compaction = enabled;
    }

    public static int getRepairPendingCompactionRejectThreshold() {
        return DatabaseDescriptor.conf.reject_repair_compaction_threshold;
    }

    public static void setRepairPendingCompactionRejectThreshold(int value) {
        DatabaseDescriptor.conf.reject_repair_compaction_threshold = value;
    }

    public static int getInitialRangeTombstoneListAllocationSize() {
        return DatabaseDescriptor.conf.initial_range_tombstone_list_allocation_size;
    }

    public static void setInitialRangeTombstoneListAllocationSize(int size) {
        DatabaseDescriptor.conf.initial_range_tombstone_list_allocation_size = size;
    }

    public static double getRangeTombstoneListGrowthFactor() {
        return DatabaseDescriptor.conf.range_tombstone_list_growth_factor;
    }

    public static void setRangeTombstoneListGrowthFactor(double resizeFactor) {
        DatabaseDescriptor.conf.range_tombstone_list_growth_factor = resizeFactor;
    }

    public static boolean getAutocompactionOnStartupEnabled() {
        return DatabaseDescriptor.conf.autocompaction_on_startup_enabled;
    }

    public static boolean autoOptimiseIncRepairStreams() {
        return DatabaseDescriptor.conf.auto_optimise_inc_repair_streams;
    }

    public static void setAutoOptimiseIncRepairStreams(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.auto_optimise_inc_repair_streams) {
            logger.info("Changing auto_optimise_inc_repair_streams from {} to {}", (Object)DatabaseDescriptor.conf.auto_optimise_inc_repair_streams, (Object)enabled);
        }
        DatabaseDescriptor.conf.auto_optimise_inc_repair_streams = enabled;
    }

    public static boolean autoOptimiseFullRepairStreams() {
        return DatabaseDescriptor.conf.auto_optimise_full_repair_streams;
    }

    public static void setAutoOptimiseFullRepairStreams(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.auto_optimise_full_repair_streams) {
            logger.info("Changing auto_optimise_full_repair_streams from {} to {}", (Object)DatabaseDescriptor.conf.auto_optimise_full_repair_streams, (Object)enabled);
        }
        DatabaseDescriptor.conf.auto_optimise_full_repair_streams = enabled;
    }

    public static boolean autoOptimisePreviewRepairStreams() {
        return DatabaseDescriptor.conf.auto_optimise_preview_repair_streams;
    }

    public static void setAutoOptimisePreviewRepairStreams(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.auto_optimise_preview_repair_streams) {
            logger.info("Changing auto_optimise_preview_repair_streams from {} to {}", (Object)DatabaseDescriptor.conf.auto_optimise_preview_repair_streams, (Object)enabled);
        }
        DatabaseDescriptor.conf.auto_optimise_preview_repair_streams = enabled;
    }

    public static int tableCountWarnThreshold() {
        return DatabaseDescriptor.conf.table_count_warn_threshold;
    }

    public static void setTableCountWarnThreshold(int value) {
        DatabaseDescriptor.conf.table_count_warn_threshold = value;
    }

    public static int keyspaceCountWarnThreshold() {
        return DatabaseDescriptor.conf.keyspace_count_warn_threshold;
    }

    public static void setKeyspaceCountWarnThreshold(int value) {
        DatabaseDescriptor.conf.keyspace_count_warn_threshold = value;
    }

    public static int getConsecutiveMessageErrorsThreshold() {
        return DatabaseDescriptor.conf.consecutive_message_errors_threshold;
    }

    public static void setConsecutiveMessageErrorsThreshold(int value) {
        DatabaseDescriptor.conf.consecutive_message_errors_threshold = value;
    }

    public static boolean getLogOutOfTokenRangeRequests() {
        return DatabaseDescriptor.conf.log_out_of_token_range_requests;
    }

    public static void setLogOutOfTokenRangeRequests(boolean enabled) {
        DatabaseDescriptor.conf.log_out_of_token_range_requests = enabled;
    }

    public static boolean getRejectOutOfTokenRangeRequests() {
        return DatabaseDescriptor.conf.reject_out_of_token_range_requests;
    }

    public static void setRejectOutOfTokenRangeRequests(boolean enabled) {
        DatabaseDescriptor.conf.reject_out_of_token_range_requests = enabled;
    }

    public static boolean getForceNewPreparedStatementBehaviour() {
        return DatabaseDescriptor.conf.force_new_prepared_statement_behaviour;
    }

    public static void setForceNewPreparedStatementBehaviour(boolean value) {
        if (value != DatabaseDescriptor.conf.force_new_prepared_statement_behaviour) {
            logger.info("Setting force_new_prepared_statement_behaviour to {}", (Object)value);
            DatabaseDescriptor.conf.force_new_prepared_statement_behaviour = value;
        }
    }

    static {
        FBUtilities.preventIllegalAccessWarnings();
        System.setProperty("io.netty.transport.estimateSizeOnSubmit", "false");
        logger = LoggerFactory.getLogger(DatabaseDescriptor.class);
        internodeAuthenticator = new AllowAllInternodeAuthenticator();
        searchConcurrencyFactor = Integer.parseInt(System.getProperty("cassandra.search_concurrency_factor", "1"));
        disableSTCSInL0 = Boolean.getBoolean("cassandra.disable_stcs_in_l0");
        unsafeSystem = Boolean.getBoolean("cassandra.unsafesystem");
        strictRuntimeChecks = Boolean.getBoolean("cassandra.strict.runtime.checks");
        allowUnlimitedConcurrentValidations = Boolean.getBoolean("cassandra.allow_unlimited_concurrent_validations");
        commitLogSegmentMgrProvider = c -> DatabaseDescriptor.isCDCEnabled() ? new CommitLogSegmentManagerCDC((CommitLog)c, DatabaseDescriptor.getCommitLogLocation()) : new CommitLogSegmentManagerStandard((CommitLog)c, DatabaseDescriptor.getCommitLogLocation());
    }

    private static enum ByteUnit {
        KIBI_BYTES(0x200000, 1024),
        MEBI_BYTES(2048, 0x100000);

        private final int overflowThreshold;
        private final int multiplier;

        private ByteUnit(int t, int m3) {
            this.overflowThreshold = t;
            this.multiplier = m3;
        }

        public int overflowThreshold() {
            return this.overflowThreshold;
        }

        public boolean willOverflowInBytes(int val) {
            return val >= this.overflowThreshold;
        }

        public long toBytes(int val) {
            return val * this.multiplier;
        }
    }
}

