/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableDirectoryListing
extends AbstractCloseable
implements DirectoryListing {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDirectoryListing.class);
    private static final String HIGHEST_CREATED_CYCLE = "listing.highestCycle";
    private static final String LOWEST_CREATED_CYCLE = "listing.lowestCycle";
    private static final String MOD_COUNT = "listing.modCount";
    private static final int UNSET_MAX_CYCLE = Integer.MIN_VALUE;
    private static final int UNSET_MIN_CYCLE = Integer.MAX_VALUE;
    private final TableStore<?> tableStore;
    private final Path queuePath;
    private final ToIntFunction<File> fileToCycleFunction;
    private final boolean readOnly;
    private volatile LongValue maxCycleValue;
    private volatile LongValue minCycleValue;
    private volatile LongValue modCount;

    TableDirectoryListing(@NotNull TableStore<?> tableStore, Path queuePath, ToIntFunction<File> fileToCycleFunction, boolean readOnly) {
        this.tableStore = tableStore;
        this.queuePath = queuePath;
        this.fileToCycleFunction = fileToCycleFunction;
        this.readOnly = readOnly;
    }

    @Override
    public void init() {
        this.throwExceptionIfClosedInSetter();
        this.tableStore.doWithExclusiveLock(ts -> {
            this.maxCycleValue = ts.acquireValueFor(HIGHEST_CREATED_CYCLE);
            this.minCycleValue = ts.acquireValueFor(LOWEST_CREATED_CYCLE);
            this.minCycleValue.compareAndSwapValue(Long.MIN_VALUE, Integer.MAX_VALUE);
            this.modCount = ts.acquireValueFor(MOD_COUNT);
            if (this.modCount.getVolatileValue() == Long.MIN_VALUE) {
                this.modCount.compareAndSwapValue(Long.MIN_VALUE, 0L);
            }
            return this;
        });
    }

    @Override
    public void refresh(boolean force) {
        if (this.readOnly || !force) {
            return;
        }
        this.throwExceptionIfClosed();
        while (true) {
            this.throwExceptionIfClosed();
            this.tableStore.throwExceptionIfClosed();
            Jvm.safepoint();
            long currentMax = this.maxCycleValue.getVolatileValue();
            Jvm.safepoint();
            File[] queueFiles = this.queuePath.toFile().listFiles((d, f) -> f.endsWith(".cq4"));
            int min2 = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            if (queueFiles != null) {
                for (File queueFile : queueFiles) {
                    int cycle = this.fileToCycleFunction.applyAsInt(queueFile);
                    min2 = Math.min(cycle, min2);
                    max = Math.max(cycle, max);
                }
            }
            this.minCycleValue.setOrderedValue(min2);
            if (this.maxCycleValue.compareAndSwapValue(currentMax, max)) break;
            Jvm.nanoPause();
        }
    }

    @Override
    public void onFileCreated(File file, int cycle) {
        if (this.readOnly) {
            LOGGER.warn("DirectoryListing is read-only, not updating listing");
            return;
        }
        this.modCount.addAtomicValue(1L);
        if (cycle > this.getMaxCreatedCycle()) {
            this.maxCycleValue.setMaxValue(cycle);
        }
        if (cycle < this.getMinCycleValue()) {
            this.minCycleValue.setMinValue(cycle);
        }
    }

    @Override
    public int getMaxCreatedCycle() {
        return this.getMaxCycleValue();
    }

    @Override
    public int getMinCreatedCycle() {
        return this.getMinCycleValue();
    }

    @Override
    public long modCount() {
        return this.modCount.getVolatileValue();
    }

    @Override
    public String toString() {
        return this.tableStore.dump();
    }

    @Override
    protected void performClose() {
        Closeable.closeQuietly(this.minCycleValue, this.maxCycleValue, this.modCount);
    }

    private int getMaxCycleValue() {
        return (int)this.maxCycleValue.getVolatileValue();
    }

    private int getMinCycleValue() {
        return (int)this.minCycleValue.getVolatileValue();
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

