/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics3.reporter.config;

import com.addthis.metrics3.reporter.config.ZabbixReporter;
import com.addthis.metrics3.reporter.config.prometheus.MetricRegistryDecorator;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporter
extends ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(ZabbixReporter.class);
    private final PushGateway pushGateway;
    private final String address;
    private final String job;
    private final CollectorRegistry registry = new CollectorRegistry();

    public PrometheusReporter(String address, String job, Map<String, String> labels, MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.pushGateway = new PushGateway(address);
        this.address = address;
        this.job = job;
        this.registry.register((Collector)new MetricRegistryDecorator(registry, job, labels));
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            this.pushGateway.push(this.registry, this.job, new HashMap());
        }
        catch (IOException ex) {
            logger.error("failed to report prometheus metrics to {}", (Object)this.address, (Object)ex);
        }
    }
}

