/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.bridge.CassandraSchema;
import org.apache.cassandra.bridge.CassandraTypesImplementation;
import org.apache.cassandra.bridge.SchemaUpdater;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.cql3.statements.schema.CreateTypeStatement;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.complex.CqlFrozen;
import org.apache.cassandra.spark.data.complex.CqlUdt;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.utils.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaBuilder.class);
    private final TableMetadata metadata;
    private final KeyspaceMetadata keyspaceMetadata;
    private final String createStmt;
    private final String keyspace;
    private final ReplicationFactor replicationFactor;
    private final CassandraTypes cassandraTypes;
    private final int indexCount;

    public SchemaBuilder(CqlTable table, Partitioner partitioner, boolean enableCdc) {
        this(table, partitioner, null, enableCdc);
    }

    public SchemaBuilder(CqlTable table, Partitioner partitioner) {
        this(table, partitioner, null, false);
    }

    public SchemaBuilder(CqlTable table, Partitioner partitioner, UUID tableId, boolean enableCdc) {
        this(table.createStatement(), table.keyspace(), table.replicationFactor(), partitioner, arg_0 -> ((CqlTable)table).udtCreateStmts(arg_0), tableId, 0, enableCdc);
    }

    @VisibleForTesting
    public SchemaBuilder(String createStmt, String keyspace, ReplicationFactor replicationFactor) {
        this(createStmt, keyspace, replicationFactor, Partitioner.Murmur3Partitioner, bridge -> Collections.emptySet(), null, 0, false);
    }

    @VisibleForTesting
    public SchemaBuilder(String createStmt, String keyspace, ReplicationFactor replicationFactor, Partitioner partitioner) {
        this(createStmt, keyspace, replicationFactor, partitioner, bridge -> Collections.emptySet(), null, 0, false);
    }

    public SchemaBuilder(String createStmt, String keyspace, ReplicationFactor replicationFactor, Partitioner partitioner, Function<CassandraTypes, Set<String>> udtStatementsProvider, @Nullable UUID tableId, int indexCount, boolean enableCdc) {
        this.createStmt = createStmt;
        this.keyspace = keyspace;
        this.replicationFactor = replicationFactor;
        this.cassandraTypes = new CassandraTypesImplementation();
        this.indexCount = indexCount;
        Pair updated = CassandraSchema.apply(schema -> SchemaBuilder.updateSchema(schema, this.keyspace, (Set)udtStatementsProvider.apply(this.cassandraTypes), this.createStmt, partitioner, this.replicationFactor, tableId, enableCdc, this::validateColumnMetaData));
        this.keyspaceMetadata = (KeyspaceMetadata)updated.left;
        this.metadata = (TableMetadata)updated.right;
    }

    private static Pair<KeyspaceMetadata, TableMetadata> updateSchema(Schema schema, String keyspace, Set<String> udtStatements, String createStatement, Partitioner partitioner, ReplicationFactor replicationFactor, UUID tableId, boolean enableCdc, Consumer<ColumnMetadata> columnValidator) {
        IPartitioner cassPartitioner = CassandraTypesImplementation.getPartitioner(partitioner);
        SchemaBuilder.setupKeyspace(schema, keyspace, replicationFactor, cassPartitioner);
        ArrayList<CreateTypeStatement.Raw> typeStatements = new ArrayList<CreateTypeStatement.Raw>(udtStatements.size());
        for (String string : udtStatements) {
            try {
                typeStatements.add((CreateTypeStatement.Raw)CQLFragmentParser.parseAnyUnhandled(CqlParser::query, (String)string));
            }
            catch (RecognitionException exception) {
                LOGGER.error("Failed to parse type expression '{}'", (Object)string);
                throw new IllegalStateException(exception);
            }
        }
        Types.RawBuilder typesBuilder = Types.rawBuilder((String)keyspace);
        for (CreateTypeStatement.Raw st : typeStatements) {
            st.addToRawBuilder(typesBuilder);
        }
        Types types = typesBuilder.build();
        CreateTableStatement.Raw createTable = (CreateTableStatement.Raw)CQLFragmentParser.parseAny(CqlParser::createTableStatement, (String)createStatement, (String)"CREATE TABLE");
        TableMetadata maybeExistingTableMetadata = schema.getTableMetadata(keyspace, createTable.table());
        if (maybeExistingTableMetadata != null && tableId == null) {
            tableId = maybeExistingTableMetadata.id.asUUID();
        }
        TableMetadata.Builder builder = createTable.keyspace(keyspace).prepare(null).builder(types).partitioner(cassPartitioner);
        if (tableId != null) {
            builder.id(TableId.fromUUID((UUID)tableId));
        }
        TableMetadata tableMetadata = builder.build();
        if (tableMetadata.params.cdc != enableCdc) {
            tableMetadata = tableMetadata.unbuild().params(tableMetadata.params.unbuild().cdc(enableCdc).build()).build();
        }
        tableMetadata.columns().forEach(columnValidator);
        SchemaBuilder.setupTableAndUdt(schema, keyspace, tableMetadata, types);
        return SchemaBuilder.validateKeyspaceTable(schema, keyspace, tableMetadata.name);
    }

    private void validateColumnMetaData(@NotNull ColumnMetadata column) {
        this.validateType(column.type);
    }

    private void validateType(AbstractType<?> type) {
        this.validateType(type.asCQL3Type());
    }

    private void validateType(CQL3Type cqlType) {
        if (!(cqlType instanceof CQL3Type.Native || cqlType instanceof CQL3Type.Collection || cqlType instanceof CQL3Type.UserDefined || cqlType instanceof CQL3Type.Tuple)) {
            throw new UnsupportedOperationException("Only native, collection, tuples or UDT data types are supported, unsupported data type: " + cqlType.toString());
        }
        if (cqlType instanceof CQL3Type.Native) {
            CqlField.CqlType type = this.cassandraTypes.parseType(cqlType.toString());
            if (!type.isSupported()) {
                throw new UnsupportedOperationException(type.name() + " data type is not supported");
            }
        } else if (cqlType instanceof CQL3Type.Collection) {
            CQL3Type.Collection collection = (CQL3Type.Collection)cqlType;
            CollectionType type = (CollectionType)collection.getType();
            switch (type.kind) {
                case LIST: {
                    this.validateType(((ListType)type).getElementsType());
                    return;
                }
                case SET: {
                    this.validateType(((SetType)type).getElementsType());
                    return;
                }
                case MAP: {
                    this.validateType(((MapType)type).getKeysType());
                    this.validateType(((MapType)type).getValuesType());
                    return;
                }
            }
        } else if (cqlType instanceof CQL3Type.Tuple) {
            CQL3Type.Tuple tuple = (CQL3Type.Tuple)cqlType;
            TupleType tupleType = (TupleType)tuple.getType();
            for (AbstractType subType : tupleType.allTypes()) {
                this.validateType(subType);
            }
        } else {
            UserType userType = (UserType)((CQL3Type.UserDefined)cqlType).getType();
            for (AbstractType innerType : userType.fieldTypes()) {
                this.validateType(innerType);
            }
        }
    }

    private static boolean keyspaceMetadataExists(Schema schema, String keyspaceName) {
        return schema.getKeyspaceMetadata(keyspaceName) != null;
    }

    private static boolean tableMetadataExists(Schema schema, String keyspaceName, String tableName) {
        KeyspaceMetadata ksMetadata = schema.getKeyspaceMetadata(keyspaceName);
        if (ksMetadata == null) {
            return false;
        }
        return ksMetadata.hasTable(tableName);
    }

    private static boolean keyspaceInstanceExists(Schema schema, String keyspaceName) {
        return schema.getKeyspaceInstance(keyspaceName) != null;
    }

    private static boolean tableInstanceExists(Schema schema, String keyspaceName, String tableName) {
        Keyspace keyspace = schema.getKeyspaceInstance(keyspaceName);
        if (keyspace == null) {
            return false;
        }
        try {
            keyspace.getColumnFamilyStore(tableName);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.info("Table instance does not exist. keyspace={} table={} existingCFS={}", new Object[]{keyspace, tableName, keyspace.getColumnFamilyStores()});
            return false;
        }
        return true;
    }

    private static void setupKeyspace(Schema schema, String keyspaceName, ReplicationFactor replicationFactor, IPartitioner partitioner) {
        if (!SchemaBuilder.keyspaceMetadataExists(schema, keyspaceName)) {
            LOGGER.info("Setting up keyspace metadata in schema keyspace={} rfStrategy={} partitioner={}", new Object[]{keyspaceName, replicationFactor.getReplicationStrategy().name(), partitioner});
            KeyspaceMetadata keyspaceMetadata = KeyspaceMetadata.create((String)keyspaceName, (KeyspaceParams)KeyspaceParams.create((boolean)true, SchemaBuilder.rfToMap(replicationFactor)));
            SchemaUpdater.load(schema, keyspaceMetadata);
        }
        if (!SchemaBuilder.keyspaceInstanceExists(schema, keyspaceName)) {
            LOGGER.info("Setting up keyspace instance in schema keyspace={} rfStrategy={} partitioner={}", new Object[]{keyspaceName, replicationFactor.getReplicationStrategy().name(), partitioner});
            Keyspace.openWithoutSSTables((String)keyspaceName);
        }
    }

    private static void setupTableAndUdt(Schema schema, String keyspaceName, TableMetadata tableMetadata, Types userTypes) {
        String tableName = tableMetadata.name;
        KeyspaceMetadata keyspaceMetadata = schema.getKeyspaceMetadata(keyspaceName);
        if (keyspaceMetadata == null) {
            LOGGER.error("Keyspace metadata does not exist. keyspace={}", (Object)keyspaceName);
            throw new IllegalStateException("Keyspace metadata null for '" + keyspaceName + "' when it should have been initialized already");
        }
        if (!SchemaBuilder.tableMetadataExists(schema, keyspaceName, tableName)) {
            LOGGER.info("Setting up table metadata in schema keyspace={} table={} partitioner={}", new Object[]{keyspaceName, tableName, tableMetadata.partitioner.getClass().getName()});
            keyspaceMetadata = keyspaceMetadata.withSwapped(keyspaceMetadata.tables.with(tableMetadata));
            SchemaUpdater.load(schema, keyspaceMetadata, tableMetadata);
        }
        if (!tableMetadata.equals((Object)schema.getTableMetadata(keyspaceName, tableMetadata.name))) {
            SchemaBuilder.updateTableMetaData(schema, keyspaceName, tableMetadata);
            LOGGER.info("Table metadata changed schema keyspace={} table={} partitioner={}", new Object[]{keyspaceName, tableName, tableMetadata.partitioner.getClass().getName()});
        }
        TableMetadata currentTable = schema.getTableMetadata(keyspaceName, tableName);
        if (!SchemaBuilder.tableInstanceExists(schema, keyspaceName, tableName)) {
            LOGGER.info("Setting up table instance in schema keyspace={} table={} partitioner={}", new Object[]{keyspaceName, tableName, tableMetadata.partitioner.getClass().getName()});
            if (SchemaBuilder.keyspaceInstanceExists(schema, keyspaceName)) {
                schema.getKeyspaceInstance(keyspaceName).initCf(TableMetadataRef.forOfflineTools((TableMetadata)currentTable), false);
            } else {
                Keyspace.openWithoutSSTables((String)keyspaceName);
            }
        }
        if (!userTypes.equals((Object)Types.none())) {
            LOGGER.info("Setting up user types in schema keyspace={} types={}", (Object)keyspaceName, (Object)userTypes);
            keyspaceMetadata = keyspaceMetadata.withSwapped(userTypes);
            SchemaUpdater.load(schema, keyspaceMetadata, userTypes);
        }
    }

    private static void updateTableMetaData(Schema schema, String keyspace, TableMetadata tableMetadata) {
        KeyspaceMetadata ks = schema.getKeyspaceMetadata(keyspace);
        ks = ks.withSwapped(ks.tables.withSwapped(tableMetadata));
        SchemaUpdater.load(schema, ks, tableMetadata);
    }

    private static Pair<KeyspaceMetadata, TableMetadata> validateKeyspaceTable(Schema schema, String keyspaceName, String tableName) {
        Preconditions.checkState((boolean)SchemaBuilder.keyspaceMetadataExists(schema, keyspaceName), (String)"Keyspace metadata does not exist after building schema. keyspace=%s", (Object)keyspaceName);
        Preconditions.checkState((boolean)SchemaBuilder.keyspaceInstanceExists(schema, keyspaceName), (String)"Keyspace instance is not opened after building schema. keyspace=%s", (Object)keyspaceName);
        Preconditions.checkState((boolean)SchemaBuilder.tableMetadataExists(schema, keyspaceName, tableName), (String)"Table metadata does not exist after building schema. keyspace=%s table=%s", (Object)keyspaceName, (Object)tableName);
        Preconditions.checkState((boolean)SchemaBuilder.tableInstanceExists(schema, keyspaceName, tableName), (String)"Table instance is not opened after building schema. keyspace=%s table=%s", (Object)keyspaceName, (Object)tableName);
        KeyspaceMetadata keyspaceMetadata = schema.getKeyspaceMetadata(keyspaceName);
        TableMetadata tableMetadata = schema.getTableMetadata(keyspaceName, tableName);
        return Pair.create((Object)keyspaceMetadata, (Object)tableMetadata);
    }

    public TableMetadata tableMetaData() {
        return this.metadata;
    }

    public String createStatement() {
        return this.createStmt;
    }

    public CqlTable build() {
        Map<String, CqlField.CqlUdt> udts = this.buildsUdts(this.keyspaceMetadata);
        List fields = this.buildFields(this.metadata, udts).stream().sorted().collect(Collectors.toList());
        return new CqlTable(this.keyspace, this.metadata.name, this.createStmt, this.replicationFactor, fields, new HashSet<CqlField.CqlUdt>(udts.values()), this.indexCount);
    }

    private Map<String, CqlField.CqlUdt> buildsUdts(KeyspaceMetadata keyspaceMetadata) {
        ArrayList<UserType> userTypes = new ArrayList<UserType>();
        keyspaceMetadata.types.forEach(userTypes::add);
        HashMap<String, CqlField.CqlUdt> udts = new HashMap<String, CqlField.CqlUdt>(userTypes.size());
        while (!userTypes.isEmpty()) {
            UserType userType = (UserType)userTypes.remove(0);
            if (!SchemaBuilder.nestedUdts(userType).stream().allMatch(udts::containsKey)) {
                userTypes.add(userType);
                continue;
            }
            String name = userType.getNameAsString();
            CqlUdt.Builder builder = CqlUdt.builder(keyspaceMetadata.name, name);
            for (int field = 0; field < userType.size(); ++field) {
                builder.withField(userType.fieldName(field).toString(), this.cassandraTypes.parseType(userType.fieldType(field).asCQL3Type().toString(), udts));
            }
            udts.put(name, builder.build());
        }
        return udts;
    }

    private static Set<String> nestedUdts(AbstractType<?> type) {
        HashSet<String> result = new HashSet<String>();
        SchemaBuilder.nestedUdts(type, result, false);
        return result;
    }

    private static void nestedUdts(AbstractType<?> type, Set<String> udts, boolean isNested) {
        if (type instanceof UserType) {
            if (isNested) {
                udts.add(((UserType)type).getNameAsString());
            }
            for (AbstractType nestedType : ((UserType)type).fieldTypes()) {
                SchemaBuilder.nestedUdts(nestedType, udts, true);
            }
        } else if (type instanceof TupleType) {
            for (AbstractType nestedType : ((TupleType)type).allTypes()) {
                SchemaBuilder.nestedUdts(nestedType, udts, true);
            }
        } else if (type instanceof SetType) {
            SchemaBuilder.nestedUdts(((SetType)type).getElementsType(), udts, true);
        } else if (type instanceof ListType) {
            SchemaBuilder.nestedUdts(((ListType)type).getElementsType(), udts, true);
        } else if (type instanceof MapType) {
            SchemaBuilder.nestedUdts(((MapType)type).getKeysType(), udts, true);
            SchemaBuilder.nestedUdts(((MapType)type).getValuesType(), udts, true);
        }
    }

    private List<CqlField> buildFields(TableMetadata metadata, Map<String, CqlField.CqlUdt> udts) {
        Iterator it = metadata.allColumnsInSelectOrder();
        ArrayList<CqlField> result = new ArrayList<CqlField>();
        int position = 0;
        while (it.hasNext()) {
            ColumnMetadata col = (ColumnMetadata)it.next();
            boolean isPartitionKey = col.isPartitionKey();
            boolean isClusteringColumn = col.isClusteringColumn();
            boolean isStatic = col.isStatic();
            String name = col.name.toString();
            CqlField.CqlType type = col.type.isUDT() ? (CqlField.CqlType)udts.get(((UserType)col.type).getNameAsString()) : this.cassandraTypes.parseType(col.type.asCQL3Type().toString(), udts);
            boolean isFrozen = col.type.isFreezable() && !col.type.isMultiCell();
            result.add(new CqlField(isPartitionKey, isClusteringColumn, isStatic, name, (CqlField.CqlType)(!(type instanceof CqlFrozen) && isFrozen ? CqlFrozen.build(type) : type), position));
            ++position;
        }
        return result;
    }

    static Map<String, String> rfToMap(ReplicationFactor replicationFactor) {
        HashMap<String, String> result = new HashMap<String, String>(replicationFactor.getOptions().size() + 1);
        result.put("class", "org.apache.cassandra.locator." + replicationFactor.getReplicationStrategy().name());
        for (Map.Entry entry : replicationFactor.getOptions().entrySet()) {
            result.put((String)entry.getKey(), Integer.toString((Integer)entry.getValue()));
        }
        return result;
    }
}

