/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.testing.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.distributed.api.NodeToolResult;
import org.apache.cassandra.testing.utils.WithProperties;

public final class ClusterUtils {
    private ClusterUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static <I extends IInstance> I start(I instance, Consumer<WithProperties> fn) {
        return (I)ClusterUtils.start(instance, (I ignore, WithProperties prop) -> fn.accept((WithProperties)prop));
    }

    public static <I extends IInstance> I start(I instance, BiConsumer<I, WithProperties> fn) {
        try (WithProperties properties = new WithProperties();){
            fn.accept(instance, properties);
            instance.startup();
            I i = instance;
            return i;
        }
    }

    public static List<RingInstanceDetails> ring(IInstance instance) {
        NodeToolResult results = instance.nodetoolResult(new String[]{"ring"});
        results.asserts().success();
        return ClusterUtils.parseRing(results.getStdout());
    }

    private static List<RingInstanceDetails> parseRing(String str) {
        String[] lines;
        Pattern pattern = Pattern.compile("^(/?[0-9.:]+)\\s+(\\w+|\\?)\\s+(\\w+|\\?)\\s+(\\w+|\\?).*?(-?\\d+)\\s*$");
        ArrayList<RingInstanceDetails> details = new ArrayList<RingInstanceDetails>();
        for (String line : lines = str.split("\n")) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            details.add(new RingInstanceDetails(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5)));
        }
        return details;
    }

    public static final class RingInstanceDetails {
        private final String address;
        private final String rack;
        private final String status;
        private final String state;
        private final String token;

        private RingInstanceDetails(String address, String rack, String status, String state, String token) {
            this.address = address;
            this.rack = rack;
            this.status = status;
            this.state = state;
            this.token = token;
        }

        public String getAddress() {
            return this.address;
        }

        public String getStatus() {
            return this.status;
        }

        public String getState() {
            return this.state;
        }

        public String getToken() {
            return this.token;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RingInstanceDetails that = (RingInstanceDetails)o;
            return Objects.equals(this.address, that.address) && Objects.equals(this.rack, that.rack) && Objects.equals(this.status, that.status) && Objects.equals(this.state, that.state) && Objects.equals(this.token, that.token);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.rack, this.status, this.state, this.token);
        }

        public String toString() {
            return Arrays.asList(this.address, this.rack, this.status, this.state, this.token).toString();
        }
    }
}

