/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.testing;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.testing.utils.tls.CertificateBuilder;
import org.apache.cassandra.testing.utils.tls.CertificateBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtlsTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MtlsTestHelper.class);
    public static final char[] EMPTY_PASSWORD = new char[0];
    public static final String EMPTY_PASSWORD_STRING = "";
    public static final String CASSANDRA_INTEGRATION_TEST_ENABLE_MTLS = "cassandra.integration.sidecar.test.enable_mtls";
    private final boolean enableMtlsForTesting;
    CertificateBundle certificateAuthority;
    Path truststorePath;
    Path serverKeyStorePath;
    Path clientKeyStorePath;

    public MtlsTestHelper(Path secretsPath) throws Exception {
        this(secretsPath, System.getProperty(CASSANDRA_INTEGRATION_TEST_ENABLE_MTLS, "false").equals("true"));
    }

    public MtlsTestHelper(Path secretsPath, boolean enableMtlsForTesting) throws Exception {
        this.enableMtlsForTesting = enableMtlsForTesting;
        this.maybeInitializeSecrets(Objects.requireNonNull(secretsPath, "secretsPath cannot be null"));
    }

    void maybeInitializeSecrets(Path secretsPath) throws Exception {
        if (!this.enableMtlsForTesting) {
            return;
        }
        this.certificateAuthority = new CertificateBuilder().subject("CN=Apache Cassandra Root CA, OU=Certification Authority, O=Unknown, C=Unknown").alias("fakerootca").isCertificateAuthority(true).buildSelfSigned();
        this.truststorePath = this.certificateAuthority.toTempKeyStorePath(secretsPath, EMPTY_PASSWORD, EMPTY_PASSWORD);
        CertificateBuilder serverKeyStoreBuilder = new CertificateBuilder().subject("CN=Apache Cassandra, OU=mtls_test, O=Unknown, L=Unknown, ST=Unknown, C=Unknown").addSanDnsName("localhost");
        for (int i = 1; i <= 20; ++i) {
            serverKeyStoreBuilder.addSanDnsName("localhost" + i);
        }
        CertificateBundle serverKeyStore = serverKeyStoreBuilder.buildIssuedBy(this.certificateAuthority);
        this.serverKeyStorePath = serverKeyStore.toTempKeyStorePath(secretsPath, EMPTY_PASSWORD, EMPTY_PASSWORD);
        CertificateBundle clientKeyStore = new CertificateBuilder().subject("CN=Apache Cassandra, OU=mtls_test, O=Unknown, L=Unknown, ST=Unknown, C=Unknown").addSanDnsName("localhost").buildIssuedBy(this.certificateAuthority);
        this.clientKeyStorePath = clientKeyStore.toTempKeyStorePath(secretsPath, EMPTY_PASSWORD, EMPTY_PASSWORD);
    }

    public boolean isEnabled() {
        return this.enableMtlsForTesting;
    }

    public String trustStorePath() {
        return this.truststorePath.toString();
    }

    public String trustStorePassword() {
        return EMPTY_PASSWORD_STRING;
    }

    public String trustStoreType() {
        return "PKCS12";
    }

    public String serverKeyStorePath() {
        return this.serverKeyStorePath.toString();
    }

    public String serverKeyStorePassword() {
        return EMPTY_PASSWORD_STRING;
    }

    public String serverKeyStoreType() {
        return "PKCS12";
    }

    public Map<String, String> mtlOptionMap() {
        if (!this.isEnabled()) {
            return Collections.emptyMap();
        }
        LOGGER.info("Test mTLS certificate is enabled. Will use test keystore as truststore so the client will trust the server");
        HashMap<String, String> optionMap = new HashMap<String, String>();
        optionMap.put("truststore_path", this.trustStorePath());
        optionMap.put("truststore_password", EMPTY_PASSWORD_STRING);
        optionMap.put("truststore_type", this.trustStoreType());
        optionMap.put("keystore_path", this.clientKeyStorePath.toString());
        optionMap.put("keystore_password", EMPTY_PASSWORD_STRING);
        optionMap.put("keystore_type", "PKCS12");
        return optionMap;
    }
}

