/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.SidecarInstance;

public class HttpResponseImpl
implements HttpResponse {
    private final int statusCode;
    private final String statusMessage;
    private final byte[] raw;
    private final Map<String, List<String>> headers;
    private final SidecarInstance sidecarInstance;

    public HttpResponseImpl(int statusCode, String statusMessage, Map<String, List<String>> headers, SidecarInstance server) {
        this(statusCode, statusMessage, null, headers, server);
    }

    public HttpResponseImpl(int statusCode, String statusMessage, byte[] raw, Map<String, List<String>> headers, SidecarInstance server) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.raw = raw;
        this.headers = Collections.unmodifiableMap(headers);
        this.sidecarInstance = server;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public byte[] raw() {
        return this.raw;
    }

    @Override
    public String contentAsString(String charset) {
        if (this.raw == null) {
            return null;
        }
        try {
            return new String(this.raw, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to decode for charset " + charset, unsupportedEncodingException);
        }
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public SidecarInstance sidecarInstance() {
        return this.sidecarInstance;
    }

    public String toString() {
        return "HttpResponseImpl{statusCode=" + this.statusCode + ", statusMessage='" + this.statusMessage + "', contentAsString='" + this.contentAsString() + "', headers=" + String.valueOf(this.headers) + "}";
    }
}

