/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.net.impl;

import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelHandlerContext;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import o.a.c.sidecar.client.shaded.io.netty.handler.ssl.SniCompletionEvent;
import o.a.c.sidecar.client.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import o.a.c.sidecar.client.shaded.io.netty.util.Attribute;
import o.a.c.sidecar.client.shaded.io.netty.util.AttributeKey;
import o.a.c.sidecar.client.shaded.io.netty.util.concurrent.Promise;

public class SslHandshakeCompletionHandler
extends ChannelInboundHandlerAdapter {
    static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf("sniServerName");
    private final Promise<Void> promise;

    public SslHandshakeCompletionHandler(Promise<Void> promise) {
        this.promise = promise;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof SniCompletionEvent) {
            SniCompletionEvent completion = (SniCompletionEvent)evt;
            if (completion.isSuccess()) {
                Attribute<String> val = ctx.channel().attr(SERVER_NAME_ATTR);
                val.set(completion.hostname());
            } else {
                this.promise.tryFailure(completion.cause());
            }
        } else if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent completion = (SslHandshakeCompletionEvent)evt;
            if (completion.isSuccess()) {
                ctx.pipeline().remove(this);
                this.promise.setSuccess(null);
            } else {
                this.promise.tryFailure(completion.cause());
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }
}

