/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.avro.AvroByteRecordTransformer;
import org.apache.cassandra.cdc.avro.AvroDataUtils;
import org.apache.cassandra.cdc.avro.msg.CdcEnvelope;
import org.apache.cassandra.cdc.kafka.KafkaCdcSerializer;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.schemastore.LocalTableSchemaStore;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.kafka.common.header.Headers;

public class AvroSerializer
implements KafkaCdcSerializer<CdcEvent> {
    private final GenericDatumWriter<GenericRecord> cdcWriter;
    private final BinaryEncoder encoderReuse;
    private final AvroByteRecordTransformer recordTransformer;
    private final Deserializer deserializer;

    public AvroSerializer(Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup) {
        this(LocalTableSchemaStore.getInstance(), typeLookup);
    }

    public AvroSerializer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup) {
        this(schemaStore, typeLookup, 838860);
    }

    public AvroSerializer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, int truncateThreshold) {
        this.recordTransformer = new AvroByteRecordTransformer(schemaStore, typeLookup, truncateThreshold);
        this.cdcWriter = new GenericDatumWriter(this.recordTransformer.cdcSchema);
        this.encoderReuse = EncoderFactory.get().binaryEncoder((OutputStream)new ByteArrayOutputStream(0), null);
        this.deserializer = new Deserializer(this.recordTransformer.cdcSchema, schemaStore);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, CdcEvent event) {
        GenericData.Record record = this.recordTransformer.transform(event);
        return this.encode(this.cdcWriter, record);
    }

    public byte[] serialize(String topic, Headers headers, CdcEvent data) {
        return this.serialize(topic, data);
    }

    public void close() {
    }

    private byte[] encode(GenericDatumWriter<GenericRecord> writer, GenericData.Record update) {
        return AvroDataUtils.encode(writer, update, this.encoderReuse);
    }

    public Deserializer deserializer() {
        return this.deserializer;
    }

    @Override
    public AvroByteRecordTransformer getTransformer() {
        return this.recordTransformer;
    }

    @Deprecated
    public CdcEnvelope deserialize(String keyspace, String table, byte[] data) {
        return this.deserializer.deserialize(keyspace, table, data);
    }

    public static class Deserializer {
        private final SchemaStore store;
        private final GenericDatumReader<GenericRecord> cdcReader;
        private final BinaryDecoder decoderReuse;

        public Deserializer(Schema cdcSchema, SchemaStore store) {
            this.store = store;
            this.cdcReader = new GenericDatumReader(cdcSchema);
            this.decoderReuse = DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(ByteBufferUtils.EMPTY), null);
        }

        public CdcEnvelope deserialize(String keyspace, String table, byte[] data) {
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, this.decoderReuse);
            try {
                GenericRecord header = (GenericRecord)this.cdcReader.read(null, (Decoder)decoder);
                GenericRecord payload = this.deserializePayload(keyspace, table, header.get("schemaUuid").toString(), Deserializer.getPayload(header));
                return new CdcEnvelope(header, payload);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to deserialize CDC update from %s/%s", keyspace, table), e);
            }
        }

        public static byte[] getPayload(GenericRecord header) {
            ByteBuffer buf = (ByteBuffer)header.get("payload");
            byte[] ar = new byte[buf.remaining()];
            buf.get(ar);
            return ar;
        }

        Object deserializeRangePredicateValue(String keyspace, String table, String fieldName, ByteBuffer value) {
            GenericDatumReader<GenericRecord> reader = this.store.getReader(keyspace + "." + table, null);
            byte[] bytes = new byte[value.remaining()];
            try {
                value.get(bytes);
                BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, this.decoderReuse);
                GenericRecord valueRecord = (GenericRecord)reader.read(null, (Decoder)decoder);
                return valueRecord.get(fieldName);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to deserialize CDC update from %s/%s", keyspace, table), e);
            }
        }

        public GenericRecord deserializePayload(String keyspace, String table, String schemaUuid, byte[] data) throws IOException {
            GenericDatumReader<GenericRecord> payloadReader = this.store.getReader(keyspace + "." + table, schemaUuid);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, this.decoderReuse);
            return (GenericRecord)payloadReader.read(null, (Decoder)decoder);
        }
    }
}

