/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types.complex;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.cassandra.spark.data.converter.types.complex.CollectionFeatures;
import org.apache.cassandra.spark.utils.ScalaConversionUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.jetbrains.annotations.NotNull;
import scala.collection.mutable.Seq;

public class SparkList
implements CollectionFeatures {
    private final SparkSqlTypeConverter converter;
    final CqlField.CqlCollection list;

    public SparkList(SparkSqlTypeConverter converter, CqlField.CqlCollection list) {
        this.converter = converter;
        this.list = list;
    }

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.createArrayType((DataType)this.sparkType().dataType(bigNumberConfig));
    }

    @Override
    public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        return ArrayData.toArrayData((Object)((Collection)value).stream().map(element -> this.sparkType().toSparkSqlType(element, isFrozen)).toArray());
    }

    @Override
    public Object sparkSqlRowValue(GenericInternalRow row, int position) {
        return Arrays.stream(row.getArray(position).array()).map(element -> this.sparkType().toTestRowType(element)).collect(this.collector());
    }

    @Override
    public Object sparkSqlRowValue(Row row, int position) {
        return row.getList(position).stream().map(element -> this.sparkType().toTestRowType(element)).collect(this.collector());
    }

    @Override
    public Object toTestRowType(Object value) {
        return ScalaConversionUtils.mutableSeqAsJavaList((Seq)value).stream().map(element -> this.sparkType().toTestRowType(element)).collect(Collectors.toList());
    }

    public <T> Collector<T, ?, ?> collector() {
        return Collectors.toList();
    }

    @Override
    public boolean equalsTo(Object first, Object second) {
        return SparkType.equalsArrays(((GenericArrayData)first).array(), ((GenericArrayData)second).array(), position -> this.sparkType());
    }

    @Override
    public int compareTo(Object first, Object second) {
        return SparkType.compareArrays(((GenericArrayData)first).array(), ((GenericArrayData)second).array(), position -> this.sparkType());
    }

    @Override
    public CqlField.CqlCollection collection() {
        return this.list;
    }

    @Override
    public SparkSqlTypeConverter converter() {
        return this.converter;
    }
}

