/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql.filters;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.cassandra.bridge.TokenRange;
import org.jetbrains.annotations.NotNull;

public final class SparkRangeFilter
implements Serializable {
    @NotNull
    private final TokenRange tokenRange;

    private SparkRangeFilter(@NotNull TokenRange tokenRange) {
        this.tokenRange = tokenRange;
    }

    @NotNull
    public TokenRange tokenRange() {
        return this.tokenRange;
    }

    public boolean overlaps(TokenRange tokenRange) {
        return this.tokenRange.isConnected(tokenRange);
    }

    public boolean overlaps(BigInteger token) {
        return this.tokenRange.contains(token);
    }

    public boolean skipPartition(BigInteger token) {
        return !this.tokenRange.contains(token);
    }

    @NotNull
    public static SparkRangeFilter create(@NotNull TokenRange tokenRange) {
        return new SparkRangeFilter(tokenRange);
    }
}

