/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.utils;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.sidecar.common.exceptions.RangeException;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.jetbrains.annotations.NotNull;

public class HttpRange {
    private static final String RANGE_UNIT = "bytes";
    private static final Pattern RANGE_HEADER = Pattern.compile("^bytes=(\\d*)-(\\d*)$");
    private static final long BOUND_ABSENT = -1L;
    private final long start;
    private final long end;
    private final long length;

    private HttpRange(long start, long end) {
        Preconditions.checkArgument(start >= 0L, () -> String.format("Range start can not be negative. range=[%s, %s]", start, end));
        Preconditions.checkArgument(end >= start, () -> String.format("Range does not satisfy boundary requirements. range=[%s, %s]", start, end));
        this.start = start;
        this.end = end;
        long len = end - start + 1L;
        this.length = len < 0L ? Long.MAX_VALUE : len;
    }

    public static HttpRange parseHeader(String header, long fileSize) {
        if (header == null) {
            return new HttpRange(0L, fileSize - 1L);
        }
        return HttpRange.parse(header, fileSize);
    }

    public static HttpRange of(long start, long end) {
        return new HttpRange(start, end);
    }

    private static HttpRange parse(@NotNull String rangeHeader, long fileSize) {
        Matcher m = RANGE_HEADER.matcher(rangeHeader);
        if (!m.matches()) {
            throw HttpRange.invalidRangeHeaderException(rangeHeader);
        }
        long left = HttpRange.parseLong(m.group(1), rangeHeader);
        long right = HttpRange.parseLong(m.group(2), rangeHeader);
        if (left == -1L && right == -1L) {
            throw HttpRange.invalidRangeHeaderException(rangeHeader);
        }
        if (left == -1L) {
            long len = Math.min(right, fileSize);
            return new HttpRange(fileSize - len, fileSize - 1L);
        }
        if (right == -1L) {
            return new HttpRange(left, fileSize - 1L);
        }
        return new HttpRange(left, right);
    }

    private static long parseLong(String valStr, String rangeHeader) {
        if (valStr == null || valStr.isEmpty()) {
            return -1L;
        }
        try {
            return Long.parseLong(valStr);
        }
        catch (NumberFormatException e) {
            throw HttpRange.invalidRangeHeaderException(rangeHeader);
        }
    }

    private static IllegalArgumentException invalidRangeHeaderException(String rangeHeader) {
        return new IllegalArgumentException("Invalid range header: " + rangeHeader + ". Supported Range formats are bytes=<start>-<end>, bytes=<start>-, bytes=-<suffix-length>");
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long length() {
        return this.length;
    }

    public HttpRange intersect(@NotNull HttpRange range) {
        long newEnd;
        long newStart = Math.max(this.start, range.start());
        if (newStart > (newEnd = Math.min(this.end, range.end()))) {
            throw new RangeException("Range does not overlap");
        }
        return new HttpRange(newStart, newEnd);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRange)) {
            return false;
        }
        HttpRange range = (HttpRange)o;
        return this.start == range.start && this.end == range.end && this.length == range.length;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.length);
    }

    public String toString() {
        return String.format("%s=%d-%d", RANGE_UNIT, this.start, this.end);
    }
}

