/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request;

import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.sidecar.common.request.JsonResponseBytesDecoder;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.request.ResponseBytesDecoder;

public abstract class JsonRequest<T>
extends Request {
    private final JsonResponseBytesDecoder<T> responseDecoder;

    protected JsonRequest(String requestURI) {
        super(requestURI);
        Class type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.responseDecoder = new JsonResponseBytesDecoder(type);
    }

    public ResponseBytesDecoder<T> responseBytesDecoder() {
        return this.responseDecoder;
    }

    @Override
    public Map<String, String> headers() {
        HashMap<String, String> headers = new HashMap<String, String>(super.headers());
        headers.put("content-type", "application/json");
        return Collections.unmodifiableMap(headers);
    }
}

