/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimePartDataSource;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.transform.Source;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.AttachmentDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Attachment {
    private static final Log log = LogFactory.getLog(Attachment.class);
    DataHandler dh = null;
    String cid = null;
    AttachmentDescription aDesc = null;
    Object sigValue = null;
    Class sigClass = null;
    String partName = null;

    public Attachment(DataHandler dh, String cid) {
        if (log.isDebugEnabled()) {
            System.out.println("Construct with dh=" + dh.getContentType() + " cid=" + cid);
        }
        this.dh = dh;
        this.cid = cid;
    }

    public Attachment(Object sigValue, Class sigClass, AttachmentDescription aDesc, String partName) {
        this.sigValue = sigValue;
        this.sigClass = sigClass;
        this.aDesc = aDesc;
        this.partName = partName;
    }

    public DataHandler getDataHandler() {
        if (this.dh == null) {
            if (this.sigValue == null) {
                this.getContentID();
                this.dh = null;
            } else {
                this.dh = Attachment.createDataHandler(this.sigValue, this.sigClass, this.aDesc.getMimeTypes(), this.getContentID());
            }
        }
        return this.dh;
    }

    public String getContentID() {
        if (this.cid == null) {
            this.cid = UIDGenerator.generateContentId();
            if (this.partName != null) {
                this.cid = this.partName + "=" + this.cid;
            }
        }
        return this.cid;
    }

    private static DataHandler createDataHandler(Object value, Class cls, String[] mimeTypes, String cid) {
        DataHandler dh;
        block9: {
            if (log.isDebugEnabled()) {
                System.out.println("Construct data handler for " + String.valueOf(cls) + " cid=" + cid);
            }
            dh = null;
            if (cls.isAssignableFrom(DataHandler.class)) {
                dh = (DataHandler)value;
                if (dh == null) {
                    return dh;
                }
                try {
                    Object content = dh.getContent();
                    if (content instanceof Source) {
                        if (log.isDebugEnabled()) {
                            System.out.println("Converting DataHandler Source content to DataHandlerString content");
                        }
                        byte[] bytes = (byte[])ConvertUtils.convert(content, byte[].class);
                        String newContent = new String(bytes);
                        return new DataHandler((Object)newContent, mimeTypes[0]);
                    }
                    break block9;
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
            }
            try {
                byte[] bytes = Attachment.createBytes(value, cls, mimeTypes);
                InternetHeaders ih = new InternetHeaders();
                ih.setHeader("Content-Type", mimeTypes[0]);
                MimeBodyPart mbp = new MimeBodyPart(ih, bytes);
                MimePartDataSource ds = new MimePartDataSource((MimePart)mbp);
                dh = new DataHandler((DataSource)ds);
                mbp.setHeader("Content-Id", cid);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        return dh;
    }

    private static byte[] createBytes(Object value, Class cls, String[] mimeTypes) {
        if (cls.isAssignableFrom(byte[].class)) {
            return (byte[])value;
        }
        if (cls.isAssignableFrom(String.class)) {
            return ((String)value).getBytes();
        }
        if (cls.isAssignableFrom(Image.class)) {
            return Attachment.createBytesFromImage((Image)value, mimeTypes[0]);
        }
        if (ConvertUtils.isConvertable(value, byte[].class)) {
            return (byte[])ConvertUtils.convert(value, byte[].class);
        }
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"convertProblem", (String)cls.getName(), (String)"byte[]"));
    }

    private static byte[] createBytesFromImage(Image image, String mimeType) {
        try {
            ImageWriter imageWriter = null;
            BufferedImage bufferedImage = (BufferedImage)image;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(mimeType);
            if (iterator.hasNext()) {
                imageWriter = iterator.next();
            }
            ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
            imageWriter.setOutput(ios);
            imageWriter.write(new IIOImage(bufferedImage, null, null));
            ios.flush();
            imageWriter.dispose();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }
}

