/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerBuilder;
import org.apache.activemq.artemis.core.server.management.JMXAccessControlList;
import org.apache.activemq.artemis.logs.AuditLogger;

public class ArtemisMBeanServerGuard
implements InvocationHandler {
    private JMXAccessControlList jmxAccessControlList = JMXAccessControlList.createDefaultList();

    public void init() {
        ArtemisMBeanServerBuilder.setGuard(this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getParameterTypes().length == 0) {
            return null;
        }
        if (!ObjectName.class.isAssignableFrom(method.getParameterTypes()[0])) {
            return null;
        }
        ObjectName objectName = (ObjectName)args[0];
        if ("getAttribute".equals(method.getName())) {
            this.handleGetAttribute((MBeanServer)proxy, objectName, (String)args[1]);
        } else if ("getAttributes".equals(method.getName())) {
            this.handleGetAttributes((MBeanServer)proxy, objectName, (String[])args[1]);
        } else if ("setAttribute".equals(method.getName())) {
            this.handleSetAttribute((MBeanServer)proxy, objectName, (Attribute)args[1]);
        } else if ("setAttributes".equals(method.getName())) {
            this.handleSetAttributes((MBeanServer)proxy, objectName, (AttributeList)args[1]);
        } else if ("invoke".equals(method.getName())) {
            this.handleInvoke(objectName, (String)args[1], (Object[])args[2], (String[])args[3]);
        }
        return null;
    }

    private void handleGetAttribute(MBeanServer proxy, ObjectName objectName, String attributeName) throws JMException, IOException {
        MBeanInfo info = proxy.getMBeanInfo(objectName);
        String prefix = null;
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attributeName)) continue;
            prefix = attr.isIs() ? "is" : "get";
        }
        if (prefix != null) {
            this.handleInvoke(objectName, prefix + attributeName, new Object[0], new String[0]);
        }
    }

    private void handleGetAttributes(MBeanServer proxy, ObjectName objectName, String[] attributeNames) throws JMException, IOException {
        for (String attr : attributeNames) {
            this.handleGetAttribute(proxy, objectName, attr);
        }
    }

    private void handleSetAttribute(MBeanServer proxy, ObjectName objectName, Attribute attribute) throws JMException, IOException {
        String dataType = null;
        MBeanInfo info = proxy.getMBeanInfo(objectName);
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attribute.getName())) continue;
            dataType = attr.getType();
            break;
        }
        if (dataType == null) {
            throw new IllegalStateException("Attribute data type can not be found");
        }
        this.handleInvoke(objectName, "set" + attribute.getName(), new Object[]{attribute.getValue()}, new String[]{dataType});
    }

    private void handleSetAttributes(MBeanServer proxy, ObjectName objectName, AttributeList attributes) throws JMException, IOException {
        for (Attribute attr : attributes.asList()) {
            this.handleSetAttribute(proxy, objectName, attr);
        }
    }

    private boolean canBypassRBAC(ObjectName objectName) {
        return this.jmxAccessControlList.isInWhiteList(objectName);
    }

    void handleInvoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws IOException {
        if (this.canBypassRBAC(objectName)) {
            return;
        }
        List<String> requiredRoles = this.getRequiredRoles(objectName, operationName, params, signature);
        for (String role : requiredRoles) {
            if (!ArtemisMBeanServerGuard.currentUserHasRole(role)) continue;
            return;
        }
        if (AuditLogger.isResourceLoggingEnabled()) {
            AuditLogger.objectInvokedFailure((ObjectName)objectName, (String)operationName);
        }
        throw new SecurityException("Insufficient roles/credentials for operation");
    }

    List<String> getRequiredRoles(ObjectName objectName, String methodName, Object[] params, String[] signature) throws IOException {
        return this.jmxAccessControlList.getRolesForObject(objectName, methodName);
    }

    public void setJMXAccessControlList(JMXAccessControlList JMXAccessControlList2) {
        this.jmxAccessControlList = JMXAccessControlList2;
    }

    public static boolean currentUserHasRole(String requestedRole) {
        String role;
        String clazz;
        int index = requestedRole.indexOf(58);
        if (index > 0) {
            clazz = requestedRole.substring(0, index);
            role = requestedRole.substring(index + 1);
        } else {
            clazz = "org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal";
            role = requestedRole;
        }
        AccessControlContext acc = AccessController.getContext();
        if (acc == null) {
            return false;
        }
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return false;
        }
        for (Principal p : subject.getPrincipals()) {
            if (!clazz.equals(p.getClass().getName()) || !role.equals(p.getName())) continue;
            return true;
        }
        return false;
    }
}

