/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rfnr_fun.h"
#include "str_fun.h"
#include "refs.h"
 


 extern char kennziff_temp_name[PFAD_LEN];
 extern char wrtxtbu[WRTXTBU_LEN+1];
 extern config_set one_config_set;

 FILE * fpkennzifftemp;


int kennziffer_schreiben(char * schluessel)
{
   if ((fpkennzifftemp=fopen(kennziff_temp_name,"w"))==NULL)
   {
      fprintf(stderr,"\nProblem: unable to write into %s\n",
              kennziff_temp_name);
      exit(1);
   }
   fprintf(fpkennzifftemp,"%s",schluessel);
   fclose(fpkennzifftemp);
   return 1;
}


int kennziffer_lesen_allein(char * schluessel)
{
   char ch;
   int i;
   i = 0;
   if ((fpkennzifftemp=fopen(kennziff_temp_name,"r"))==NULL)
   {
      strcpy(schluessel,"");
      return 0;
   }
   else
   {
      strcpy(schluessel,"");
      do
      {
         ch = fgetc(fpkennzifftemp);
         if (ch!=EOF && ch!='\n')
            schluessel[i] = ch;
         else schluessel[i] = '\0';
         i++;
      } while (ch!=EOF && ch!= '\n' && i < KENNZIFFER_LEN);
      schluessel[KENNZIFFER_LEN]= '\0';
      fclose(fpkennzifftemp);
   }
   if (strlen(schluessel) > 0)
     return 1;
   else
     return 0;
}

