/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   v4.2 
   drec_fun.c: deletes records in REFERENCES database, which are
   defined in a BBT-file.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ix01_fun.h"
#include "ix04_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "sortix01.h"
#include "sortix04.h"
#include "bbf_fun.h"
#include "sortbbf1.h"
#include "interf.h"
#include "initial.h"

 extern FILE * ix01file;
 extern FILE * ix04file;

 extern config_set             one_config_set;

 extern journal_rec            one_journal_rec;
 extern desc_rec               one_desc_rec;
 extern buch_rec               one_buch_rec;
 extern refspix_rec            ix01rec;
 extern abstrpix_rec           ix04rec;
 extern abstr_rec              one_abstr_rec;
 extern author_rec             one_aued_rec;
 static bbatchtable_rec        one_bbt_rec;


 extern char journal_pix_name[PFAD_LEN + 1];
 extern char journal_name[PFAD_LEN + 1];
 extern FILE * fpjournal;
 extern char desc_name[PFAD_LEN + 1];
 extern FILE * fpdesc;
 extern char book_name[PFAD_LEN + 1];
 extern FILE * fpbuch;
 extern char autorjl_name[PFAD_LEN + 1];
 extern FILE * fpautorjl;
 extern char autorbu_name[PFAD_LEN + 1];
 extern FILE * fpautorbu;
 static FILE * tmpix;
 static char tmpix_name[PFAD_LEN + 1];
 static char newix_name[PFAD_LEN + 1];

 extern char abstr_dat_name[PFAD_LEN + 1];
 extern FILE * fpabs;
 extern char abstr_pix_name[PFAD_LEN + 1];

 static FILE * tmpix_abs;

 static char tmpix_abs_name[PFAD_LEN + 1];
 static char newix_abs_name[PFAD_LEN + 1];
    /* Die Datei, aus der die zu loeschenden Datensaetze entnommen werden  */
 static FILE * fpbbt;
 static char bbt_name[PFAD_LEN + 1];
 static char dollar_bbt_name[PFAD_LEN + 1];        /* temporary bbt-file */
 static char dollar_dollar_bbt_name[PFAD_LEN + 1]; /* temporary bbt-file */
 
 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];
 

 static char schluessel[KENNZIFFER_LEN + 2];
 static char schluessel_neu[KENNZIFFER_LEN + 2];

 extern char wrtxtbu[WRTXTBU_LEN+1];

 static int bbt_datei_vorbereiten(void);
 static int steuerung_ds_loeschen(void);
 static int db_dateien_oeffnen(void);
 static int db_dateien_schliessen(void);
 static int ds_loeschen(void);
 static int abstract_loeschen(void);


int drec_fun_main(void)
{
   wrtxt("\nDelete all records referred to in a bbt-file\n");
   anhalten();

   strncpy(schluessel,"",KENNZIFFER_LEN);
   strncpy(schluessel_neu,"",KENNZIFFER_LEN);
  
   strlimcpy(tmpix_name,rdbpfad,PFAD_LEN);
   strlimcat(tmpix_name,"tmp01.ix$",PFAD_LEN);

   strlimcpy(newix_name,rdbpfad,PFAD_LEN);
   strlimcat(newix_name,"new01.ix",PFAD_LEN);
    
   strlimcpy(tmpix_abs_name,rdbpfad,PFAD_LEN);
   strlimcat(tmpix_abs_name,"tmp02.ix$",PFAD_LEN);

   strlimcpy(newix_abs_name,rdbpfad,PFAD_LEN);
   strlimcat(newix_abs_name,"new02.ix$",PFAD_LEN);
   
   strlimcpy(dollar_bbt_name,rdbpfad,PFAD_LEN);
   strlimcat(dollar_bbt_name,"_$.bbt",PFAD_LEN);
   
   strlimcpy(dollar_dollar_bbt_name,rdbpfad,PFAD_LEN);
   strlimcat(dollar_dollar_bbt_name,"_$$.bbt",PFAD_LEN);

   if (bbt_datei_vorbereiten())
   {
      wrtxt("\n");
      steuerung_ds_loeschen();
      return 0;
   }
   else return 1;
}

static int bbt_datei_vorbereiten(void)
{
  int taste;

  taste = datei_suchen_mit_pfad("*.bbt",rdbpfad,bbt_name);

  if (taste)
  {
     int sortiert_ok;
     char kennz_alt[KENNZIFFER_LEN + 1];
     long i, anzahl_records;
     sortiert_ok = 1;

     strcpy(kennz_alt,"");

     if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
     {
          fprintf(stderr,"\nERROR: cannot open %s for reading\n",
               bbt_name);
          exit(1);
     }
     fseek(fpbbt,0L,SEEK_END);
     anzahl_records = ftell(fpbbt) / sizeof(one_bbt_rec) - 1;
     rewind(fpbbt);
     for (i=0;i<=anzahl_records;i++)
     {
         if (fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt)==0)
         {
             sprintf(wrtxtbu,"\nERROR: at least one record in %s not read\n",
                bbt_name);
             wrtxt(wrtxtbu);
             anhalten();
             fclose(fpbbt);
             return 0;
         }
         if (strcmp(kennz_alt,one_bbt_rec.kennziffer)>=0)
         {
            sortiert_ok = 0;
            wrtxt("\nIt will be necessary to sort bbt-file\n");
            anhalten();
            break;
         }
         strcpy(kennz_alt,one_bbt_rec.kennziffer);
     }
     fclose (fpbbt);

     if (sortiert_ok)
     {
         sprintf(wrtxtbu,"\n(Reference numbers found sorted in %s)",bbt_name);
         wrtxt(wrtxtbu);
         return 1;
     }
     else
     {
        if (isfile(dollar_bbt_name)) remove(dollar_bbt_name);
        if (isfile(dollar_dollar_bbt_name)) remove(dollar_dollar_bbt_name);
        sprintf(wrtxtbu,"\n(Sorting records from file %s in ascending order)\n",bbt_name);
        wrtxt(wrtxtbu);
        domergebbf1(bbt_name,dollar_bbt_name);
        wrtxt("\n(Removing duplicate reference numbers)");
        dupl_ex_bbf(dollar_bbt_name,dollar_dollar_bbt_name);
        strcpy(bbt_name,dollar_dollar_bbt_name);
        /* ...now both variables point to the same file (_$$.bbt), the
         * variable 'bbt_name' is called for processing deletion of records,
         * the variable 'dollar_dollar_bbt_name' is called for deleting
         * _$$.bbt (this peculiar manoevre has been checked repeatedly, V.K.
         * 8.2.2003)*/
        return 1;
     }
  }
  else
  {
     wrtxt("\n(aborted)\n");
     return 0;
  }

}

static int steuerung_ds_loeschen(void)
{
  int i_loesch;    /* Zaehler fuer zu loeschende Datensaetze */
  int abs_loesch;  /* Zaehler fuer zu loeschende Abstract-Datensaetze */
  long ix_zeiger_db, ix_zeiger_ab, anzahl_records;
  long i;
  int taste;

  taste = do_delete_yn();
  if (taste==0)
  {
      if (isfile(dollar_dollar_bbt_name)) remove(dollar_dollar_bbt_name);
      if (isfile(dollar_bbt_name)) remove(dollar_bbt_name);
      return 0;
  }
  wrtxt("\n(Deleting records)\n");
  i_loesch = 0;
  abs_loesch = 0;
  db_dateien_oeffnen();
  read_ix01(journal_pix_name);
  read_ix04(abstr_pix_name);

  if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
  {
      fprintf(stderr,"\nERROR: cannot open %s\n", bbt_name);
      exit(1);
  }
  fseek(fpbbt,0L,SEEK_END);

  anzahl_records = ftell(fpbbt)/sizeof(one_bbt_rec);
  anzahl_records--;
  rewind(fpbbt);

  if ((tmpix=fopen(tmpix_name,"w+b"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot create %s\n",tmpix_name);
     exit(1);
  }
  
  if ((tmpix_abs=fopen(tmpix_abs_name,"w+b"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot create %s\n",tmpix_abs_name);
     exit(1);
  }


  for (i=0;i<=anzahl_records;i++)
  {
     if(fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt) < 1)
     {
        fprintf(stderr,"\nERROR: cannot read %s\n",bbt_name);
        exit(1);
     }
     ix_zeiger_db = locate_ix01(one_bbt_rec.kennziffer,&ix01rec);
     if (ix_zeiger_db > -1)
     {
           /* Datensaetze mit der Loeschkennung versehen */
         ds_loeschen();
           /* Index-Datensatz in temporaere Indexdatei schreiben  */
         fseek(tmpix,0L,SEEK_END);
         if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix) < 1) schreibfehler();
         i_loesch++;
     }
  }
  rewind(fpbbt);
  for (i=0;i<=anzahl_records;i++)
  {
     if(fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt) < 1)
     {
        fprintf(stderr,"\nERROR: cannot read %s\n",bbt_name);
        exit(1);
     }
     ix_zeiger_ab = locate_ix04(one_bbt_rec.kennziffer,&ix04rec);
     if (ix_zeiger_ab > -1)
     {
         /* Abstract-Datensaetze mit der Loeschkennung versehen */
         abstract_loeschen();
         /* Index-Datensatz (zu Abstract) in temporaere Indexdatei schreiben  */
         fseek(tmpix_abs,0L,SEEK_END);
         if (fwrite(&ix04rec,sizeof(ix04rec),1,tmpix_abs) < 1) schreibfehler();
         abs_loesch++;
     }
  }

  fclose(fpbbt);
  fclose(tmpix);
  fclose(tmpix_abs);
  close_ix01();
  close_ix04();
  db_dateien_schliessen();

  if (i_loesch > 0)
  {
          wrtxt("\n");
          if (i_loesch > 1)
          {
             domerge01(tmpix_name,newix_name);
             remove(tmpix_name);
             rename(newix_name,tmpix_name);
          }
          wrtxt("(Modifying main index file)\n");
          deleteix01(journal_pix_name,tmpix_name,newix_name);
          remove(journal_pix_name); remove(tmpix_name);
          rename(newix_name,journal_pix_name);
          sprintf(wrtxtbu,"(%i records successfully deleted)\n",
             i_loesch);
          wrtxt(wrtxtbu);
          sprintf(wrtxtbu,"Bbt-file: `%s':\n"
            "  %i records successfully deleted in database",
             bbt_name,i_loesch);
          protokollieren(wrtxtbu);

  }
  else
  {
          if (isfile(tmpix_name)) remove(tmpix_name);
  }

  if (abs_loesch > 0)
  {
     if (abs_loesch > 1)
     {
        domerge04(tmpix_abs_name,newix_abs_name);
        remove(tmpix_abs_name);
        rename(newix_abs_name,tmpix_abs_name);
     }
     wrtxt("(Modifying abstract index file)\n");
     deleteix04(abstr_pix_name,tmpix_abs_name,newix_abs_name);
     remove(abstr_pix_name);
     remove(tmpix_abs_name); /* ergaenzt 25.12.1996 */
     rename(newix_abs_name,abstr_pix_name);
     sprintf(wrtxtbu,"(%i abstracts successfully deleted)\n",
          abs_loesch);
     wrtxt(wrtxtbu);
     sprintf(wrtxtbu,"Bbt-file: `%s':\n"
       "  %i abstract records successfully deleted in database",
        bbt_name,abs_loesch);
     protokollieren(wrtxtbu);
  }
  else
  {
     if (isfile(tmpix_abs_name)) remove(tmpix_abs_name);
  }
  if (isfile(dollar_dollar_bbt_name)) remove(dollar_dollar_bbt_name);
  if (isfile(dollar_bbt_name)) remove(dollar_bbt_name);
  if (i_loesch == 0 && abs_loesch==0)
  {
    wrtxt("(Nothing found to delete)\n");
  }
  return 1;
}

static int db_dateien_oeffnen(void)
{
  if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
  {
     fprintf(stderr,"\nERROR: cannot open %s\n",journal_name);
     exit(1);
  }
  if (setvbuf(fpjournal,NULL,_IOFBF,sizeof(one_journal_rec))!=0)
  {
     fprintf(stderr,"\nERROR: cannot allocate buffer for fpjournal\n");
     exit(1);
  }
  if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
  {
     fprintf(stderr,"\nERROR: cannot open %s\n",desc_name);
     exit(1);
  }
  if (setvbuf(fpdesc,NULL,_IOFBF,sizeof(one_desc_rec))!=0)
  {
     fprintf(stderr,"\nERROR: cannot allocate buffer for fpdesc\n");
     exit(1);
  }
  if ((fpbuch=fopen(book_name,"r+b"))==NULL)
  {
     fprintf(stderr,"\nERROR: cannot open %s\n",book_name);
     exit(1);
  }
  if (setvbuf(fpbuch,NULL,_IOFBF,sizeof(one_buch_rec))!=0)
  {
     fprintf(stderr,"\nERROR: cannot allocate buffer for fpbuch\n");
     exit(1);
  }

  if ((fpautorjl=fopen(autorjl_name,"r+b"))==NULL)
  {
     fprintf(stderr,"\nERROR: cannot open %s\n",autorjl_name);
     exit(1);
  }
  if (setvbuf(fpautorjl,NULL,_IOFBF,sizeof(one_aued_rec))!=0)
  {
      fprintf(stderr,"\nERROR: cannot allocate buffer for fpautorjl\n");
      exit(1);
  }

  if ((fpautorbu=fopen(autorbu_name,"r+b"))==NULL)
  {
     fprintf(stderr,"\nERROR: cannot open %s\n",autorbu_name);
     exit(1);
  }
  if (setvbuf(fpautorbu,NULL,_IOFBF,sizeof(one_aued_rec))!=0)
  {
     fprintf(stderr,"\nERROR: cannot allocate buffer for fpautorbu\n");
     exit(1);
  }
  if ((fpabs=fopen(abstr_dat_name,"r+b"))==NULL)
  {
     fprintf(stderr,"\nERROR: cannot open %s\n",abstr_dat_name);
     exit(1);
  }
  if (setvbuf(fpabs,NULL,_IOFBF,sizeof(abstr_rec))!=0)
  {
     fprintf(stderr,"\nERROR: cannot allocate buffer for fpabs\n");
     exit(1);
  }
  return 0;
}

static int db_dateien_schliessen(void)
{
  fclose(fpjournal);
  fclose(fpdesc);
  fclose(fpbuch);
  fclose(fpautorjl);
  fclose(fpautorbu);
  fclose(fpabs);
  return 0;
}

static int ds_loeschen(void)
{
  long byte_zeiger;
  int i, n_aut, n_desc;
  author_rec one_aued_rec;

  byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
  fseek(fpjournal,byte_zeiger,SEEK_SET);
  fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
  if ((!strcmp(one_journal_rec.reftyp,"j1")) || 
    (!strcmp(one_journal_rec.reftyp,"m1")))
  {
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      if (fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal) < 1) schreibfehler();

      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorjl, - (long) sizeof(one_aued_rec),SEEK_CUR);
            if (fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl) < 1) schreibfehler();
            fseek(fpautorjl,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            if (fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc) < 1) schreibfehler();
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }
  }
      /* Ende j1 */
  
  if ((!strcmp(one_journal_rec.reftyp,"j2"))||
    (!strcmp(one_journal_rec.reftyp,"m2")))
  {
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      if (fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal) < 1) schreibfehler();


      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            if (fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc) < 1) schreibfehler();
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }
  }
      /* Ende j2 */

  if (!strcmp(one_journal_rec.reftyp,"b1"))
  {
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      if (fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal) < 1) schreibfehler();

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      one_buch_rec.in_use_bu = 0;
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      if (fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch) < 1) schreibfehler();


      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorbu, - (long) sizeof(one_aued_rec),SEEK_CUR);
            if (fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu) < 1) schreibfehler();
            fseek(fpautorbu,0L,SEEK_CUR);   /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            if (fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc) < 1) schreibfehler();
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }
  }

       /* Ende b1 */


  if (!strcmp(one_journal_rec.reftyp,"b2"))
  {
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      if (fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal) < 1) schreibfehler();

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      one_buch_rec.in_use_bu = 0;
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      if (fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch) < 1) schreibfehler();

      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorjl, - (long) sizeof(one_aued_rec),SEEK_CUR);
            if (fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl) < 1) schreibfehler();
            fseek(fpautorjl,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }


      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorbu, - (long) sizeof(one_aued_rec),SEEK_CUR);
            if (fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu) < 1) schreibfehler();
            fseek(fpautorbu,0L,SEEK_CUR);   /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            if (fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc) < 1) schreibfehler();
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }
  }
       /* Ende b2 */
  if (!strcmp(one_journal_rec.reftyp,"b3"))
  {
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      if (fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal) < 1) schreibfehler();

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      one_buch_rec.in_use_bu = 0;
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      if (fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch) < 1) schreibfehler();

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            if (fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc) < 1) schreibfehler();
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }
  }

       /* Ende b3 */
  return 1;
}

static int abstract_loeschen(void)
{
  long byte_zeiger;
  int i, anzahl_bloecke;

  byte_zeiger = ix04rec.abstr_rptr * sizeof(one_abstr_rec);
  fseek(fpabs,byte_zeiger,SEEK_SET);
  fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
  fseek(fpabs,byte_zeiger,SEEK_SET);
  anzahl_bloecke = one_abstr_rec.abstr_n;
  for (i=1; i <= anzahl_bloecke;i++)
  {
      fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
      one_abstr_rec.in_use = 0;
      fseek(fpabs, - (long) sizeof(one_abstr_rec),SEEK_CUR);
      if (fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs) < 1) schreibfehler();
      fseek(fpabs,0L,SEEK_CUR);
        /* zwischen Wechsel von fwrite nach fread immer 'fseek' */
  }
  return 1;
}

