#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#

#
#    ooo_sr.awk -- create a macro for converting citations in OpenOffice.org 
#    for Windows
#
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f ooo_sr.awk textfile
#
#    Versions:
#    16.7.2005: name of `outfle' may be changed (for References v4.2)
#    12.6.2007: 
#       line:  "if (length(such_str) && length(ers_str) > 0)" changed to
#              "if (length(such_str) > 0 && length(ers_str) > 0)"
#
#

BEGIN {
   a = ""
   i = 0
   if (!output_file)
   {
     outfle = "ooo-mak.txt"
   } else
   {
     outfle=output_file
   }
}

{
  
  a = $0
  
  such_str=""
  ers_str=""
  von_pos = length("///A///") + index(a,"///A///")
  bis_pos = index(a,"///B///")
  such_str = substr(a,von_pos,bis_pos-von_pos)
  
  von_pos = length("///B///") + index(a,"///B///")
  bis_pos = index(a,"///C///")
  ers_str = substr(a,von_pos,bis_pos-von_pos)

  if (length(such_str) > 0 && length(ers_str) > 0)
  {
     i++
     such_arr[i] = such_str
     ers_arr[i]  = ers_str
  }
  
}

END {
  n = i

  print("REM  *****  BASIC  *****\n") > outfle
  print("Sub Main") > outfle
  print("Dim I As Long") > outfle
  print("Dim Doc As Object") > outfle
  print("Dim Replace As Object") > outfle
  printf("Dim RawWords(%i) As String\n",i-1) > outfle
  printf("Dim FormattedWords(%i) As String\n",i-1) > outfle
  print("RawWords() = Array(_") > outfle
  for (i=1;i<=n;i++)
  {
     if (i==n)
     {
       printf("\"%s\"_\n",such_arr[i]) > outfle
     } else
     {
       printf("\"%s\",_\n",such_arr[i]) > outfle
     }
  }
  print ")" > outfle
  print("FormattedWords() = Array(_") > outfle
  for (i=1;i<=n;i++)
  {
     if (i==n)
     {
       printf("\"%s\"_\n",ers_arr[i]) > outfle
     } else
     {
       printf("\"%s\",_\n",ers_arr[i]) > outfle
     }
  }
  print ")" > outfle
  print("Doc = StarDesktop.CurrentComponent") > outfle
  print("Replace = Doc.createReplaceDescriptor") > outfle
  printf("For I = 0 To %i\n",n-1) > outfle
  print("        Replace.SearchString = RawWords(I)") > outfle
  print("        Replace.ReplaceString = FormattedWords(I)") > outfle
  print("        Doc.replaceAll(Replace)") > outfle
  print("Next I") > outfle
  print("End Sub") > outfle

  print "\nOOOrg/Star Writer macro " outfle " created\n"
  close(outfle)
}

# vim:tw=2048
