/*	Hatch and Pattern Polygon Fill index value definitions
 *
 *	Hatch index values [1..6] are defined by the CGM Standard.
 *	Pattern index values are defined by the implementor.
 */

/* hatch index 1 = horizontal equally spaced parallel lines */
#define h_width 16
#define h_height 16
static char h_bits[] = {
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/* hatch index 2 = vertical equally spaced parallel lines */
#define v_width 16
#define v_height 16
static char v_bits[] = {
   0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
   0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
   0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11};

/* hatch index 3 = positive slope equally spaced parallel lines */
#define p_width 16
#define p_height 16
static char p_bits[] = {
   0x08, 0x82, 0x04, 0x41, 0x82, 0x20, 0x41, 0x10, 0x20, 0x08, 0x10, 0x04,
   0x08, 0x82, 0x04, 0x41, 0x82, 0x20, 0x41, 0x10, 0x20, 0x08, 0x10, 0x04,
   0x08, 0x82, 0x04, 0x41, 0x82, 0x20, 0x41, 0x10};

/* hatch index 4 = negative slope equally spaced parallel lines */
#define n_width 16
#define n_height 16
static char n_bits[] = {
   0x41, 0x10, 0x82, 0x20, 0x04, 0x41, 0x08, 0x82, 0x10, 0x04, 0x20, 0x08,
   0x41, 0x10, 0x82, 0x20, 0x04, 0x41, 0x08, 0x82, 0x10, 0x04, 0x20, 0x08,
   0x41, 0x10, 0x82, 0x20, 0x04, 0x41, 0x08, 0x82};

/* hatch index 5 = horizontal/vertical crosshatch */
#define hv_width 16
#define hv_height 16
static char hv_bits[] = {
   0xff, 0xff, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xff, 0xff, 0x11, 0x11,
   0x11, 0x11, 0x11, 0x11, 0xff, 0xff, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
   0xff, 0xff, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11};

/* hatch index 6 = positive slope/negative slope crosshatch */
#define pn_width 16
#define pn_height 16
static char pn_bits[] = {
   0x49, 0x92, 0x86, 0x61, 0x86, 0x61, 0x49, 0x92, 0x30, 0x0c, 0x30, 0x0c,
   0x49, 0x92, 0x86, 0x61, 0x86, 0x61, 0x49, 0x92, 0x30, 0x0c, 0x30, 0x0c,
   0x49, 0x92, 0x86, 0x61, 0x86, 0x61, 0x49, 0x92};

/* pattern index 1 */
#define boxes_width 16
#define boxes_height 16
static char boxes_bits[] = {
   0x0f, 0x0f, 0x09, 0x09, 0x09, 0x09, 0x0f, 0x0f, 0xf0, 0xf0, 0x90, 0x90,
   0x90, 0x90, 0xf0, 0xf0, 0x0f, 0x0f, 0x09, 0x09, 0x09, 0x09, 0x0f, 0x0f,
   0xf0, 0xf0, 0x90, 0x90, 0x90, 0x90, 0xf0, 0xf0};

/* pattern index 2 */
#define cross_weave_width 16
#define cross_weave_height 16
static char cross_weave_bits[] = {
   0x55, 0x55, 0x88, 0x88, 0x55, 0x55, 0x22, 0x22, 0x55, 0x55, 0x88, 0x88,
   0x55, 0x55, 0x22, 0x22, 0x55, 0x55, 0x88, 0x88, 0x55, 0x55, 0x22, 0x22,
   0x55, 0x55, 0x88, 0x88, 0x55, 0x55, 0x22, 0x22};

/* pattern index 3 */
#define icon_width 16
#define icon_height 16
static char icon_bits[] = {
   0xff, 0xff, 0xab, 0xaa, 0x55, 0xd5, 0xab, 0xaa, 0x05, 0xd0, 0x0b, 0xa0,
   0x05, 0xd0, 0x0b, 0xa0, 0x05, 0xd0, 0x0b, 0xa0, 0x05, 0xd0, 0x0b, 0xa0,
   0x55, 0xd5, 0xab, 0xaa, 0x55, 0xd5, 0xff, 0xff};

/* pattern index 4 */
#define opendot_width 16
#define opendot_height 16
static char opendot_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x60, 0x03, 0x20, 0x02, 0x60, 0x03, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/* pattern index 5 */
#define scales_width 16
#define scales_height 16
static char scales_bits[] = {
   0x10, 0x10, 0x10, 0x10, 0x28, 0x28, 0xc7, 0xc7, 0x01, 0x01, 0x01, 0x01,
   0x82, 0x82, 0x7c, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x28, 0x28, 0xc7, 0xc7,
   0x01, 0x01, 0x01, 0x01, 0x82, 0x82, 0x7c, 0x7c};

/* pattern index 6 */
#define star_width 16
#define star_height 16
static char star_bits[] = {
   0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x88, 0x08, 0x90, 0x04, 0xa0, 0x02,
   0x40, 0x01, 0x3e, 0x3e, 0x40, 0x01, 0xa0, 0x02, 0x90, 0x04, 0x88, 0x08,
   0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00};

/* pattern index 7 */
#define target_width 16
#define target_height 16
static char target_bits[] = {
   0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0xe0, 0x07, 0x90, 0x09, 0x88, 0x11,
   0xc8, 0x13, 0x7e, 0x7e, 0x7e, 0x7e, 0xc8, 0x13, 0x88, 0x11, 0x90, 0x09,
   0xe0, 0x07, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00};

/* pattern index 8 */
#define wide_weave_width 16
#define wide_weave_height 16
static char wide_weave_bits[] = {
   0x11, 0x11, 0xb8, 0xb8, 0x7c, 0x7c, 0x3a, 0x3a, 0x11, 0x11, 0xa3, 0xa3,
   0xc7, 0xc7, 0x8b, 0x8b, 0x11, 0x11, 0xb8, 0xb8, 0x7c, 0x7c, 0x3a, 0x3a,
   0x11, 0x11, 0xa3, 0xa3, 0xc7, 0xc7, 0x8b, 0x8b};

/* pattern index 9 */
#define dot_width 16
#define dot_height 16
static char dot_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0xf0, 0x0f, 0xf0, 0x0f,
   0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f,
   0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/* pattern index 10 */
#define stipple_width 16
#define stipple_height 16
static char stipple_bits[] = {
   0xee, 0xee, 0x55, 0x55, 0xba, 0xbb, 0x55, 0x55, 0xee, 0xee, 0x55, 0x55,
   0xba, 0xbb, 0x55, 0x55, 0xee, 0xee, 0x55, 0x55, 0xba, 0xbb, 0x55, 0x55,
   0xee, 0xee, 0x55, 0x55, 0xba, 0xfb, 0x55, 0x55};
