/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import de.nm.ant.ipdf.AbstractPdfTask;
import java.io.File;
import java.io.IOException;

public class PdfCompressTask
extends AbstractPdfTask {
    private String compress = "full";

    public void execute() {
        File input = this.getInputFile("pdf", this.usesrcfile);
        File output = this.getOutputFile("pdf");
        this.logVerboseHeader(input, output, true);
        try {
            PdfReader reader = this.createPdfReaderFromFile(this.srcfile);
            PdfStamper stamper = new PdfStamper(reader, this.createOutputStream(output), this.version);
            if (this.compress.equalsIgnoreCase("full")) {
                stamper.setFullCompression();
                stamper.getWriter().setCompressionLevel(9);
            } else {
                int level = 9;
                try {
                    level = Integer.parseInt(this.compress);
                }
                catch (NumberFormatException e) {
                    level = 9;
                }
                stamper.getWriter().setCompressionLevel(level);
            }
            int maxpages = reader.getNumberOfPages();
            int i = 1;
            while (i <= maxpages) {
                reader.setPageContent(i, reader.getPageContent(i));
                ++i;
            }
            stamper.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    public void setCompress(String compress) {
        this.compress = compress;
    }
}

