/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import de.nm.ant.ipdf.AbstractPagesPdfTask;
import java.io.File;
import java.io.IOException;

public class PdfBurstTask
extends AbstractPagesPdfTask {
    private String numberformat = "_%1d";

    public void execute() {
        File input = this.getInputFile("pdf", this.usesrcfile);
        this.logVerboseHeader(input, this.pages);
        try {
            PdfReader reader = this.createPdfReaderFromFile(input);
            this.maxPage = reader.getNumberOfPages();
            int page = 1;
            while (page <= this.maxPage) {
                if (this.isPageinRange(page)) {
                    File output = this.getOutputFile(String.format(this.numberformat, page), "pdf");
                    this.logVerbose(output, true);
                    Document document = new Document();
                    PdfCopy copy = new PdfCopy(document, this.createOutputStream(output));
                    copy.setPdfVersion(this.version);
                    document.open();
                    copy.addPage(copy.getImportedPage(reader, page));
                    document.close();
                }
                ++page;
            }
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    public void setNumberformat(String numberformat) {
        this.numberformat = numberformat;
    }
}

