% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Caesar}
\alias{Caesar}
\title{Risk Factors for Infection in Caesarian Births}
\format{
A 4-dimensional array resulting from cross-tabulating 4 variables
for 251 observations. The variable names and their levels are:

\tabular{rll}{
dim \tab Name \tab Levels \cr
1 \tab \code{Infection}\tab \verb{"Type 1", "Type 2", "None"}\cr
2 \tab \code{Risk}\tab \verb{"Yes", "No"} (presence of risk factors)\cr
3 \tab \code{Antibiotics}\tab \verb{"Yes", "No"} (were antibiotics given?)\cr
4 \tab \code{Planned}\tab \verb{"Yes", "No"} (was the C section planned?)\cr
}
}
\source{
\% \cite{Fahrmeir:94}
Fahrmeir, L. & Tutz, G. (1994). Multivariate
Statistical Modelling Based on Generalized Linear Models New York: Springer
Verlag, Table 1.1.
}
\description{
Data from infection from birth by Caesarian section, classified by
\code{Risk} (two levels), whether \code{Antibiotics} were used (two levels)
and whether the Caesarian section was \code{Planned} or not.  The outcome is
\code{Infection} (three levels).
}
\details{
\code{Infection} is regarded as the response variable here.  There are quite
a few 0 cells here, particularly when \code{Risk} is absent and the
Caesarian section was unplanned. Should these be treated as structural or
sampling zeros?
}
\examples{

data(Caesar)
#display table;  note that there are quite a few 0 cells
structable(Caesar)
require(MASS)

# baseline model, Infection as response
Caesar.mod0 <- loglm(~Infection + (Risk*Antibiotics*Planned),
                     data=Caesar)

# NB: Pearson chisq cannot be computed due to the 0 cells
Caesar.mod0

mosaic(Caesar.mod0, main="Baseline model")

# Illustrate handling structural zeros
zeros <- 0+ (Caesar >0)
zeros[1,,1,1] <- 1
structable(zeros)

# fit model excluding possible structural zeros
Caesar.mod0s <- loglm(~Infection + (Risk*Antibiotics*Planned),
                      data=Caesar,
	                    start=zeros)
Caesar.mod0s

anova(Caesar.mod0, Caesar.mod0s, test="Chisq")

mosaic (Caesar.mod0s)

# what terms to add?
add1(Caesar.mod0, ~.^2, test="Chisq")

# add Association of Infection:Antibiotics
Caesar.mod1 <- update(Caesar.mod0, ~ . + Infection:Antibiotics)
anova(Caesar.mod0, Caesar.mod1, test="Chisq")

mosaic(Caesar.mod1,
       gp=shading_Friendly,
       main="Adding Infection:Antibiotics")


}
\seealso{
\code{\link[Fahrmeir]{caesar}} for the same data recorded as a
frequency data frame with other variables.
}
\keyword{datasets}
