% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-style.R
\name{grid_colorbar}
\alias{grid_colorbar}
\title{Style cells with a color bar}
\usage{
grid_colorbar(
  grid,
  column,
  bar_bg = "#5E81AC",
  color = "#ECEFF4",
  background = "#ECEFF4",
  from = NULL,
  prefix = NULL,
  suffix = NULL,
  label_outside = FALSE,
  label_width = "20px",
  border_radius = "0px",
  height = "16px",
  align = c("left", "center", "right")
)
}
\arguments{
\item{grid}{A grid created with \code{\link[=datagrid]{datagrid()}}.}

\item{column}{The name of the column where to create a color bar.}

\item{bar_bg}{Background color of the color bar.}

\item{color}{Color of the text.}

\item{background}{Background of the cell.}

\item{from}{Range of values of the variable to represent as a color bar.}

\item{prefix, suffix}{String to put in front of or after the value.}

\item{label_outside}{Show label outside of the color bar.}

\item{label_width}{Width of label in case it's displayed outside the color bar.}

\item{border_radius}{Border radius of color bar.}

\item{height}{Height in pixel of color bar.}

\item{align}{Alignment of label if it is displayed inside the color bar.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Style cells with a color bar
}
\examples{
library(toastui)

dat <- rolling_stones_50[, "Artist", drop = FALSE]
dat$percentage <- sample(1:100, size = 50, replace = TRUE)
dat$numeric <- sample(1:1500, size = 50, replace = TRUE)

datagrid(dat) \%>\%
  grid_colorbar(
    column = "percentage"
  )

datagrid(dat) \%>\%
  grid_colorbar(
    column = "percentage",
    label_outside = TRUE
  )

# More options
datagrid(dat) \%>\%
  grid_colorbar(
    column = "percentage",
    from = c(0, 100),
    suffix = "\%"
  ) \%>\%
  grid_colorbar(
    column = "numeric",
    bar_bg = "#BF616A",
    from = c(0, 1500),
    prefix = "$",
    height = "20px"
  )


data.frame(
  rn = rownames(mtcars),
  mpg = mtcars$mpg,
  check.names = FALSE
) \%>\%
  datagrid(colnames = c("Automobile", "Miles/(US) gallon")) \%>\%
  grid_colorbar(
    column = "mpg",
    bar_bg = ifelse(mtcars$mpg > mean(mtcars$mpg), "#5cb85c", "#BF616A"),
    label_outside = TRUE,
    label_width = "25px"
  )

}
