% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editor-proxy.R
\name{editor_proxy_insert}
\alias{editor_proxy_insert}
\title{Insert text in an editor}
\usage{
editor_proxy_insert(proxy, text)
}
\arguments{
\item{proxy}{A \code{\link[=editor_proxy]{editor_proxy()}} or \code{outputId} of the editor}

\item{text}{Text to insert.}
}
\value{
A \code{editor_proxy} object.
}
\description{
Insert text in an editor
}
\examples{

library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("Use editor's proxy"),
  fluidRow(
    column(
      width = 4,
      radioButtons(
        inputId = "changePreviewStyle",
        label = "change preview style",
        choices = c("tab", "vertical")
      ),
      checkboxInput(
        inputId = "showhide",
        label = "Show/hide editor", 
        value = TRUE
      ),
      textInput(
        inputId = "text",
        label = "Text to insert:",
        width = "100\%"
      ),
      actionButton("insert", "Insert text")
    ),
    column(
      width = 8,
      editorOutput("my_editor")
    )
  )
)

server <- function(input, output, session) {
  
  output$my_editor <- renderEditor({
    editor()
  })
  
  observeEvent(input$changePreviewStyle, {
    editor_proxy_change_preview("my_editor", input$changePreviewStyle)
  }, ignoreInit = TRUE)
  
  observeEvent(input$showhide, {
    if (input$showhide) {
      editor_proxy_show("my_editor")
    } else {
      editor_proxy_hide("my_editor")
    }
  }, ignoreInit = TRUE)
  
  observeEvent(input$insert, {
    editor_proxy_insert("my_editor", text = input$text)
  })
  
}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
Other editor proxy methods: 
\code{\link{editor-proxy-show-hide}},
\code{\link{editor_proxy}()},
\code{\link{editor_proxy_change_preview}()}
}
\concept{editor proxy methods}
