% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratic_forms.R
\name{distribute_matrix_across_clusters}
\alias{distribute_matrix_across_clusters}
\title{Helper function to turn a cluster-level matrix into an element-level matrix
by duplicating rows or columns of the matrix}
\usage{
distribute_matrix_across_clusters(
  cluster_level_matrix,
  cluster_ids,
  rows = TRUE,
  cols = TRUE
)
}
\arguments{
\item{cluster_level_matrix}{A square matrix, whose number of rows/columns matches the number of clusters.}

\item{cluster_ids}{A vector of cluster identifiers.
If \code{rows=TRUE}, the number of unique elements of \code{cluster_ids}
must match the number of rows of \code{cluster_level_matrix}.
If \code{cols=TRUE}, the number of unique elements of \code{cluster_ids}
must match the number of columns of \code{cluster_level_matrix}.}

\item{rows}{Whether to duplicate rows of the \code{cluster_level_matrix} for elements from the same cluster.}

\item{cols}{Whether to duplicate columns of the \code{cluster_level_matrix} for elements from the same cluster.}
}
\value{
The input \code{cluster_level_matrix} has its rows/columns
duplicated so that the number of rows (if \code{rows=TRUE}) or columns (if \code{cols=TRUE})
equals the length of \code{cluster_ids}.
}
\description{
Turns a cluster-level matrix into an element-level matrix
by suitably duplicating rows or columns of the matrix.
}
\keyword{internal}
