% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shrinkTPR}
\alias{plot.shrinkTPR}
\title{Graphical summary of posterior of theta}
\usage{
\method{plot}{shrinkTPR}(x, nsamp = 1000, ...)
}
\arguments{
\item{x}{a \code{shrinkTPR} object.}

\item{nsamp}{a positive integer specifying the number of posterior samples to draw for plotting.
The default is \code{1000}.}

\item{...}{further arguments passed to the internal \code{\link[graphics]{boxplot}} function,
such as axis labeling or plotting options. By default, \code{las = 2} is used unless explicitly
overridden by the user.}
}
\value{
Called for its side effects. Returns \code{invisible(NULL)}.
}
\description{
\code{plot.shrinkTPR} generates a boxplot visualizing the posterior distribution of
\code{theta} obtained from a fitted \code{shrinkTPR} object.
}
\examples{
\donttest{
# Simulate and fit a shrinkTPR model, then plot:
sim <- simGPR()
mod <- shrinkTPR(y ~ ., data = sim$data)
plot(mod)

## Change axis label orientation
plot(mod, las = 1)
}

}
\seealso{
Other plotting functions: 
\code{\link{plot.shrinkGPR}()},
\code{\link{plot.shrinkGPR_marg_samples_1D}()},
\code{\link{plot.shrinkGPR_marg_samples_2D}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
