% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourPoints.R
\name{contourPoints}
\alias{contourPoints}
\title{Contour Lines to Points}
\usage{
contourPoints(object, depths = NULL, geometry = "geometry", density = 10)
}
\arguments{
\item{object}{polygon or multipolygon shapefile (.shp) with depths included as an attribute column. Can be an sf or spatVector object.}

\item{depths}{character string describing column name of depth attribute}

\item{geometry}{character string describing column name of geometries. Default = "geometry"}

\item{density}{numeric value describing distance between points in meters, default = 10m}
}
\value{
dataframe of coordinates and associated depths
}
\description{
Get point coordinates and depth values along predetermined contours at a specified density.
}
\examples{
# load test data
data <- sf::read_sf(system.file("extdata", "example_contour.shp", package = 'rLakeHabitat'))
#run function
contourPoints(data, depths = "Z", geometry = "geometry", density = 50)
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
