% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_pars.R
\name{test_parameters}
\alias{test_parameters}
\alias{find_par_names}
\title{Test All Free Parameters}
\usage{
test_parameters(
  fit = fit,
  standardized = FALSE,
  pars = NULL,
  op = NULL,
  remove.nonfree = TRUE,
  check_post_check = TRUE,
  ...,
  omnibus = c("no", "all_sig", "at_least_one_sig", "at_least_k_sig"),
  at_least_k = 1,
  fit_name = "fit",
  get_map_names = FALSE,
  get_test_name = FALSE
)

find_par_names(object, fit_name = "fit")
}
\arguments{
\item{fit}{The fit object, to be
passed to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}},
or \code{\link[lmhelprs:lm_list_to_partable]{lmhelprs::lm_list_to_partable()}}.}

\item{standardized}{Logical. If \code{TRUE},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}} will
be used. Can be used only with models
fitted by \code{lavaan}.}

\item{pars}{Optional. If set to
a character vector, only parameters
with \code{test_label} equal to values in
\code{pars} will be returned. See the
help page
on valid names.}

\item{op}{Optional. If set to a
character vector, only parameters with
operators (e.g., \code{"~"}, \code{"=~"}) will
be returned. If both \code{pars} and \code{op}
are specified, only parameters meeting
\emph{both} requirements will be returned.}

\item{remove.nonfree}{Logical. If
\code{TRUE}, the default, only free
parameters will be returned. Ignored
if \code{standardized} is \code{TRUE} or
if the model is not fitted by
\code{lavaan}.}

\item{check_post_check}{Logical. If
\code{TRUE}, the default, and the model
is fitted by \code{lavaan}, the test
will be conducted only if the model
passes the \code{post.check} conducted
by \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} (with
\code{what = "post.check"}).}

\item{...}{Additional arguments to
be passed to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}},
or \code{\link[lmhelprs:lm_list_to_partable]{lmhelprs::lm_list_to_partable()}}.}

\item{omnibus}{If \code{"no"}, the default,
then the test results for all paths
are stored. If \code{"all_sig"}, then
only one row of test is stored, and
the test is declared significant if
\emph{all} paths are significant. If
\code{"at_least_one_sig"}, then only
one row of test is stored, and the
test is declared significant if
at least one of the paths is
significant. If \code{"at_least_k_sig"},
then only one row of test is stored,
and the test is declared significant
if at least \code{k} of the paths is
significant, \code{k} determined by the
argument \code{at_least_k}.}

\item{at_least_k}{The minimum number
of paths required to be significant
for the omnibus test to be considered
significant. Used when
\code{omnibus} is \code{"at_least_k_sig"}.}

\item{fit_name}{The name of the fit
results for which the parameter names
will be displayed. Default is \code{"fit"}.}

\item{get_map_names}{Logical. Used
by \code{\link[=power4test]{power4test()}} to determine how
to extract stored information and
assign them to this function. Users
should not use this argument.}

\item{get_test_name}{Logical. Used
by \code{\link[=power4test]{power4test()}} to get the default
name of this test. Users should not
use this argument.}

\item{object}{A \code{power4test} object.}
}
\value{
In its normal usage, it returns
the output returned by
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
or \code{\link[lmhelprs:lm_list_to_partable]{lmhelprs::lm_list_to_partable()}},
with the following modifications:
\itemize{
\item \code{est}: The parameter estimates,
even if standardized estimates
are requested (not \code{est.std}).
\item \code{cilo} and \code{cihi}: The
lower and upper limits of the
confidence interval (95\% by
default), respectively (not
\code{ci.lower} and \code{ci.upper}).
\item \code{sig}: Whether a test by confidence
interval is significant (\code{1}) or
not significant (\code{0}).
\item \code{test_label}: A column of labels
generated by
\code{\link[lavaan:lav_partable]{lavaan::lav_partable_labels()}},
which are usually the labels used by
\code{coef()} to label the parameters.
}
}
\description{
Test all free parameters,
including user-defined parameters,
for a \code{power4test} object.
}
\details{
This function is to be used in
\code{\link[=power4test]{power4test()}} for testing all
free and user-defined model
parameters, by
setting it to the \code{test_fun}
argument.

For models fitted by \code{lavaan},
it uses \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
to do the test. If bootstrapping was
requested (by setting \code{se = "boot"}),
then it supports bootstrap
confidence intervals returned by
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.

It has preliminary, though limited,
supported for models fitted by
\code{\link[stats:lm]{stats::lm()}} (through
\code{\link[lmhelprs:many_lm]{lmhelprs::many_lm()}}). Tests are
conducted by ordinary least squares
confidence intervals based on
the \emph{t} statistic, reported by
\code{\link[stats:confint]{stats::confint()}} applied to
the output of \code{\link[stats:lm]{stats::lm()}}.
}
\section{Find the names of parameters}{
To use the argument \code{pars}, the
names as appeared in the function
\code{\link[=coef]{coef()}} must be used. For the
output of \code{lavaan}, this can
usually be inferred from the
parameter syntax (e.g., \code{y~x},
no space). If not sure, call
\code{\link[=coef]{coef()}} on the output of \code{lavaan}.
If a parameter is labelled, then
the label should be used in \code{par}.

If not sure, the function
\code{\link[=find_par_names]{find_par_names()}} can be used to
find valid names.
}

\examples{

# Specify the model

mod <-
"
m ~ x
y ~ m + x
"

# Specify the population values

mod_es <-
"
y ~ m: l
m ~ x: m
y ~ x: n
"

# Simulate the data

sim_only <- power4test(nrep = 2,
                       model = mod,
                       pop_es = mod_es,
                       n = 100,
                       do_the_test = FALSE,
                       iseed = 1234)

# Do the tests in each replication

test_out <- power4test(object = sim_only,
                       test_fun = test_parameters)

print(test_out,
      test_long = TRUE)

# Do the tests in each replication: Standardized solution
# Delta method SEs will be used to do the tests

test_out <- power4test(object = sim_only,
                       test_fun = test_parameters,
                       test_args = list(standardized = TRUE))

print(test_out,
      test_long = TRUE)

# Do the tests in each replication: Parameters with the selected operator

test_out <- power4test(object = sim_only,
                       test_fun = test_parameters,
                       test_args = list(op = "~"))

print(test_out,
      test_long = TRUE)


# Finding valid parameter names

find_par_names(sim_only)

}
\seealso{
\code{\link[=power4test]{power4test()}}
}
