% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_scores.R
\name{scores}
\alias{scores}
\alias{score_dataset}
\alias{score_obs_no}
\alias{score_var_no}
\alias{score_completeness}
\alias{score_date_consistency}
\alias{score_date_scope}
\alias{score_obs_info}
\alias{score_coding}
\alias{score_comments}
\alias{score_var_info}
\title{Scoring Functions for Data Quality Checks}
\usage{
score_dataset(df)

score_obs_no(df)

score_var_no(df)

score_completeness(df)

score_date_consistency(df)

score_date_scope(df)

score_obs_info(df, id_col = "ID")

score_coding(df)

score_comments(df)

score_var_info(df)
}
\arguments{
\item{df}{A data frame to be scored.}

\item{id_col}{The name of the column containing IDs.
Default is "ID".}
}
\description{
A set of functions to assess various aspects of data quality.
including a comprehensive dataset score as well as individual scores
for specific data quality dimensions such as
date consistency, duplicates, recency, frequency, time, coding,
comments, sources, missing values, and variables.

According to the literature, data quality can be assessed
by checking for consistency, completeness, accuracy, timeliness, and
uniqueness of the data.
Consistency means that the data is logically coherent,
completeness means that all required data is present,
accuracy means that the data is correct and reliable,
timeliness means that the data is up-to-date,
and uniqueness means that there are no duplicate records.
}
\details{
These functions are designed to help assess the quality of data in a data frame.
Each function checks a specific aspect of the data and returns a score or
a message indicating the quality of that aspect.
The functions include:
\itemize{
\item \code{score_date_consistency}: Proportion of invalid date pairs (End <= Begin).
\item \code{score_duplicates}: Proportion of duplicate IDs.
}
}
\examples{
score_dataset(emperors)
score_obs_no(emperors)
score_var_no(emperors)
score_completeness(emperors)
score_date_consistency(emperors)
score_date_scope(emperors)
score_obs_info(emperors)
score_var_info(emperors)
}
\references{
Wang, R. Y., & Strong, D. M. (1996). Beyond accuracy: What data quality means to data consumers.
Journal of Management Information Systems, 12(4), 5-34.
}
