% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topics.R
\name{locale}
\alias{locale}
\title{Localize formatting and symbols}
\description{
Localize formatting and symbols
}
\section{Specify locale}{
\code{gt()}, some \verb{cols_*()} and \verb{fmt_*()} functions have a \code{locale} argument.
You can pass \code{locale} as a 2 letters string or 4. (e.g. \code{"fr"} for French,
\code{"pt-BR"} for Brazilian Portuguese). gt also resolves different spellings
internally as much as possible. For example \code{"en_GB"} will work out of the
box.
}

\section{Range of action of locale}{
One of the advantage of using gt its consistency in using symbols and currencies
in multiple languages

There are two ways to localize your results with gt.
\itemize{
\item Passing it \strong{globally} \code{gt(locale = "<locale>")}
}

Will localize everything possible in the \code{gt()} pipeline.
\itemize{
\item In individual \code{fmt_()} functions
\item Localize buttons in \code{\link[=opt_interactive]{opt_interactive()}}
}

Will only affect the output of one specific function (or override global setting).

\code{locale} has very low precedence usually. As soon as you override some parameters,
\code{sep_mark}, \code{dec_mark}, \code{incl_space}, they will be override \code{locale}.
}

\examples{
# The Spanish locale uses `.` as thousands sep (English uses ,), and
# uses , as the decimal mark

# Using the locale in gt() will format automatically all output in subsequent
# fmt_*() calls.
exibble \%>\%
  gt(locale = "es-AR") \%>\%
  fmt_number()

# Only format currency as mexican peso

exibble \%>\%
  gt(locale = "fr") \%>\%
  fmt_currency(currency, locale = "es-MX")

# will use sep_mark provided
exibble \%>\%
  gt(locale = "fr") \%>\%
  fmt_currency(currency, sep_mark = "", locale = "es-MX")
# Use your imagination, and mix and match.

}
\seealso{
\code{\link[=info_locales]{info_locales()}}, \code{\link[=info_flags]{info_flags()}}
}
