% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data.R
\name{batch_extract}
\alias{batch_extract}
\title{Extracts data from all cdf files in a folder.}
\usage{
batch_extract(path = ".", mod_t = 10, shift_time = TRUE)
}
\arguments{
\item{path}{a \emph{string} object. The path of the folder containing  the
cdf files to be opened. Default is the current working directory.}

\item{mod_t}{a \emph{float} object. The modulation time for the GCxGC sample
analysis. Default is 10.}

\item{shift_time}{a \emph{boolean} object. Determines whether the Overall
Time Index should be shifted to 0. Default is TRUE.}
}
\value{
A \emph{list} object. A list of the extracted data from each file.
Each list item is a list of twSo data frames, TIC and full MS data.
}
\description{
\code{batch_extract} Extracts the data from all cdf files in a folder.
}
\details{
This function opens all cdf files in the specified folder path using
extract_data().
}
\examples{
folder <- system.file("extdata",package="gcxgclab")
data_list <- batch_extract(folder,mod_t=.5)

}
\references{
\insertAllCited{}
}
